import { __ } from '@wordpress/i18n';
// import { dispatch, useSelect, useDispatch } from '@wordpress/data';
import SingleChoice from './answers-types/single-choice'
import MultiChoice from './answers-types/multi-choice';
import OpenTextField from './answers-types/open-text-field';
import arrayMove from '../../multistep-lead-form/utils/arrayMove';

const ChoicesComponent = ({
    attributes,
    setAttributes,
    answerType,
    interactiveBlocksOptions,
    answersStats,
}) => {
    const addAnswer = (answer) => {
        setAttributes({
            answers: [
                ...attributes.answers,
                answer
            ]
        });
    };

    const updateAnswer = (i, field, newValue) => {
        attributes.answers[i][field] = newValue;

        setAttributes({
            answers: [
                ...attributes.answers
            ]
        });
    };

    const removeAnswer = (index) => {
        const answers = attributes.answers.filter((value, i) => {
            return index != i;
        });

        setAttributes({
            answers: answers
        });
    };

    const addButton = (btn) => {
        setAttributes({
            buttons: [
                ...attributes.buttons,
                btn
            ]
        });
    };

    const updateButton = (i, field, newValue) => {
        attributes.buttons[i][field] = newValue;

        setAttributes({
            buttons: [
                ...attributes.buttons
            ]
        });
    };

    const removeButton = (index) => {
        const buttons = attributes.buttons.filter((value, i) => {
            return index != i;
        });

        setAttributes({
            buttons: buttons
        });
    };

    const moveItemUp = (itemKey, index) => {
        if (
            attributes[itemKey].length > 1
            && index > 0
        ) {
            const items = [...attributes[itemKey]];

            arrayMove(items, index, index - 1);
            setAttributes({
                [itemKey]: items,
            });
        }
    };

    const moveItemDown = (itemKey, index) => {
        if (
            attributes[itemKey].length > 1
            && index + 1 <= attributes[itemKey].length
        ) {
            const items = [...attributes[itemKey]];

            arrayMove(items, index, index + 1);
            setAttributes({
                [itemKey]: items,
            });
        }
    };

    if ('single' == answerType) {
        return (
            <SingleChoice
                attributes={ attributes }
                setAttributes={ setAttributes }
                interactiveBlocksOptions={ interactiveBlocksOptions }
                addButton={ addButton }
                updateButton={ updateButton }
                removeButton={ removeButton }
                moveItemUp={ moveItemUp }
                moveItemDown={ moveItemDown }
                answersStats={ answersStats }
            />
        );

    } else if ('multi' == answerType) {
        return (
            <MultiChoice
                attributes={ attributes }
                setAttributes={ setAttributes }
                interactiveBlocksOptions={ interactiveBlocksOptions }
                addAnswer={ addAnswer }
                updateAnswer={ updateAnswer }
                removeAnswer={ removeAnswer }
                updateButton={ updateButton }
                moveItemUp={ moveItemUp }
                moveItemDown={ moveItemDown }
                answersStats={ answersStats }
            />
        );

    } else if ('textfield' == answerType) {
        return (
            <OpenTextField
                attributes={ attributes }
                setAttributes={ setAttributes }
                interactiveBlocksOptions={ interactiveBlocksOptions }
                updateAnswer={ updateAnswer }
                updateButton={ updateButton }
            />
        );
    }
};

export default ChoicesComponent;