import { __ } from '@wordpress/i18n';
import { RangeControl, TextareaControl, SelectControl, __experimentalText as Text, Flex, FlexItem, Button } from '@wordpress/components';
import GradientButton from './gradient-button';

const GenerateImage = ({
    generateClickHandler,
    userPrompt, setUserPrompt,
    generatedImages,
    setShowGenerateForm,
    style,
    setStyle,
    width,
    setWidth,
    height,
    setHeight
}) => {
    return (
        <div className="seoaic-generated-images">
            <Text
                variant="subtitle"
                isBlock="true"
                className="seoaic-field-title"
            >
                { __("Image Prompt", "seoaic") }
            </Text>
            <TextareaControl
                rows={5}
                value={ userPrompt }
                onChange={ e => setUserPrompt(e) }
                placeholder={ __("Put your image description here", "seoaic") }
            />
            <div className="seoaic-image-size-controls-container">
                <RangeControl
                    label="Width"
                    value={width}
                    step={32}
                    name="thumbnail_width"
                    onChange={(newWidth) => setWidth(newWidth)}
                    min={256}
                    max={1440}
                    className="seoaic-image-size-control"
                />
                <RangeControl
                    label="Height"
                    value={height}
                    step={32}
                    name="thumbnail_height"
                    onChange={(newHeight) => setHeight(newHeight)}
                    min={256}
                    max={1440}
                    className="seoaic-image-size-control"
                />
            </div>
            <SelectControl
                label="Choose a style"
                value={ style }
                name="thumbnail_style"
                options={ [
                    { label: 'Illustrations', value: 'Illustrations' },
                    { label: 'Photorealism', value: 'Photorealism' },
                    { label: 'Digital art', value: 'Digital art' },
                    { label: 'Minimalism', value: 'Minimalism' },
                    { label: 'Collages', value: 'Collages' },
                ] }
                onChange={(newStyle) => setStyle(newStyle)}
            />
            <Flex justify="space-between">
                <FlexItem>
                    <GradientButton
                        label={ __("Generate", "seoaic") }
                        onClick={ generateClickHandler }
                    />
                </FlexItem>
                <FlexItem>
                    <Button
                        label={ __("Back to images", "seoaic") }
                        onClick={ generateClickHandler }
                    />
                    { generatedImages.length > 0 &&
                        <Button
                            variant="link"
                            onClick={ () => {
                                setShowGenerateForm(false);
                            } }
                        >
                            { __("Back to images", "seoaic") }
                        </Button>
                    }
                </FlexItem>
            </Flex>
        </div>
    );
};

export default GenerateImage;
