import { __ } from '@wordpress/i18n';
import { Flex, FlexBlock, Icon } from '@wordpress/components';
import GradientButton from './gradient-button';

const ButtonsBar = ({
    isGenerating,
    isUseBusy,
    generateClickHandler,
    improveClickHandler,
    useClickHandler,
    selectedImg
}) => {
    return (
        <Flex
            className="seoaic-generate-image-buttons-wrpaper"
            justify="space-between"
            align="center"
            gap={2}
        >
            <FlexBlock className="buttons-group">
                <Flex
                    justify="end"
                    align="center"
                    gap={2}
                >
                    <GradientButton
                        label={ __("Use", "seoaic") }
                        onClick={ useClickHandler }
                        disabled={ isGenerating || !selectedImg }
                        isBusy={ isUseBusy }
                    />
                    <GradientButton
                        label={ __("Regenerate", "seoaic") }
                        icon={ <Icon icon="update" /> }
                        iconPosition="left"
                        onClick={ generateClickHandler }
                        disabled={ isGenerating }
                    />
                    <GradientButton
                        label={ __("Improve", "seoaic") }
                        icon={ <Icon icon="arrow-up-alt" /> }
                        iconPosition="left"
                        onClick={ improveClickHandler }
                        disabled={ isGenerating }
                    />
                </Flex>
            </FlexBlock>
        </Flex>
    );
};

export default ButtonsBar;