import FAQRepeaterBlock from './components/faq-repeater-block';
import { useBlockProps } from '@wordpress/block-editor';
import { __ } from '@wordpress/i18n';

/**
 * Lets webpack process CSS, SASS or SCSS files referenced in JavaScript files.
 * Those files can contain any CSS code that gets applied to the editor.
 *
 * @see https://www.npmjs.com/package/@wordpress/scripts#using-css
 */
import './editor.scss';
import ModeSelector from './components/mode-selector';
import GenerateFAQ from './components/generate-faq';

/**
 * The edit function describes the structure of your block in the context of the
 * editor. This represents what the editor will render when the block is used.
 *
 * @see https://developer.wordpress.org/block-editor/reference-guides/block-api/block-edit-save/#edit
 *
 * @return {Element} Element to render.
 */
export default function Edit({ attributes, setAttributes }) {
    const manualMode = 'manual';
    const generateMode = 'generate';

    const setGenerateMode = () => {
        setAttributes({ mode: generateMode });
    };

    const setManualMode = () => {
        setAttributes({
            mode: manualMode
        });
    };

    return (
        <div { ...useBlockProps() }>
            <div className="seoaic-faq-block">
                <ModeSelector
                    attributes={ attributes }
                    setGenerateMode={ setGenerateMode }
                    setManualMode={ setManualMode }
                />
                {
                    (
                        manualMode == attributes.mode
                        || attributes.questions
                    )
                    ? <FAQRepeaterBlock
                        attributes={ attributes }
                        setAttributes={ setAttributes }
                    />
                    : (
                        generateMode == attributes.mode
                    )
                    && <GenerateFAQ
                        attributes={ attributes }
                        setAttributes={ setAttributes }
                        manualMode={ manualMode }
                    />
                }
            </div>
        </div>
    );
}
