import { useBlockProps } from '@wordpress/block-editor';
import { createElement } from '@wordpress/element';

const v1 = {
    attributes: {
        questions: {
            type: "array"
        }
    },
    save: ( { attributes } ) => {
        const questions = attributes.questions || [];

        return !questions.length ? null : createElement(
            "div",
            { ...useBlockProps.save() },
            questions.map((item, index) => {
                return "" == item.title || "" == item.content ? null : createElement(
                    "div",
                    {
                        className: "seoaic-faq-item",
                    },
                    createElement(
                        "h3",
                        {
                            className: "seoaic-question"
                        },
                        item.title
                    ), createElement(
                        "div",
                        {
                            className: "seoaic-answer"
                        },
                        item.content
                    )
                );
            })
        );
    },
};

export default [ v1 ];