import { __ } from '@wordpress/i18n';
import { Button, Icon, Flex, FlexBlock, FlexItem } from '@wordpress/components';
import { RichText } from '@wordpress/block-editor'

const FAQRepeater = ({
    repeaterValues,
    updateRepeaterValues,
    removeFAQ,
}) => {
    const setFieldHandler = (id, field, value) => {
        const values = repeaterValues.map((row, index) => {
			return row.id === id ? {...row, [field]: value} : row
		});

        updateRepeaterValues(values);
    };

    return <Flex direction="column" gap={3} className="seoaic-faq-flex-wrapper">
        { repeaterValues.map((row, index) => {
            return <div className="seoaic-repeater-item">
                <Flex align="start">
                    <FlexBlock>
                        <RichText
                            tagName="div"
                            allowedFormats={ [] }
                            value={ row.title }
                            placeholder={ __('Question', 'seoaic') }
                            onChange={ (value) => setFieldHandler(row.id, 'title', value) }
                            className="seoaic-faq-question"
                        />
                        <RichText
                            tagName="div"
                            allowedFormats={ [] }
                            value={ row.content }
                            placeholder={ __('Answer', 'seoaic') }
                            onChange={ (value) => setFieldHandler(row.id, 'content', value) }
                            className="seoaic-faq-answer"
                        />
                    </FlexBlock>
                    <FlexItem className="seoaic-faq-remove-wrapper">
                        {
                            1 < repeaterValues.length
                            && (
                                <Button
                                    label={ __('Remove', 'seoaic') }
                                    icon={ <Icon icon="dismiss" /> }
                                    className="seoaic-faq-remove"
                                    onClick={ () => {removeFAQ(row.id)} }
                                ></Button>
                            )
                        }
                    </FlexItem>
                </Flex>
            </div>
        }) }
    </Flex>
};

export default FAQRepeater;