<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Schedule\Delay;

final class MaxDelay implements Delay
{
    /**
     * @var int
     */
    private $maxDelay;

    /**
     * @param int $maxDelay
     */
    public function __construct(int $maxDelay)
    {
        $this->maxDelay = abs($maxDelay);
    }

    /**
     * @param int $index
     * @param int $total
     * @param array $args
     * @return int
     */
    public function calculate(int $index, int $total, array $args = null): int
    {
        return (int)ceil(($this->maxDelay * $index) / $total);
    }
}
