<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\MediaLibrary\Settings;

/**
 * Represents the MediaLibrary setting.
 */
interface MediaLibrarySetting
{
    /**
     * The key of the setting.
     *
     * @return string
     */
    public function key(): string;

    /**
     * The setting label.
     *
     * @return string
     */
    public function label(): string;

    /**
     * Renders the setting with given arguments.
     *
     * @param array<string, scalar> $args A map of argument keys to values to use for the render.
     */
    public function render(array $args = []): void;
}
