<?php

declare(strict_types=1);

use Inpsyde\MultilingualPress\Attachment\Copier;
use Inpsyde\MultilingualPress\Framework\Admin\SettingsPageView;
use Inpsyde\MultilingualPress\Framework\Factory\NonceFactory;
use Inpsyde\MultilingualPress\Framework\Http\RequestHandler;
use Inpsyde\MultilingualPress\Framework\Service\Container;
use Inpsyde\MultilingualPress\MediaLibrary\BulkCopyAttachments\BulkCopyAttachmentsRequestHandler;
use Inpsyde\MultilingualPress\MediaLibrary\BulkCopyAttachments\BulkCopyAttachmentsSettingsView;
use Inpsyde\MultilingualPress\MediaLibrary\ServiceProvider as MediaLibraryModule;
use Inpsyde\MultilingualPress\MediaLibrary\Settings\RelatedSitesSetting;
use Inpsyde\MultilingualPress\Core\ServiceProvider as CoreModule;

use function Inpsyde\MultilingualPress\siteNameWithLanguage;

(static function (Container $container) {
    $container->share(
        BulkCopyAttachmentsSettingsView::class,
        static function (Container $container): SettingsPageView {
            return new BulkCopyAttachmentsSettingsView(
                $container->get(NonceFactory::class)->create(['mlp_bulk_copy_media_action']),
                $container->get(RelatedSitesSetting::class),
                $container->get(MediaLibraryModule::PARAMETER_CONFIG_SETTINGS_TITLE)
            );
        }
    );

    $container->share(
        BulkCopyAttachmentsRequestHandler::class,
        static function (Container $container): RequestHandler {
            return new BulkCopyAttachmentsRequestHandler(
                $container->get(NonceFactory::class)->create(['mlp_bulk_copy_media_action']),
                $container->get(Copier::class)
            );
        }
    );

    /**
     * Configuration for Media Library MLP bulk actions key prefix.
     */
    $container->share(
        MediaLibraryModule::PARAMETER_CONFIG_BULK_ACTIONS_KEY_PREFIX,
        static function (): string {
            return "mlp-bulk-copy-to-site-";
        }
    );

    /**
     * Configuration for Media Library MLP bulk actions.
     *
     * This is used when Media Library is in "List Mode" view.
     *
     * @return array<string, string> A map of MLP bulk action keys to names.
     */
    $container->share(
        MediaLibraryModule::PARAMETER_CONFIG_BULK_ACTIONS,
        static function (Container $container): array {
            $relatedSites = $container->get(CoreModule::PARAMETER_CONFIG_RELATED_SITES);
            $bulkActionsKeyPrefix = $container->get(MediaLibraryModule::PARAMETER_CONFIG_BULK_ACTIONS_KEY_PREFIX);
            $bulkActions = [];

            foreach ($relatedSites as $siteId => $language) {
                $siteName = siteNameWithLanguage($siteId);
                $actionKey = "{$bulkActionsKeyPrefix}{$siteId}";

                $actionName = sprintf(
                /* translators: %1$s is the site name. */
                    __('Copy to site: %1$s', 'multilingualpress'),
                    esc_html($siteName)
                );

                $bulkActions[$actionKey] = $actionName;
            }

            return $bulkActions;
        }
    );
}
)($container); //phpcs:disable VariableAnalysis.CodeAnalysis.VariableAnalysis.UndefinedVariable
