<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\MediaLibrary\BulkCopyAttachments;

use Inpsyde\MultilingualPress\Framework\Admin\SettingsPageView;
use Inpsyde\MultilingualPress\Framework\Nonce\Nonce;
use Inpsyde\MultilingualPress\MediaLibrary\Settings\MediaLibrarySetting;

class BulkCopyAttachmentsSettingsView implements SettingsPageView
{
    public const ACTION = 'multilingualpress.MediaLibrary.BulkCopyAttachmentsSettingsView';

    /**
     * @var Nonce
     */
    protected $nonce;

    /**
     * @var MediaLibrarySetting
     */
    protected $relatedSitesSetting;

    /**
     * @var string
     */
    protected $settingsTitle;

    public function __construct(
        Nonce $nonce,
        MediaLibrarySetting $relatedSitesSetting,
        string $settingsTitle
    ) {

        $this->nonce = $nonce;
        $this->relatedSitesSetting = $relatedSitesSetting;
        $this->settingsTitle = $settingsTitle;
    }

    /**
     * @inheritdoc
     */
    public function render()
    {
        ?>
        <div class="multilingualpress-bulk-copy-media-setting media-toolbar-secondary" style="display: none;">
            <h3><?= esc_html($this->settingsTitle);?></h3>
            <?php
            $this->renderLabel($this->relatedSitesSetting->label());
            $this->relatedSitesSetting->render();
            $this->renderButton();
            $this->renderNonce();
            ?>
        </div>
        <?php
    }

    /**
     * Renders the label.
     *
     * @param string $label The label.
     * @return void
     */
    protected function renderLabel(string $label): void
    {
        ?>
        <h4><?= esc_html($label);?></h4>
        <?php
    }

    /**
     * Renders the button.
     *
     * @return void
     */
    protected function renderButton(): void
    {
        ?>
        <button
            type="button"
            class="button media-button button-primary button-large mlp-media-library-copy-selected-items"
            disabled="disabled"
            data-nonce-action="<?= esc_attr($this->nonce->action());?>"
            data-nonce="<?= esc_attr($this->nonce);?>">
            <?= esc_html__('Copy', 'multilingualpress');?>
        </button>
        <?php
    }

    /**
     * Renders the nonce input.
     */
    protected function renderNonce(): void
    {
        $nonceAction = $this->nonce->action();
        $nonceValue = (string)$this->nonce;
        ?>
            <input type="hidden" name="<?= esc_attr($nonceAction); ?>" value="<?= esc_attr($nonceValue); ?>">
        <?php
    }
}
