<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Core\Admin;

use Inpsyde\MultilingualPress\Framework\Setting\Site\SiteSettingsSectionViewModel;
use Inpsyde\MultilingualPress\Framework\Setting\Site\SiteSettingView;

final class SiteSettings implements SiteSettingsSectionViewModel
{
    public const ID = 'mlp-site-settings';

    /**
     * @var SiteSettingView
     */
    protected $view;

    /**
     * SiteSettings constructor.
     * @param SiteSettingView $view
     */
    public function __construct(SiteSettingView $view)
    {
        $this->view = $view;
    }

    /**
     * @inheritdoc
     */
    public function id(): string
    {
        return static::ID;
    }

    /**
     * @inheritdoc
     */
    public function renderView(int $siteId): bool
    {
        return $this->view->render($siteId);
    }

    /**
     * @inheritdoc
     */
    public function title(): string
    {
        return '';
    }
}
