<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\WooCommerce\TranslationUi\Product;

use Inpsyde\MultilingualPress\Module\WooCommerce\TranslationUi\Product\Field;
use Inpsyde\MultilingualPress\TranslationUi\Post;

/**
 * MultilingualPress WooCommerce Metabox Fields
 */
class MetaboxFields
{
    public const TAB = 'tab-product';

    public const FIELD_PRODUCT_URL = 'product_url';
    public const FIELD_PRODUCT_URL_BUTTON_TEXT = 'button_text';
    public const FIELD_OVERRIDE_PRODUCT_TYPE = 'override_product_type';
    public const FIELD_OVERRIDE_PRODUCT_GALLERY = 'override_product_gallery';
    public const FIELD_OVERRIDE_VARIATIONS = 'override_attribute_variations';
    public const FIELD_OVERRIDE_ATTRIBUTES = 'override_attributes';
    public const FIELD_OVERRIDE_DOWNLOADABLE_FILES = 'override_downloadable_files';
    public const FIELD_OVERRIDE_DOWNLOADABLE_SETTINGS = 'override_downloadable_settings';
    public const FIELD_OVERRIDE_INVENTORY_SETTINGS = 'override_inventory_settings';
    public const FIELD_REGULAR_PRICE = 'regular_price';
    public const FIELD_SALE_PRICE = 'sale_price';
    public const FIELD_PRODUCT_SHORT_DESCRIPTION = 'product_short_description';
    public const FIELD_PURCHASE_NOTE = 'purchase_note';
    public const FIELD_SKU = 'sku';
    public const FIELD_MANAGE_STOCK = 'manage_stock';
    public const FIELD_SOLD_INDIVIDUALLY = 'sold_individually';
    public const FIELD_STOCK = 'stock';
    public const FIELD_BACKORDERS = 'backorders';
    public const FIELD_STOCK_STATUS = 'stock_status';
    public const FIELD_LOW_STOCK_AMOUNT = 'low_stock_amount';
    public const FIELD_GROUPED_PRODUCTS = 'grouped_products';
    public const FIELD_CROSSELLS_PRODUCTS = 'crossells_products';
    public const FIELD_UPSELLS_PRODUCTS = 'upsells_products';

    /**
     * @var WooCommerceMetaboxFields
     */
    private $wooCommerceFields;

    /**
     * MetaboxFields constructor.
     * @param WooCommerceMetaboxFields $wooCommerceFields
     */
    public function __construct(WooCommerceMetaboxFields $wooCommerceFields)
    {
        $this->wooCommerceFields = $wooCommerceFields;
    }

    /**
     * Retrieve all fields for the WooCommerce metabox tab.
     *
     * @return MetaboxTab[]
     * phpcs:disable Inpsyde.CodeQuality.FunctionLength.TooLong
     */
    public function allFieldsTabs(): array
    {
        // phpcs:enable

        return [
            new MetaboxTab(
                MetaboxFields::TAB,
                _x('Product Data', 'translation post metabox', 'multilingualpress'),
                new Post\MetaboxField(
                    MetaboxFields::FIELD_PRODUCT_SHORT_DESCRIPTION,
                    new Field\ShortDescription()
                ),
                new Post\MetaboxField(
                    self::FIELD_OVERRIDE_PRODUCT_TYPE,
                    new Field\OverrideProductType()
                ),
                new Post\MetaboxField(
                    self::FIELD_OVERRIDE_ATTRIBUTES,
                    new Field\OverrideAttributes()
                ),
                new Post\MetaboxField(
                    self::FIELD_OVERRIDE_VARIATIONS,
                    new Field\OverrideVariations()
                ),
                new Post\MetaboxField(
                    MetaboxFields::FIELD_OVERRIDE_DOWNLOADABLE_FILES,
                    new Field\OverrideDownloadableFiles()
                ),
                new Post\MetaboxField(
                    MetaboxFields::FIELD_OVERRIDE_DOWNLOADABLE_SETTINGS,
                    new Field\OverrideDownloadableSettings()
                ),
                new Post\MetaboxField(
                    MetaboxFields::FIELD_OVERRIDE_PRODUCT_GALLERY,
                    new Field\OverrideProductGallery()
                ),
                new Post\MetaboxField(
                    MetaboxFields::FIELD_GROUPED_PRODUCTS,
                    new Field\OverrideGroupedProducts()
                ),
                new Post\MetaboxField(
                    MetaboxFields::FIELD_UPSELLS_PRODUCTS,
                    new Field\OverrideUpsellsProducts()
                ),
                new Post\MetaboxField(
                    MetaboxFields::FIELD_CROSSELLS_PRODUCTS,
                    new Field\OverrideCrossellsProducts()
                ),
                new Post\MetaboxField(
                    MetaboxFields::FIELD_OVERRIDE_INVENTORY_SETTINGS,
                    new Field\Inventory\OverrideInventorySettings()
                ),
                ...$this->wooCommerceFields->generalSettingFields(),
                ...$this->wooCommerceFields->inventorySettingFields(),
                ...$this->wooCommerceFields->advancedSettingFields()
            ),
        ];
    }
}
