(function(){"use strict";var __webpack_modules__={320:function(){eval("\n;// CONCATENATED MODULE: ./build/src/modules/Redirect/resources/js/Redirector.js\n/**\n * The MultilingualPress Redirector module.\n */\nfunction Redirector(languagesStorageKey, timestampStorageKey, redirectSettings, navigator, localStorage) {\n  var settings;\n  var noredirect;\n  var noRedirectRegex;\n  var init = false;\n\n  /**\n   * Checks if the stored timestamp is valid.\n   *\n   * @return {Boolean} Whether or not the stored timestamp is valid.\n   */\n  var checkTimestamp = function checkTimestamp() {\n    var timestamp = Number(localStorage.getItem(timestampStorageKey));\n    return Date.now() <= timestamp + Number(settings.storageLifetime);\n  };\n\n  /**\n   * Starts the continuously running timestamp update used to determine the age of stored languages.\n   */\n  var startTimestampUpdate = function startTimestampUpdate() {\n    var timeout = Number(settings.updateTimestampInterval);\n    var updateTimestamp;\n    if (timeout > 0) {\n      updateTimestamp = function updateTimestamp() {\n        localStorage.setItem(timestampStorageKey, Date.now());\n      };\n      updateTimestamp();\n      setInterval(updateTimestamp, timeout);\n    }\n  };\n\n  /**\n   * Returns the given language in the normalized, locale-like form.\n   *\n   * @param {String} language\n   * @return {String}\n   */\n  var normalizeLanguage = function normalizeLanguage(language) {\n    return language.replace(/-/, '_');\n  };\n\n  /**\n   * Returns the stored languages.\n   *\n   * @returns {String[]}\n   */\n  var storedLanguages = function storedLanguages() {\n    var languages;\n    if (!checkTimestamp()) {\n      localStorage.removeItem(languagesStorageKey);\n      return [];\n    }\n    languages = localStorage.getItem(languagesStorageKey);\n    return languages ? languages.split(' ') : [];\n  };\n\n  /**\n   * Checks if the current site language is stored to not get redirected from.\n   *\n   * @returns {Boolean}\n   */\n  var isCurrentLanguageStored = function isCurrentLanguageStored() {\n    return storedLanguages().includes(normalizeLanguage(settings.currentLanguage));\n  };\n\n  /**\n   * Stores the given language.\n   *\n   * @param {String} language\n   */\n  var storeLanguage = function storeLanguage(language) {\n    var languages = storedLanguages();\n    var normalizedLanguage = normalizeLanguage(language);\n    if (languages.includes(normalizedLanguage)) {\n      return;\n    }\n    languages.push(normalizedLanguage);\n    localStorage.setItem(languagesStorageKey, languages.join(' '));\n  };\n\n  /**\n   * Returns the noredirect language included in the request, if any.\n   *\n   * @returns {String} Language.\n   */\n  var noredirectLanguage = function noredirectLanguage() {\n    var matches;\n    if (typeof noredirect === 'string') {\n      return noredirect;\n    }\n    noredirect = '';\n    matches = noRedirectRegex.exec(window.location.href);\n    if (Array.isArray(matches) && matches[2]) {\n      noredirect = decodeURIComponent(matches[2].replace(/\\+/g, ' '));\n    }\n    return noredirect;\n  };\n\n  /**\n   * Redirects to the target URL.\n   */\n  var doRedirect = function doRedirect() {\n    var redirectTarget = settings.redirectTarget;\n    var language = Object.keys(redirectTarget)[0];\n    storeLanguage(language);\n    if (language === settings.currentLanguage) {\n      return;\n    }\n    var url = redirectTarget[language].replace(/\\?.*$/, '');\n    window.location.href = url + '?' + settings.noredirectKey + '=' + normalizeLanguage(language);\n  };\n\n  /**\n   * Inizialize the class if necessary.\n   */\n  var initialize = function initialize() {\n    if (!init) {\n      settings = redirectSettings || {\n        currentLanguage: '',\n        noredirectKey: '',\n        storageLifetime: 300000,\n        updateTimestampInterval: 60000,\n        redirectTarget: {}\n      };\n      startTimestampUpdate();\n      noRedirectRegex = new RegExp('[?&]' + settings.noredirectKey + '(=([^&#]*)|&|#|$)');\n      init = true;\n    }\n  };\n\n  /**\n   * Perform the redirect if needed.\n   */\n  this.redirect = function () {\n    initialize();\n    if (!settings.noredirectKey || !settings.redirectTarget || isCurrentLanguageStored()) {\n      return;\n    }\n    if (noredirectLanguage()) {\n      storeLanguage(noredirectLanguage());\n      return;\n    }\n    doRedirect();\n  };\n}\n;// CONCATENATED MODULE: ./build/src/modules/Redirect/resources/js/frontend.js\n\n(function (redirectSettings, navigator, localStorage) {\n  var redirector = new Redirector('mlpNoredirectStorage', 'mlpNoredirectStorageTimestamp', redirectSettings, navigator, localStorage);\n  redirector.redirect();\n})(MultilingualPressRedirectorSettings, navigator, localStorage);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///320\n")}},__webpack_exports__={};__webpack_modules__[320]()})();
//# sourceMappingURL=frontend.min.js.map