<?php

declare(strict_types=1);

use Inpsyde\MultilingualPress\Core\Admin\NewSiteSettings;
use Inpsyde\MultilingualPress\Core\Admin\PluginSettingsUpdater;
use Inpsyde\MultilingualPress\Core\Admin\SiteSettings;
use Inpsyde\MultilingualPress\Core\Admin\SiteSettingsUpdater;
use Inpsyde\MultilingualPress\Framework\Admin\SitesListTableColumn;
use Inpsyde\MultilingualPress\Framework\Factory\NonceFactory;
use Inpsyde\MultilingualPress\Framework\Http\ServerRequest;
use Inpsyde\MultilingualPress\Framework\Service\Container;
use Inpsyde\MultilingualPress\Framework\Setting\Site\SiteSetting;
use Inpsyde\MultilingualPress\Framework\Setting\Site\SiteSettingsSectionView;
use Inpsyde\MultilingualPress\Framework\Setting\Site\SiteSettingUpdater;
use Inpsyde\MultilingualPress\Framework\Setting\User\UserSetting;
use Inpsyde\MultilingualPress\Framework\Setting\User\UserSettingUpdater;
use Inpsyde\MultilingualPress\Module\Redirect\ServiceProvider as RedirectModule;
use Inpsyde\MultilingualPress\Module\Redirect\Settings\RedirectSiteSettings;
use Inpsyde\MultilingualPress\Module\Redirect\Settings\RedirectUserSetting;
use Inpsyde\MultilingualPress\Module\Redirect\Settings\Repository\Repository;
use Inpsyde\MultilingualPress\Module\Redirect\Settings\Updater;

(static function (Container $container) {

    $userSetting = new UserSetting(
        $container->get(RedirectUserSetting::class),
        new UserSettingUpdater(
            Repository::META_KEY_USER,
            $container->get(ServerRequest::class),
            $container->get(NonceFactory::class)->create([RedirectModule::SETTING_NONCE_ACTION . 'user'])
        )
    );
    $userSetting->register();

    $setting = new SiteSetting(
        $container->get(RedirectSiteSettings::class),
        new SiteSettingUpdater(
            Repository::OPTION_SITE,
            $container->get(ServerRequest::class),
            $container->get(NonceFactory::class)->create([RedirectModule::SETTING_NONCE_ACTION . 'site'])
        )
    );

    $setting->register(
        SiteSettingsSectionView::ACTION_AFTER . '_' . SiteSettings::ID,
        SiteSettingsUpdater::ACTION_UPDATE_SETTINGS
    );

    add_action(
        PluginSettingsUpdater::ACTION_UPDATE_PLUGIN_SETTINGS,
        [$container->get(Updater::class), 'updateSettings']
    );

    if (is_network_admin()) {
        global $pagenow;

        $setting->register(
            SiteSettingsSectionView::ACTION_AFTER . '_' . NewSiteSettings::SECTION_ID,
            SiteSettingsUpdater::ACTION_DEFINE_INITIAL_SETTINGS
        );

        if ('sites.php' !== ($pagenow ?? '')) {
            return;
        }

        $settingsRepository = $container->get(Repository::class);
        $sitesListTableColumn = new SitesListTableColumn(
            'multilingualpress.redirect',
            __('Redirect', 'multilingualpress'),
            static function (string $column, int $siteId) use ($settingsRepository): string {
                return $settingsRepository->redirectSiteSetting($siteId, Repository::OPTION_SITE_ENABLE_REDIRECT)
                    ? '<span class="dashicons dashicons-yes"></span>'
                    : '';
            }
        );

        $sitesListTableColumn->register();
    }
}
)($container); //phpcs:disable VariableAnalysis.CodeAnalysis.VariableAnalysis.UndefinedVariable
