<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\Redirect\Settings;

use Inpsyde\MultilingualPress\Framework\Http\Request;
use Inpsyde\MultilingualPress\Framework\Nonce\Nonce;
use Inpsyde\MultilingualPress\Module\Redirect\Settings\Repository\Repository;

/**
 * Class Updater
 * @package Inpsyde\MultilingualPress\Module\Redirect
 */
class Updater
{
    /**
     * @var Nonce
     */
    private $nonce;

    /**
     * @var Repository
     */
    private $repository;

    /**
     * Updater constructor
     *
     * @param Nonce $nonce
     * @param Repository $repository
     */
    public function __construct(Nonce $nonce, Repository $repository)
    {
        $this->nonce = $nonce;
        $this->repository = $repository;
    }

    /**
     * Update Module Redirect Settings
     *
     * @param Request $request
     */
    public function updateSettings(Request $request)
    {
        if (!$this->nonce->isValid()) {
            return;
        }

        $settings = $request->bodyValue(
            Repository::MODULE_SETTINGS,
            INPUT_POST,
            FILTER_DEFAULT,
            FILTER_REQUIRE_ARRAY
        );

        if (!$settings) {
            return;
        }

        $this->repository->updateSettings($settings);
    }
}
