<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\Redirect\Settings\Repository;

use Inpsyde\MultilingualPress\Framework\Setting\SettingsRepositoryInterface;

/**
 * Interface for the redirect settings repository.
 */
interface RedirectSettingsRepositoryInterface extends SettingsRepositoryInterface
{
    /**
     * Retrieves the given redirect setting for the given site ID.
     *
     * @param int $siteId The site ID.
     * @param string $settingName The setting name.
     * @return array | Scalar
     */
    public function redirectSiteSetting(int $siteId, string $settingName);

    /**
     * Retrieves the given redirect setting for the given user ID.
     *
     * @param int $userId The user ID.
     * @param string $settingName The setting name.
     * @return array | Scalar
     */
    public function redirectUserSetting(int $userId, string $settingName);
}
