<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\Redirect\Settings\Renderers;

use Inpsyde\MultilingualPress\Module\Redirect\Settings\Repository\Repository;

class RedirectTypeViewRenderer implements ViewRenderer
{
    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $settingName;

    /**
     * @var string
     */
    protected $description;

    /**
     * @var array<string, string>
     */
    protected $redirectTypes;

    /**
     * @var Repository
     */
    protected $repository;

    public function __construct(string $title, string $settingName, string $description, array $redirectTypes, Repository $repository)
    {
        $this->title = $title;
        $this->settingName = $settingName;
        $this->description = $description;
        $this->repository = $repository;
        $this->redirectTypes = $redirectTypes;
    }

    /**
     * @inheritDoc
     */
    public function title()
    {
        ?>
        <label for="redirect_type">
            <strong class="mlp-setting-name"><?= esc_html($this->title) ?></strong>
        </label>
        <?php
    }

    /**
     * @inheritDoc
     */
    public function content()
    {
        $prefix = Repository::MODULE_SETTINGS;
        $settingName = $this->settingName;
        $selected = $this->repository->settingValue($settingName);
        ?>
        <select id="<?= esc_attr("{$prefix}_{$settingName}") ?>" name="<?= esc_attr("{$prefix}[{$settingName}]") ?>">
            <?php foreach ($this->redirectTypes as $redirectType => $redirectTypeTitle) : ?>
                <option value="<?= esc_attr($redirectType)?>" <?php selected($selected, $redirectType);?>><?= esc_html($redirectTypeTitle)?></option>
            <?php endforeach;?>
        </select>
        <p class="mlp-settings-table__option-description"><?= esc_html($this->description) ?></p>
        <?php
    }
}
