<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\Redirect\Settings\Renderers;

use Inpsyde\MultilingualPress\Module\Redirect\Settings\Repository\Repository;

/**
 * @psalm-type ExecutionTypeTitle = string
 * @psalm-type RedirectExecutionTypes = array{PHP: ExecutionTypeTitle, JAVASCRIPT: ExecutionTypeTitle}
 */
class RedirectExecutionTypeViewRenderer implements ViewRenderer
{
    /**
     * @var string
     */
    protected $title;

    /**
     * @var string
     */
    protected $settingName;

    /**
     * @var string
     */
    protected $description;

    /**
     * @var Repository
     */
    protected $repository;

    /**
     * @var array<string, string>
     * @psalm-var RedirectExecutionTypes
     */
    protected $types;

    public function __construct(string $title, string $settingName, string $description, Repository $repository, array $types)
    {
        $this->title = $title;
        $this->settingName = $settingName;
        $this->description = $description;
        $this->repository = $repository;
        $this->types = $types;
    }

    /**
     * @inheritDoc
     */
    public function title()
    {
        ?>
        <label for="redirect_execution">
            <strong class="mlp-setting-name"><?= esc_html($this->title) ?></strong>
        </label>
        <?php
    }

    /**
     * @inheritDoc
     */
    public function content()
    {
        $prefix = Repository::MODULE_SETTINGS;
        $settingName = $this->settingName;
        $selected = $this->repository->settingValue($settingName);
        ?>
        <select id="<?= esc_attr("{$prefix}_{$settingName}") ?>" name="<?= esc_attr("{$prefix}[{$settingName}]") ?>">
            <?php foreach ($this->types as $type => $typeTitle) : ?>
                <option value="<?= esc_attr($type)?>" <?php selected($selected, $type);?>><?= esc_html($typeTitle)?></option>
            <?php endforeach;?>
        </select>
        <p class="mlp-settings-table__option-description"><?= esc_html($this->description) ?></p>
        <?php
    }
}
