<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\Redirect\Settings;

use Inpsyde\MultilingualPress\Framework\Nonce\Nonce;
use Inpsyde\MultilingualPress\Framework\Setting\SettingOptionInterface;
use Inpsyde\MultilingualPress\Framework\Setting\Site\SiteSettingViewModel;
use Inpsyde\MultilingualPress\Module\Redirect\Settings\Repository\Repository;

use function Inpsyde\MultilingualPress\printNonceField;

class RedirectSiteSettings implements SiteSettingViewModel
{
    /**
     * @var Nonce
     */
    private $nonce;

    /**
     * @var array<SettingOptionInterface>
     */
    private $options;

    /**
     * @var Repository
     */
    private $repository;

    /**
     * @param array<SettingOptionInterface> $options
     * @param Nonce $nonce
     * @param Repository $repository
     */
    public function __construct(array $options, Nonce $nonce, Repository $repository)
    {
        $this->options = $options;
        $this->nonce = $nonce;
        $this->repository = $repository;
    }

    /**
     * @inheritdoc
     */
    public function render(int $siteId)
    {
        foreach ($this->options as $option) {
            ?>
            <p class="<?= esc_attr($option->id()) ?>">
                <label for="<?= esc_attr($option->id()) ?>">
                    <input
                            type="checkbox"
                            name="<?= esc_attr($this->repository::OPTION_SITE) ?>[]"
                            value="<?= esc_attr($option->value()) ?>"
                            id="<?= esc_attr($option->id()) ?>"
                        <?php checked($this->repository->redirectSiteSetting($siteId, $option->value())) ?>>
                    <?= esc_html($option->label()) ?>
                </label>
            </p>
            <?php
        }
        printNonceField($this->nonce);
    }

    /**
     * @inheritdoc
     */
    public function title(): string
    {
        return sprintf(
            '<label for="redirect">%1$s</label>',
            esc_html__('Redirect', 'multilingualpress')
        );
    }
}
