<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\Redirect\Redirector;

/**
 * Interface for all redirector implementations.
 */
interface Redirector
{
    public const FILTER_REDIRECT_TYPE = 'multilingualpress.redirector_type';
    public const ACTION_TARGET_NOT_FOUND = 'multilingualpress.redirect_target_not_found';

    public const TYPE_JAVASCRIPT = 'JAVASCRIPT';
    public const TYPE_PHP = 'PHP';

    public const REDIRECT_TYPE_BROWSER_LANGUAGE = 'browser_language';
    public const REDIRECT_TYPE_GEOLOCATION = 'geolocation';
    public const REDIRECT_TYPE_GEOLOCATION_WITH_FALLBACK_TO_BROWSER_LANGUAGE = 'geolocation_with_fallback_to_browser_language';

    /**
     * Redirects the user to the best-matching language version, if any.
     *
     * @return void
     */
    public function redirect();
}
