<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\Redirect\RedirectTarget;

/**
 * Represents the redirectTarget.
 * @psalm-type redirectType = 'browser_language'|'geolocation'
 */
interface RedirectTargetInterface
{
    /**
     * The target site ID.
     *
     * @return int
     */
    public function siteId(): int;

    /**
     * The target content ID.
     *
     * @return int
     */
    public function contentId(): int;

    /**
     * The target content url.
     *
     * @return string
     */
    public function url(): string;

    /**
     * The target language.
     *
     * @return string
     */
    public function language(): string;

    /**
     * The redirect target priority index.
     *
     * @return int
     */
    public function priorityIndex(): int;

    /**
     * The target redirection priority based on given redirect type.
     *
     * @param string $redirectType The redirect type ('browser_language' || 'geolocation').
     * @psalm-param redirectType $redirectType
     * @return float
     */
    public function redirectPriority(string $redirectType): float;

    /**
     * The target redirect fallback priority.
     *
     * @return float
     */
    public function redirectFallbackPriority(): float;
}
