<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\Redirect\NoRedirectStorage;

/**
 * Interface for all noredirect storage implementations.
 */
interface NoRedirectStorage
{
    public const FILTER_LIFETIME = 'multilingualpress.noredirect_storage_lifetime';
    public const LIFETIME_IN_SECONDS = 5 * MINUTE_IN_SECONDS;
    public const KEY = 'noredirect';

    /**
     * Adds the given language to the storage.
     *
     * Returns false if language is not actually added, e.g it was already added.
     *
     * @param string $language
     * @return bool
     */
    public function addLanguage(string $language): bool;

    /**
     * Checks if the given language has been stored before.
     *
     * @param string $language
     * @return bool
     */
    public function hasLanguage(string $language): bool;
}
