<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\Redirect\GeoLocation;

use RuntimeException;

/**
 * Something able to find the geolocation.
 */
interface GeolocationFinderInterface
{
    /**
     * Retrieves the user geolocation country code.
     *
     * @return string The country code of geolocation.
     * @throws RuntimeException If problem finding.
     */
    public function find(): string;
}
