(function(){"use strict";var __webpack_modules__={356:function(){eval("\n;// CONCATENATED MODULE: ./build/src/modules/LanguageManager/resources/js/LanguageManager.js\nfunction _typeof(o) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && \"function\" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? \"symbol\" : typeof o; }, _typeof(o); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\nvar LANGUAGE_ID_REGEXP = /-(\\d+)-/i;\nvar LANGUAGE_NAME_REGEXP = /\\[(\\d+)\\]/i;\nvar NEGATIVE_LANGUAGE_NAME_REGEXP = /\\[-(\\d+)\\]/i;\n\n/**\n * Create the New Language button element\n *\n * @returns {HTMLElement}\n */\nfunction createNewLanguageButton($table, languageManagerStrings) {\n  var button = jQuery(\"<p class=\\\"mlp-new-language\\\">\\n            <button class=\\\"button\\\">\\n                \".concat(languageManagerStrings.newLanguageButtonLabel, \"\\n            </button>\\n        </p>\"));\n  button.insertAfter($table);\n  return button;\n}\n\n/**\n * Create a language delete action button.\n *\n * @param {HTMLElement} $table\n * @returns {HTMLElement}\n */\nfunction createLanguageDeleter($table, languageManagerStrings) {\n  var $deletor = jQuery(\"<td data-label=\\\"Deletor\\\">\\n            <button class=\\\"mlp-language-deletor button dashicons dashicons-trash\\\" data-action=\\\"delete\\\">\\n                <span class=\\\"screen-reader-text\\\">\\n                    \".concat(languageManagerStrings.languageDeleteButtonLabel, \"\\n                </span>\\n            </button>\\n        </td>\"));\n  var $deletorHead = jQuery(\"<th scope=\\\"col\\\" data-label=\\\"Deletor\\\">\\n            \".concat(languageManagerStrings.languageDeleteTableHeadLabel, \"\\n        </th>\"));\n  $table.find('thead > tr th:last-of-type').after($deletorHead.clone());\n  $table.find('tfoot > tr th:last-of-type').after($deletorHead.clone());\n  $table.find('tbody > tr td:last-of-type').after($deletor);\n  return jQuery('.mlp-language-deletor');\n}\n\n/**\n * Clone the table row so it's possible to add more than one language at a time.\n *\n * @returns {HTMLElement}\n */\nfunction cloneTableRow($tableRow) {\n  var $clone = $tableRow.clone(false);\n  $clone.hide().insertAfter($tableRow);\n  $clone.find('input').each(function (index, input) {\n    jQuery(input).val('');\n    jQuery(input).removeAttr('checked');\n  });\n  return $clone;\n}\n\n/**\n * Hide Element\n *\n * @returns void\n */\nfunction hideElement(element) {\n  element = jQuery(element);\n  element.length && element.hide();\n}\n\n/**\n * Show Element\n *\n * @returns void\n */\nfunction showElement(element) {\n  element = jQuery(element);\n  element.length && element.show();\n}\n\n/**\n * Get the next language id to create the new language item.\n *\n * @returns {number}\n */\nfunction nextLanguageId($tableRow) {\n  var invalidId = -1;\n  var input = $tableRow.find('input');\n  if (!input) {\n    return invalidId;\n  }\n  var regexp = new RegExp(LANGUAGE_NAME_REGEXP).exec(input[0].getAttribute('name'));\n  return Array.isArray(regexp) ? ++regexp[1] : invalidId;\n}\n\n/**\n * Increment the language number for inputs\n *\n * Usually done after a table row has been cloned\n *\n * @param $inputs\n * @param number\n */\nfunction incrementLanguageId($inputs, number) {\n  $inputs.each(function (index, input) {\n    var nameAttribute = input.getAttribute('name');\n    var idAttribute = input.getAttribute('id');\n    input.setAttribute('name', nameAttribute.replace(LANGUAGE_NAME_REGEXP, '[' + number + ']'));\n    input.setAttribute('id', idAttribute.replace(LANGUAGE_ID_REGEXP, '-' + number + '-'));\n  });\n}\n\n/**\n * Negative numbers means the language will be deleted from the database, positive numbers\n * means language will be updated or created.\n *\n * @param $inputs\n * @param positive\n */\nfunction changeSignToLanguageId($inputs, positive) {\n  $inputs.each(function (index, input) {\n    var nameAttribute = input.getAttribute('name');\n    input.setAttribute('name', nameAttribute.replace(positive ? NEGATIVE_LANGUAGE_NAME_REGEXP : LANGUAGE_NAME_REGEXP, positive ? '[$1]' : '[-$1]'));\n  });\n}\n\n/**\n * Add new language row\n *\n * @returns void\n */\nfunction addLanguage($tableRow) {\n  showElement($tableRow);\n  var nextId = nextLanguageId($tableRow);\n  if (-1 === nextId) {\n    return;\n  }\n  var $clone = cloneTableRow($tableRow);\n  incrementLanguageId($clone.find('input'), nextId);\n}\n\n/**\n * Undo Delete Language\n *\n * @param $deleter\n * @param languageManagerStrings\n */\nfunction undoDeleteLanguage($deleter, languageManagerStrings) {\n  $deleter = jQuery($deleter);\n  if (!$deleter.length) {\n    return;\n  }\n  var $row = $deleter.parents('tr');\n  if (!$row.length) {\n    return;\n  }\n  var $undo = $deleter.attr('data-action') === 'undo';\n  var callback = $undo ? function (index, input) {\n    jQuery(input).removeAttr('readonly').css('opacity', 1);\n  } : function (index, input) {\n    jQuery(input).attr('readonly', 'readonly').css('opacity', .2);\n  };\n  var label = $undo ? languageManagerStrings.languageDeleteButtonLabel : languageManagerStrings.languageUndoDeleteButtonLabel;\n  var $inputs = $row.find('input');\n  $inputs.each(callback);\n  $deleter.attr('data-action', $undo ? 'delete' : 'undo').find('span').text(label);\n  $row.find('button').toggleClass('dashicons-undo dashicons-trash');\n  changeSignToLanguageId($inputs, $undo);\n}\n\n/**\n * Initialize auto complete for the given input element\n *\n * @returns void\n */\nfunction setupAutocomplete($input) {\n  $input.on('autocompleteselect', function (evt, ui) {\n    var item = 'item' in ui && ui.item;\n    var language = 'language' in item && item.language;\n    var $input = jQuery(evt.currentTarget);\n    if (!language) {\n      return;\n    }\n\n    // Let LanguageSearch do his stuffs before.\n    setTimeout(function () {\n      fillNewLanguageField($input.parents('tr'), language);\n    }, 0);\n  });\n}\n\n/**\n * Add the value for a language to inputs within a table row\n *\n * @param $container\n * @param language\n */\nfunction fillNewLanguageField($container, language) {\n  $container.find('.native-name').val(language.nativeName);\n  $container.find('.english-name').val(language.englishName);\n  $container.find('.iso-639-1').val(language.iso639Code1);\n  $container.find('.iso-639-2').val(language.iso639Code2);\n  $container.find('.iso-639-3').val(language.iso639Code3);\n  $container.find('.iso-639-3').val(language.iso639Code3);\n  $container.find('.locale').val(language.locale);\n  $container.find('.http-code').val(language.httpCode);\n  language.isRtl ? $container.find('.is-rtl').attr('checked', 'checked') : $container.find('.is-rtl').removeAttr('checked');\n}\n\n/**\n * Retrieve latest table Row\n *\n * @param $table\n * @returns {*}\n */\nfunction latestTableRow($table) {\n  return $table.find('tbody tr:last-of-type');\n}\n\n/**\n * Language Manager\n */\nvar LanguageManager = /*#__PURE__*/function () {\n  /**\n   * LanguageManager Constructor\n   */\n  function LanguageManager(languageManagerStrings, LanguageSearch) {\n    _classCallCheck(this, LanguageManager);\n    this.languageManagerStrings = languageManagerStrings;\n    this.didInit = false;\n    this.LanguageSearch = LanguageSearch;\n  }\n\n  /**\n   * Initialize\n   *\n   * @returns void\n   */\n  _createClass(LanguageManager, [{\n    key: \"init\",\n    value: function init() {\n      var _this = this;\n      if (this.didInit) {\n        return;\n      }\n      var $table = jQuery('#mlp-language-manager-table');\n      if (!$table) {\n        return;\n      }\n      hideElement(latestTableRow($table));\n      var $deleter = createLanguageDeleter($table, this.languageManagerStrings);\n      $deleter.on('click', function (evt) {\n        evt.preventDefault();\n        evt.stopPropagation();\n        undoDeleteLanguage(evt.currentTarget, _this.languageManagerStrings);\n      });\n      var $button = createNewLanguageButton($table, this.languageManagerStrings);\n      $button.click(function (evt) {\n        evt.preventDefault();\n        evt.stopPropagation();\n        var $latestTableRow = latestTableRow($table);\n        var $autocompleteInput = $latestTableRow.find('.native-name');\n        var languageSearch = new _this.LanguageSearch(jQuery, $autocompleteInput);\n        addLanguage($latestTableRow);\n        languageSearch.init();\n        setupAutocomplete($autocompleteInput);\n      });\n      this.didInit = true;\n    }\n  }]);\n  return LanguageManager;\n}();\n;// CONCATENATED MODULE: ./build/src/modules/LanguageManager/resources/js/LanguageSearch.js\nvar LanguageSearch = function LanguageSearch($, $langInput) {\n  var $row;\n  var $tagInput;\n  var $currentSelection;\n  var $removeSelection;\n  var noneLabel;\n  var cache = {};\n\n  /**\n   * Send AJAX request and call given response callback with the results.\n   *\n   * @param {string} searchQuery\n   * @param {function} responseCallback\n   */\n  var sendSearchRequest = function sendSearchRequest(searchQuery, responseCallback) {\n    $.ajax({\n      url: ajaxurl,\n      method: 'POST',\n      dataType: 'json',\n      data: {\n        action: $langInput.data('action'),\n        search: searchQuery\n      }\n    }).done(function (data) {\n      if (data.success && data.data && $.isArray(data.data)) {\n        cache[searchQuery] = data.data;\n        return responseCallback(data.data);\n      }\n      return [];\n    }).fail(function () {\n      return responseCallback([]);\n    });\n  };\n\n  /**\n   * Init the class by setting events callbacks on the jQuery element.\n   *\n   * @return {MultilingualPress.NewSiteLanguage}\n   */\n  this.init = function () {\n    $row = $langInput.closest('td');\n    $tagInput = $($langInput.data('connected'));\n    $currentSelection = $row.find('.current-selection');\n    $removeSelection = $row.find('.remove-selection');\n    noneLabel = $langInput.data('none');\n    $langInput.autocomplete({\n      minLength: 2,\n      select: function select(event, ui) {\n        $currentSelection && $currentSelection.text(ui.item.label);\n        $tagInput && $tagInput.val(ui.item.value);\n        $removeSelection && $removeSelection.show();\n        $(this).val('');\n        return false;\n      },\n      source: function source(request, response) {\n        if (request.term in cache) {\n          response(cache[request.term]);\n          return;\n        }\n        sendSearchRequest(request.term, response);\n      }\n    });\n    $removeSelection.click(function (e) {\n      e.preventDefault();\n      $currentSelection.text(noneLabel);\n      $tagInput.val('');\n      $langInput.val('');\n      $removeSelection.hide();\n    });\n    return this;\n  };\n};\n;// CONCATENATED MODULE: ./build/src/modules/LanguageManager/resources/js/admin.js\n\n\n'use strict';\n(function ($, adminpage, languageManagerStrings) {\n  if (adminpage !== 'multilingualpress_page_language-manager') {\n    return;\n  }\n  var languageManager = new LanguageManager(languageManagerStrings, LanguageSearch);\n  languageManager.init();\n})(jQuery, adminpage, languageManager);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///356\n")}},__webpack_exports__={};__webpack_modules__[356]()})();
//# sourceMappingURL=admin.min.js.map