(function(){"use strict";var __webpack_modules__={259:function(){eval("\n;// CONCATENATED MODULE: ./build/src/modules/ExternalSites/resources/js/ExternalSites.js\nfunction _typeof(o) { \"@babel/helpers - typeof\"; return _typeof = \"function\" == typeof Symbol && \"symbol\" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && \"function\" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? \"symbol\" : typeof o; }, _typeof(o); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, \"string\"); return _typeof(key) === \"symbol\" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== \"object\" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || \"default\"); if (_typeof(res) !== \"object\") return res; throw new TypeError(\"@@toPrimitive must return a primitive value.\"); } return (hint === \"string\" ? String : Number)(input); }\nvar LANGUAGE_ID_REGEXP = /-(\\d+)-/i;\nvar LANGUAGE_NAME_REGEXP = /\\[(\\d+)\\]/i;\nvar NEGATIVE_LANGUAGE_NAME_REGEXP = /\\[-(\\d+)\\]/i;\n\n/**\n * Create the New Language button element\n *\n * @returns {HTMLElement}\n */\nfunction createNewExternalSiteButton($table, externalSitesStrings) {\n  var button = jQuery(\"<p class=\\\"mlp-external-site\\\">\\n            <button class=\\\"button\\\">\\n                \".concat(externalSitesStrings.newExternalSiteButtonLabel, \"\\n            </button>\\n        </p>\"));\n  button.insertAfter($table);\n  return button;\n}\n\n/**\n * Create a language delete action button.\n *\n * @param {HTMLElement} $table\n * @returns {HTMLElement}\n */\nfunction createExternalSiteDeleter($table, externalSitesStrings) {\n  var $deletor = jQuery(\"<td data-label=\\\"Deletor\\\">\\n            <button class=\\\"mlp-external-site-deletor button dashicons dashicons-trash\\\" data-action=\\\"delete\\\">\\n                <span class=\\\"screen-reader-text\\\">\\n                    \".concat(externalSitesStrings.externalSiteDeleteButtonLabel, \"\\n                </span>\\n            </button>\\n        </td>\"));\n  var $deletorHead = jQuery(\"<th scope=\\\"col\\\" data-label=\\\"Deletor\\\">\\n            \".concat(externalSitesStrings.externalSiteDeleteTableHeadLabel, \"\\n        </th>\"));\n  $table.find('thead > tr th:last-of-type').after($deletorHead.clone());\n  $table.find('tfoot > tr th:last-of-type').after($deletorHead.clone());\n  $table.find('tbody > tr td:last-of-type').after($deletor);\n  return jQuery('.mlp-external-site-deletor');\n}\n\n/**\n * Clone the table row so it's possible to add more than one language at a time.\n *\n * @returns {HTMLElement}\n */\nfunction cloneTableRow($tableRow) {\n  var $clone = $tableRow.clone(false);\n  $clone.hide().insertAfter($tableRow);\n  $clone.find('input').each(function (index, input) {\n    jQuery(input).val('');\n    jQuery(input).removeAttr('checked');\n  });\n  return $clone;\n}\n\n/**\n * Hide Element\n *\n * @returns void\n */\nfunction hideElement(element) {\n  element = jQuery(element);\n  element.length && element.hide();\n}\n\n/**\n * Show Element\n *\n * @returns void\n */\nfunction showElement(element) {\n  element = jQuery(element);\n  element.length && element.show();\n}\n\n/**\n * Get the next language id to create the new language item.\n *\n * @returns {number}\n */\nfunction nextExternalSiteId($tableRow) {\n  var invalidId = -1;\n  var input = $tableRow.find('input');\n  if (!input) {\n    return invalidId;\n  }\n  var regexp = new RegExp(LANGUAGE_NAME_REGEXP).exec(input[0].getAttribute('name'));\n  return Array.isArray(regexp) ? ++regexp[1] : invalidId;\n}\n\n/**\n * Increment the language number for inputs\n *\n * Usually done after a table row has been cloned\n *\n * @param $inputs\n * @param number\n */\nfunction incrementExternalSiteId($inputs, number) {\n  $inputs.each(function (index, input) {\n    var nameAttribute = input.getAttribute('name');\n    var idAttribute = input.getAttribute('id');\n    input.setAttribute('name', nameAttribute.replace(LANGUAGE_NAME_REGEXP, '[' + number + ']'));\n    input.setAttribute('id', idAttribute.replace(LANGUAGE_ID_REGEXP, '-' + number + '-'));\n  });\n}\n\n/**\n * Negative numbers means the language will be deleted from the database, positive numbers\n * means language will be updated or created.\n *\n * @param $inputs\n * @param positive\n */\nfunction changeSignToExternalSiteId($inputs, positive) {\n  $inputs.each(function (index, input) {\n    var nameAttribute = input.getAttribute('name');\n    input.setAttribute('name', nameAttribute.replace(positive ? NEGATIVE_LANGUAGE_NAME_REGEXP : LANGUAGE_NAME_REGEXP, positive ? '[$1]' : '[-$1]'));\n  });\n}\n\n/**\n * Add new language row\n *\n * @returns void\n */\nfunction addExternalSite($tableRow) {\n  showElement($tableRow);\n  var nextId = nextExternalSiteId($tableRow);\n  if (-1 === nextId) {\n    return;\n  }\n  var $clone = cloneTableRow($tableRow);\n  incrementExternalSiteId($clone.find('input, select'), nextId);\n}\n\n/**\n * Undo Delete Language\n *\n * @param $deleter\n * @param languageManagerStrings\n */\nfunction undoDeleteExternalSite($deleter, externalSitesStrings) {\n  $deleter = jQuery($deleter);\n  if (!$deleter.length) {\n    return;\n  }\n  var $row = $deleter.parents('tr');\n  if (!$row.length) {\n    return;\n  }\n  var $undo = $deleter.attr('data-action') === 'undo';\n  var callback = $undo ? function (index, input) {\n    jQuery(input).removeAttr('readonly').css('opacity', 1);\n  } : function (index, input) {\n    jQuery(input).attr('readonly', 'readonly').css('opacity', .2);\n  };\n  var label = $undo ? externalSitesStrings.externalSiteDeleteButtonLabel : externalSitesStrings.externalSiteUndoDeleteButtonLabel;\n  var $inputs = $row.find('input');\n  $inputs.each(callback);\n  $deleter.attr('data-action', $undo ? 'delete' : 'undo').find('span').text(label);\n  $row.find('button').toggleClass('dashicons-undo dashicons-trash');\n  changeSignToExternalSiteId($inputs, $undo);\n}\n\n/**\n * Retrieve latest table Row\n *\n * @param $table\n * @returns {*}\n */\nfunction latestTableRow($table) {\n  return $table.find('tbody tr:last-of-type');\n}\n\n/**\n * External Sites\n */\nvar ExternalSites = /*#__PURE__*/function () {\n  function ExternalSites(externalSitesStrings) {\n    _classCallCheck(this, ExternalSites);\n    this.externalSitesStrings = externalSitesStrings;\n    this.didInit = false;\n  }\n\n  /**\n   * Initialize\n   *\n   * @returns void\n   */\n  _createClass(ExternalSites, [{\n    key: \"init\",\n    value: function init() {\n      var _this = this;\n      if (this.didInit) {\n        return;\n      }\n      var $table = jQuery('#mlp-external-sites-table');\n      if (!$table) {\n        return;\n      }\n      hideElement(latestTableRow($table));\n      var $deleter = createExternalSiteDeleter($table, this.externalSitesStrings);\n      $deleter.on('click', function (evt) {\n        evt.preventDefault();\n        evt.stopPropagation();\n        undoDeleteExternalSite(evt.currentTarget, _this.externalSitesStrings);\n      });\n      var $button = createNewExternalSiteButton($table, this.externalSitesStrings);\n      $button.click(function (evt) {\n        evt.preventDefault();\n        evt.stopPropagation();\n        var $latestTableRow = latestTableRow($table);\n        addExternalSite($latestTableRow);\n      });\n      this.didInit = true;\n    }\n  }]);\n  return ExternalSites;\n}();\n;// CONCATENATED MODULE: ./build/src/modules/ExternalSites/resources/js/NavMenu.js\nvar ExternalSitesNavMenu = function ExternalSitesNavMenu($, $submitButton, $menuToEdit, $menuInput) {\n  var init = false;\n  var $externalSiteInputs;\n  var $selectAll;\n  var $spinner;\n\n  /**\n   * Shows or hide the spinner.\n   *\n   * @param {bool} enable\n   */\n  var spinner = function spinner(enable) {\n    $spinner.css('visibility', enable ? 'visible' : 'hidden');\n  };\n\n  /**\n   * The currently selected external sites.\n   *\n   * @return {number[]}\n   */\n  var externalSiteIds = function externalSiteIds() {\n    var externalSiteIds = [];\n    $externalSiteInputs.filter(':checked').each(function () {\n      externalSiteIds.push(Number($(this).val() || 0));\n    });\n    return externalSiteIds;\n  };\n\n  /**\n   * Enable or disable the sumbit button based on external sites being selected.\n   */\n  var updateSumbit = function updateSumbit() {\n    $submitButton.prop('disabled', !($menuToEdit.length && externalSiteIds().length));\n  };\n\n  /**\n   * Executes on AJAX error.\n   */\n  var onAjaxError = function onAjaxError() {\n    alert('AJAX error.');\n  };\n\n  /**\n   * Executes on AJAX success and append the menu markup received via AJAX, which is passed as parameter,\n   * to the current menu.\n   *\n   * @param {jQuery} $menu\n   */\n  var onAjaxSuccess = function onAjaxSuccess($menu) {\n    if (!$menu.length) {\n      onAjaxError();\n      return;\n    }\n    $menuToEdit.append($menu);\n  };\n\n  /**\n   * @param {number[]} ids\n   * @return {{action, mlp_external_sites: *, menu: *}}\n   */\n  var ajaxData = function ajaxData(ids) {\n    var nonceAction = $submitButton.data('nonce-action');\n    var nonceValue = $submitButton.data('nonce');\n    var ajaxAction = $submitButton.data('action');\n    var data = {\n      action: ajaxAction,\n      mlp_external_sites: ids,\n      menu: $menuInput.val()\n    };\n    data[nonceAction] = nonceValue;\n    return data;\n  };\n\n  /**\n   * Send the AJAX request to update the menu for the given external site IDs.\n   *\n   * @param {number[]} ids\n   */\n  var sendRequest = function sendRequest(ids) {\n    spinner(true);\n    $submitButton.prop('disabled', true);\n    $externalSiteInputs.prop('disabled', true);\n    $.ajax({\n      url: ajaxurl,\n      method: 'POST',\n      dataType: 'json',\n      data: ajaxData(ids)\n    }).done(function (response) {\n      if (response.success && response.data && typeof response.data === 'string') {\n        onAjaxSuccess($(response.data));\n        return;\n      }\n      onAjaxError();\n    }).fail(function () {\n      onAjaxError();\n    }).always(function () {\n      spinner(false);\n      $externalSiteInputs.prop('checked', false);\n      $externalSiteInputs.prop('disabled', false);\n      $submitButton.prop('disabled', true);\n    });\n  };\n\n  /**\n   * Init the class by setting events callbacks on the jQuery element.\n   *\n   */\n  this.init = function () {\n    if (!init) {\n      $externalSiteInputs = $($submitButton.data('external-sites'));\n      $selectAll = $($submitButton.data('select-all'));\n      $spinner = $submitButton.siblings('.spinner');\n      $externalSiteInputs.click(function () {\n        updateSumbit();\n      });\n      $selectAll.click(function (e) {\n        e.preventDefault();\n        $externalSiteInputs.prop('checked', true);\n        updateSumbit();\n      });\n      $submitButton.click(function () {\n        var ids = externalSiteIds();\n        if (ids && $menuToEdit.length) {\n          sendRequest(ids);\n        }\n      });\n      updateSumbit();\n      init = true;\n    }\n    return this;\n  };\n};\n;// CONCATENATED MODULE: ./build/src/modules/ExternalSites/resources/js/admin.js\n\n\n'use strict';\n(function ($, adminpage, externalSitesStrings) {\n  if (adminpage === 'multilingualpress_page_external-sites') {\n    var _externalSites = new ExternalSites(externalSitesStrings);\n    _externalSites.init();\n  }\n  if (adminpage === 'nav-menus-php') {\n    var navMenu = new ExternalSitesNavMenu($, $('#mlp-navMenu-external-sites-submit'), $('#menu-to-edit'), $('#menu'));\n    navMenu.init();\n  }\n  var redirectFallbackSelect = document.querySelector('#multilingualpress_module_redirect_settings_fallback_site_id');\n  var redirectFallbackExternalSiteSelect = document.querySelector('#multilingualpress_module_redirect_settings_fallback_external_site_id');\n  var redirectFallbackSelectExists = redirectFallbackSelect !== null;\n  var redirectFallbackExternalSiteSelectExists = redirectFallbackExternalSiteSelect !== null;\n  if (redirectFallbackSelectExists && redirectFallbackExternalSiteSelectExists) {\n    redirectFallbackSelect.addEventListener('change', function () {\n      redirectFallbackExternalSiteSelect.disabled = false;\n      if (this.value !== '0') {\n        redirectFallbackExternalSiteSelect.value = '0';\n        redirectFallbackExternalSiteSelect.disabled = true;\n      }\n    });\n    redirectFallbackSelect.dispatchEvent(new Event('change'));\n  }\n})(jQuery, adminpage, externalSites);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjU5LmpzIiwibWFwcGluZ3MiOiI7Ozs7Ozs7O0FBQUEsSUFBTUEsa0JBQWtCLEdBQUcsVUFBVTtBQUNyQyxJQUFNQyxvQkFBb0IsR0FBRyxZQUFZO0FBQ3pDLElBQU1DLDZCQUE2QixHQUFHLGFBQWE7O0FBRW5EO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTQywyQkFBMkJBLENBQUVDLE1BQU0sRUFBRUMsb0JBQW9CLEVBQ2xFO0VBQ0ksSUFBTUMsTUFBTSxHQUFHQyxNQUFNLDRGQUFBQyxNQUFBLENBR1BILG9CQUFvQixDQUFDSSwwQkFBMEIsMENBRzdELENBQUM7RUFFREgsTUFBTSxDQUFDSSxXQUFXLENBQUNOLE1BQU0sQ0FBQztFQUUxQixPQUFPRSxNQUFNO0FBQ2pCOztBQUdBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVNLLHlCQUF5QkEsQ0FBRVAsTUFBTSxFQUFFQyxvQkFBb0IsRUFDaEU7RUFDSSxJQUFNTyxRQUFRLEdBQUdMLE1BQU0sNE5BQUFDLE1BQUEsQ0FJTEgsb0JBQW9CLENBQUNRLDZCQUE2QixvRUFJcEUsQ0FBQztFQUNELElBQU1DLFlBQVksR0FBR1AsTUFBTSwyREFBQUMsTUFBQSxDQUVqQkgsb0JBQW9CLENBQUNVLGdDQUFnQyxvQkFFL0QsQ0FBQztFQUVEWCxNQUFNLENBQUNZLElBQUksQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDQyxLQUFLLENBQUNILFlBQVksQ0FBQ0ksS0FBSyxDQUFDLENBQUMsQ0FBQztFQUNyRWQsTUFBTSxDQUFDWSxJQUFJLENBQUMsNEJBQTRCLENBQUMsQ0FBQ0MsS0FBSyxDQUFDSCxZQUFZLENBQUNJLEtBQUssQ0FBQyxDQUFDLENBQUM7RUFDckVkLE1BQU0sQ0FBQ1ksSUFBSSxDQUFDLDRCQUE0QixDQUFDLENBQUNDLEtBQUssQ0FBQ0wsUUFBUSxDQUFDO0VBRXpELE9BQU9MLE1BQU0sQ0FBQyw0QkFBNEIsQ0FBQztBQUMvQzs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBU1ksYUFBYUEsQ0FBRUMsU0FBUyxFQUNqQztFQUNJLElBQU1DLE1BQU0sR0FBR0QsU0FBUyxDQUFDRixLQUFLLENBQUMsS0FBSyxDQUFDO0VBQ3JDRyxNQUFNLENBQUNDLElBQUksQ0FBQyxDQUFDLENBQUNaLFdBQVcsQ0FBQ1UsU0FBUyxDQUFDO0VBRXBDQyxNQUFNLENBQUNMLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQ08sSUFBSSxDQUFDLFVBQVVDLEtBQUssRUFBRUMsS0FBSyxFQUFFO0lBQzlDbEIsTUFBTSxDQUFDa0IsS0FBSyxDQUFDLENBQUNDLEdBQUcsQ0FBQyxFQUFFLENBQUM7SUFDckJuQixNQUFNLENBQUNrQixLQUFLLENBQUMsQ0FBQ0UsVUFBVSxDQUFDLFNBQVMsQ0FBQztFQUN2QyxDQUFDLENBQUM7RUFFRixPQUFPTixNQUFNO0FBQ2pCOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQSxTQUFTTyxXQUFXQSxDQUFFQyxPQUFPLEVBQzdCO0VBQ0lBLE9BQU8sR0FBR3RCLE1BQU0sQ0FBQ3NCLE9BQU8sQ0FBQztFQUN6QkEsT0FBTyxDQUFDQyxNQUFNLElBQUlELE9BQU8sQ0FBQ1AsSUFBSSxDQUFDLENBQUM7QUFDcEM7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVNTLFdBQVdBLENBQUVGLE9BQU8sRUFDN0I7RUFDSUEsT0FBTyxHQUFHdEIsTUFBTSxDQUFDc0IsT0FBTyxDQUFDO0VBQ3pCQSxPQUFPLENBQUNDLE1BQU0sSUFBSUQsT0FBTyxDQUFDRyxJQUFJLENBQUMsQ0FBQztBQUNwQzs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBU0Msa0JBQWtCQSxDQUFFYixTQUFTLEVBQ3RDO0VBQ0ksSUFBTWMsU0FBUyxHQUFHLENBQUMsQ0FBQztFQUNwQixJQUFNVCxLQUFLLEdBQUdMLFNBQVMsQ0FBQ0osSUFBSSxDQUFDLE9BQU8sQ0FBQztFQUVyQyxJQUFJLENBQUNTLEtBQUssRUFBRTtJQUNSLE9BQU9TLFNBQVM7RUFDcEI7RUFFQSxJQUFNQyxNQUFNLEdBQUksSUFBSUMsTUFBTSxDQUFDbkMsb0JBQW9CLENBQUMsQ0FBRW9DLElBQUksQ0FBQ1osS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDYSxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUM7RUFFckYsT0FBT0MsS0FBSyxDQUFDQyxPQUFPLENBQUNMLE1BQU0sQ0FBQyxHQUFHLEVBQUVBLE1BQU0sQ0FBQyxDQUFDLENBQUMsR0FBR0QsU0FBUztBQUMxRDs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBU08sdUJBQXVCQSxDQUFFQyxPQUFPLEVBQUVDLE1BQU0sRUFDakQ7RUFDSUQsT0FBTyxDQUFDbkIsSUFBSSxDQUFDLFVBQUNDLEtBQUssRUFBRUMsS0FBSyxFQUFLO0lBQzNCLElBQU1tQixhQUFhLEdBQUduQixLQUFLLENBQUNhLFlBQVksQ0FBQyxNQUFNLENBQUM7SUFDaEQsSUFBTU8sV0FBVyxHQUFHcEIsS0FBSyxDQUFDYSxZQUFZLENBQUMsSUFBSSxDQUFDO0lBQzVDYixLQUFLLENBQUNxQixZQUFZLENBQ2QsTUFBTSxFQUNORixhQUFhLENBQUNHLE9BQU8sQ0FBQzlDLG9CQUFvQixFQUFFLEdBQUcsR0FBRzBDLE1BQU0sR0FBRyxHQUFHLENBQ2xFLENBQUM7SUFDRGxCLEtBQUssQ0FBQ3FCLFlBQVksQ0FDZCxJQUFJLEVBQ0pELFdBQVcsQ0FBQ0UsT0FBTyxDQUFDL0Msa0JBQWtCLEVBQUUsR0FBRyxHQUFHMkMsTUFBTSxHQUFHLEdBQUcsQ0FDOUQsQ0FBQztFQUNMLENBQUMsQ0FBQztBQUNOOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EsU0FBU0ssMEJBQTBCQSxDQUFFTixPQUFPLEVBQUVPLFFBQVEsRUFDdEQ7RUFDSVAsT0FBTyxDQUFDbkIsSUFBSSxDQUFDLFVBQVVDLEtBQUssRUFBRUMsS0FBSyxFQUFFO0lBQ2pDLElBQU1tQixhQUFhLEdBQUduQixLQUFLLENBQUNhLFlBQVksQ0FBQyxNQUFNLENBQUM7SUFDaERiLEtBQUssQ0FBQ3FCLFlBQVksQ0FDZCxNQUFNLEVBQ05GLGFBQWEsQ0FBQ0csT0FBTyxDQUNqQkUsUUFBUSxHQUFHL0MsNkJBQTZCLEdBQUdELG9CQUFvQixFQUMvRGdELFFBQVEsR0FBRyxNQUFNLEdBQUcsT0FDeEIsQ0FDSixDQUFDO0VBQ0wsQ0FBQyxDQUFDO0FBQ047O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVNDLGVBQWVBLENBQUU5QixTQUFTLEVBQ25DO0VBQ0lXLFdBQVcsQ0FBQ1gsU0FBUyxDQUFDO0VBRXRCLElBQU0rQixNQUFNLEdBQUdsQixrQkFBa0IsQ0FBQ2IsU0FBUyxDQUFDO0VBQzVDLElBQUksQ0FBQyxDQUFDLEtBQUsrQixNQUFNLEVBQUU7SUFDZjtFQUNKO0VBRUEsSUFBTTlCLE1BQU0sR0FBR0YsYUFBYSxDQUFDQyxTQUFTLENBQUM7RUFDdkNxQix1QkFBdUIsQ0FBQ3BCLE1BQU0sQ0FBQ0wsSUFBSSxDQUFDLGVBQWUsQ0FBQyxFQUFFbUMsTUFBTSxDQUFDO0FBQ2pFOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVNDLHNCQUFzQkEsQ0FBRUMsUUFBUSxFQUFFaEQsb0JBQW9CLEVBQy9EO0VBQ0lnRCxRQUFRLEdBQUc5QyxNQUFNLENBQUM4QyxRQUFRLENBQUM7RUFFM0IsSUFBSSxDQUFDQSxRQUFRLENBQUN2QixNQUFNLEVBQUU7SUFDbEI7RUFDSjtFQUVBLElBQU13QixJQUFJLEdBQUdELFFBQVEsQ0FBQ0UsT0FBTyxDQUFDLElBQUksQ0FBQztFQUNuQyxJQUFJLENBQUNELElBQUksQ0FBQ3hCLE1BQU0sRUFBRTtJQUNkO0VBQ0o7RUFFQSxJQUFNMEIsS0FBSyxHQUFHSCxRQUFRLENBQUNJLElBQUksQ0FBQyxhQUFhLENBQUMsS0FBSyxNQUFNO0VBQ3JELElBQU1DLFFBQVEsR0FBR0YsS0FBSyxHQUNoQixVQUFDaEMsS0FBSyxFQUFFQyxLQUFLLEVBQUs7SUFDaEJsQixNQUFNLENBQUNrQixLQUFLLENBQUMsQ0FBQ0UsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDZ0MsR0FBRyxDQUFDLFNBQVMsRUFBRSxDQUFDLENBQUM7RUFDMUQsQ0FBQyxHQUNDLFVBQUNuQyxLQUFLLEVBQUVDLEtBQUssRUFBSztJQUNoQmxCLE1BQU0sQ0FBQ2tCLEtBQUssQ0FBQyxDQUFDZ0MsSUFBSSxDQUFDLFVBQVUsRUFBRSxVQUFVLENBQUMsQ0FBQ0UsR0FBRyxDQUFDLFNBQVMsRUFBRSxFQUFFLENBQUM7RUFDakUsQ0FBQztFQUVMLElBQU1DLEtBQUssR0FBR0osS0FBSyxHQUNibkQsb0JBQW9CLENBQUNRLDZCQUE2QixHQUNsRFIsb0JBQW9CLENBQUN3RCxpQ0FBaUM7RUFFNUQsSUFBTW5CLE9BQU8sR0FBR1ksSUFBSSxDQUFDdEMsSUFBSSxDQUFDLE9BQU8sQ0FBQztFQUNsQzBCLE9BQU8sQ0FBQ25CLElBQUksQ0FBQ21DLFFBQVEsQ0FBQztFQUV0QkwsUUFBUSxDQUFDSSxJQUFJLENBQUMsYUFBYSxFQUFFRCxLQUFLLEdBQUcsUUFBUSxHQUFHLE1BQU0sQ0FBQyxDQUFDeEMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDOEMsSUFBSSxDQUFDRixLQUFLLENBQUM7RUFFaEZOLElBQUksQ0FBQ3RDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQytDLFdBQVcsQ0FBQyxnQ0FBZ0MsQ0FBQztFQUVqRWYsMEJBQTBCLENBQUNOLE9BQU8sRUFBRWMsS0FBSyxDQUFDO0FBQzlDOztBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLFNBQVNRLGNBQWNBLENBQUU1RCxNQUFNLEVBQy9CO0VBQ0ksT0FBT0EsTUFBTSxDQUFDWSxJQUFJLENBQUMsdUJBQXVCLENBQUM7QUFDL0M7O0FBRUE7QUFDQTtBQUNBO0FBQ08sSUFBTWlELGFBQWE7RUFFdEIsU0FBQUEsY0FBYTVELG9CQUFvQixFQUNqQztJQUFBNkQsZUFBQSxPQUFBRCxhQUFBO0lBQ0ksSUFBSSxDQUFDNUQsb0JBQW9CLEdBQUdBLG9CQUFvQjtJQUNoRCxJQUFJLENBQUM4RCxPQUFPLEdBQUcsS0FBSztFQUN4Qjs7RUFFQTtBQUNKO0FBQ0E7QUFDQTtBQUNBO0VBSklDLFlBQUEsQ0FBQUgsYUFBQTtJQUFBSSxHQUFBO0lBQUFDLEtBQUEsRUFLQSxTQUFBQyxLQUFBLEVBQ0E7TUFBQSxJQUFBQyxLQUFBO01BQ0ksSUFBSSxJQUFJLENBQUNMLE9BQU8sRUFBRTtRQUNkO01BQ0o7TUFFQSxJQUFNL0QsTUFBTSxHQUFHRyxNQUFNLENBQUMsMkJBQTJCLENBQUM7TUFDbEQsSUFBSSxDQUFDSCxNQUFNLEVBQUU7UUFDVDtNQUNKO01BRUF3QixXQUFXLENBQUNvQyxjQUFjLENBQUM1RCxNQUFNLENBQUMsQ0FBQztNQUVuQyxJQUFNaUQsUUFBUSxHQUFHMUMseUJBQXlCLENBQUNQLE1BQU0sRUFBRSxJQUFJLENBQUNDLG9CQUFvQixDQUFDO01BQzdFZ0QsUUFBUSxDQUFDb0IsRUFBRSxDQUFDLE9BQU8sRUFBRSxVQUFBQyxHQUFHLEVBQUk7UUFDeEJBLEdBQUcsQ0FBQ0MsY0FBYyxDQUFDLENBQUM7UUFDcEJELEdBQUcsQ0FBQ0UsZUFBZSxDQUFDLENBQUM7UUFFckJ4QixzQkFBc0IsQ0FBQ3NCLEdBQUcsQ0FBQ0csYUFBYSxFQUFFTCxLQUFJLENBQUNuRSxvQkFBb0IsQ0FBQztNQUN4RSxDQUFDLENBQUM7TUFFRixJQUFNeUUsT0FBTyxHQUFHM0UsMkJBQTJCLENBQUNDLE1BQU0sRUFBRSxJQUFJLENBQUNDLG9CQUFvQixDQUFDO01BRTlFeUUsT0FBTyxDQUFDQyxLQUFLLENBQUMsVUFBQUwsR0FBRyxFQUFJO1FBQ2pCQSxHQUFHLENBQUNDLGNBQWMsQ0FBQyxDQUFDO1FBQ3BCRCxHQUFHLENBQUNFLGVBQWUsQ0FBQyxDQUFDO1FBRXJCLElBQU1JLGVBQWUsR0FBR2hCLGNBQWMsQ0FBQzVELE1BQU0sQ0FBQztRQUU5QzhDLGVBQWUsQ0FBQzhCLGVBQWUsQ0FBQztNQUNwQyxDQUFDLENBQUM7TUFFRixJQUFJLENBQUNiLE9BQU8sR0FBRyxJQUFJO0lBQ3ZCO0VBQUM7RUFBQSxPQUFBRixhQUFBO0FBQUEsSTs7QUN2UkUsSUFBTWdCLG9CQUFvQixHQUFHLFNBQXZCQSxvQkFBb0JBLENBQWFDLENBQUMsRUFBRUMsYUFBYSxFQUFFQyxXQUFXLEVBQUVDLFVBQVUsRUFBRztFQUV6RixJQUFJZCxJQUFJLEdBQUcsS0FBSztFQUNoQixJQUFJZSxtQkFBbUI7RUFDdkIsSUFBSUMsVUFBVTtFQUNkLElBQUlDLFFBQVE7O0VBRVo7QUFDRDtBQUNBO0FBQ0E7QUFDQTtFQUNDLElBQUlDLE9BQU8sR0FBRyxTQUFWQSxPQUFPQSxDQUFjQyxNQUFNLEVBQUc7SUFFakNGLFFBQVEsQ0FBQzdCLEdBQUcsQ0FBRSxZQUFZLEVBQUUrQixNQUFNLEdBQUcsU0FBUyxHQUFHLFFBQVMsQ0FBQztFQUM1RCxDQUFDOztFQUVEO0FBQ0Q7QUFDQTtBQUNBO0FBQ0E7RUFDQyxJQUFJQyxlQUFlLEdBQUcsU0FBQUEsZ0JBQUEsRUFBWTtJQUVqQyxJQUFJQSxlQUFlLEdBQUcsRUFBRTtJQUN4QkwsbUJBQW1CLENBQUNNLE1BQU0sQ0FBRSxVQUFXLENBQUMsQ0FBQ3JFLElBQUksQ0FBRSxZQUFZO01BQzFEb0UsZUFBZSxDQUFDRSxJQUFJLENBQUVDLE1BQU0sQ0FBRVosQ0FBQyxDQUFFLElBQUssQ0FBQyxDQUFDeEQsR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFFLENBQUUsQ0FBQztJQUN2RCxDQUFFLENBQUM7SUFFSCxPQUFPaUUsZUFBZTtFQUN2QixDQUFDOztFQUVEO0FBQ0Q7QUFDQTtFQUNDLElBQUlJLFlBQVksR0FBRyxTQUFmQSxZQUFZQSxDQUFBLEVBQWU7SUFFOUJaLGFBQWEsQ0FBQ2EsSUFBSSxDQUFFLFVBQVUsRUFBRSxFQUFJWixXQUFXLENBQUN0RCxNQUFNLElBQUk2RCxlQUFlLENBQUMsQ0FBQyxDQUFDN0QsTUFBTSxDQUFHLENBQUM7RUFDdkYsQ0FBQzs7RUFFRDtBQUNEO0FBQ0E7RUFDQyxJQUFJbUUsV0FBVyxHQUFHLFNBQWRBLFdBQVdBLENBQUEsRUFBZTtJQUU3QkMsS0FBSyxDQUFFLGFBQWMsQ0FBQztFQUN2QixDQUFDOztFQUVEO0FBQ0Q7QUFDQTtBQUNBO0FBQ0E7QUFDQTtFQUNDLElBQUlDLGFBQWEsR0FBRyxTQUFoQkEsYUFBYUEsQ0FBY0MsS0FBSyxFQUFHO0lBRXRDLElBQUssQ0FBRUEsS0FBSyxDQUFDdEUsTUFBTSxFQUFHO01BQ3JCbUUsV0FBVyxDQUFDLENBQUM7TUFFYjtJQUNEO0lBRUFiLFdBQVcsQ0FBQ2lCLE1BQU0sQ0FBRUQsS0FBTSxDQUFDO0VBQzVCLENBQUM7O0VBRUQ7QUFDRDtBQUNBO0FBQ0E7RUFDQyxJQUFJRSxRQUFRLEdBQUcsU0FBWEEsUUFBUUEsQ0FBY0MsR0FBRyxFQUFHO0lBRS9CLElBQUlDLFdBQVcsR0FBR3JCLGFBQWEsQ0FBQ3NCLElBQUksQ0FBRSxjQUFlLENBQUM7SUFDdEQsSUFBSUMsVUFBVSxHQUFHdkIsYUFBYSxDQUFDc0IsSUFBSSxDQUFFLE9BQVEsQ0FBQztJQUM5QyxJQUFJRSxVQUFVLEdBQUd4QixhQUFhLENBQUNzQixJQUFJLENBQUUsUUFBUyxDQUFDO0lBQy9DLElBQUlBLElBQUksR0FBRztNQUNWRyxNQUFNLEVBQUVELFVBQVU7TUFDbEJFLGtCQUFrQixFQUFFTixHQUFHO01BQ3ZCTyxJQUFJLEVBQUV6QixVQUFVLENBQUMzRCxHQUFHLENBQUM7SUFDdEIsQ0FBQztJQUNEK0UsSUFBSSxDQUFFRCxXQUFXLENBQUUsR0FBR0UsVUFBVTtJQUVoQyxPQUFPRCxJQUFJO0VBQ1osQ0FBQzs7RUFFRDtBQUNEO0FBQ0E7QUFDQTtBQUNBO0VBQ0MsSUFBSU0sV0FBVyxHQUFHLFNBQWRBLFdBQVdBLENBQWNSLEdBQUcsRUFBRztJQUVsQ2QsT0FBTyxDQUFFLElBQUssQ0FBQztJQUNmTixhQUFhLENBQUNhLElBQUksQ0FBRSxVQUFVLEVBQUUsSUFBSyxDQUFDO0lBQ3RDVixtQkFBbUIsQ0FBQ1UsSUFBSSxDQUFFLFVBQVUsRUFBRSxJQUFLLENBQUM7SUFFNUNkLENBQUMsQ0FBQzhCLElBQUksQ0FBRTtNQUNQQyxHQUFHLEVBQUVDLE9BQU87TUFDWkMsTUFBTSxFQUFFLE1BQU07TUFDZEMsUUFBUSxFQUFFLE1BQU07TUFDaEJYLElBQUksRUFBRUgsUUFBUSxDQUFFQyxHQUFJO0lBQ3JCLENBQUUsQ0FBQyxDQUFDYyxJQUFJLENBQUUsVUFBV0MsUUFBUSxFQUFHO01BRS9CLElBQUtBLFFBQVEsQ0FBQ0MsT0FBTyxJQUFJRCxRQUFRLENBQUNiLElBQUksSUFBSSxPQUFPYSxRQUFRLENBQUNiLElBQUksS0FBSyxRQUFRLEVBQUc7UUFDN0VOLGFBQWEsQ0FBRWpCLENBQUMsQ0FBRW9DLFFBQVEsQ0FBQ2IsSUFBSyxDQUFFLENBQUM7UUFFbkM7TUFDRDtNQUVBUixXQUFXLENBQUMsQ0FBQztJQUVkLENBQUUsQ0FBQyxDQUFDdUIsSUFBSSxDQUFFLFlBQVk7TUFFckJ2QixXQUFXLENBQUMsQ0FBQztJQUVkLENBQUUsQ0FBQyxDQUFDd0IsTUFBTSxDQUFFLFlBQVk7TUFDdkJoQyxPQUFPLENBQUUsS0FBTSxDQUFDO01BQ2hCSCxtQkFBbUIsQ0FBQ1UsSUFBSSxDQUFFLFNBQVMsRUFBRSxLQUFNLENBQUM7TUFDNUNWLG1CQUFtQixDQUFDVSxJQUFJLENBQUUsVUFBVSxFQUFFLEtBQU0sQ0FBQztNQUM3Q2IsYUFBYSxDQUFDYSxJQUFJLENBQUUsVUFBVSxFQUFFLElBQUssQ0FBQztJQUN2QyxDQUFFLENBQUM7RUFDSixDQUFDOztFQUVEO0FBQ0Q7QUFDQTtBQUNBO0VBQ0MsSUFBSSxDQUFDekIsSUFBSSxHQUFHLFlBQVk7SUFFdkIsSUFBSyxDQUFFQSxJQUFJLEVBQUc7TUFFYmUsbUJBQW1CLEdBQUdKLENBQUMsQ0FBRUMsYUFBYSxDQUFDc0IsSUFBSSxDQUFFLGdCQUFpQixDQUFFLENBQUM7TUFDakVsQixVQUFVLEdBQUdMLENBQUMsQ0FBRUMsYUFBYSxDQUFDc0IsSUFBSSxDQUFFLFlBQWEsQ0FBRSxDQUFDO01BQ3BEakIsUUFBUSxHQUFHTCxhQUFhLENBQUN1QyxRQUFRLENBQUUsVUFBVyxDQUFDO01BRS9DcEMsbUJBQW1CLENBQUNQLEtBQUssQ0FBRSxZQUFZO1FBQ3RDZ0IsWUFBWSxDQUFDLENBQUM7TUFDZixDQUFFLENBQUM7TUFFSFIsVUFBVSxDQUFDUixLQUFLLENBQUUsVUFBVzRDLENBQUMsRUFBRztRQUNoQ0EsQ0FBQyxDQUFDaEQsY0FBYyxDQUFDLENBQUM7UUFDbEJXLG1CQUFtQixDQUFDVSxJQUFJLENBQUUsU0FBUyxFQUFFLElBQUssQ0FBQztRQUMzQ0QsWUFBWSxDQUFDLENBQUM7TUFDZixDQUFFLENBQUM7TUFFSFosYUFBYSxDQUFDSixLQUFLLENBQUUsWUFBWTtRQUVoQyxJQUFJd0IsR0FBRyxHQUFHWixlQUFlLENBQUMsQ0FBQztRQUMzQixJQUFLWSxHQUFHLElBQUluQixXQUFXLENBQUN0RCxNQUFNLEVBQUc7VUFDaENpRixXQUFXLENBQUVSLEdBQUksQ0FBQztRQUNuQjtNQUNELENBQUUsQ0FBQztNQUVIUixZQUFZLENBQUMsQ0FBQztNQUVkeEIsSUFBSSxHQUFHLElBQUk7SUFDWjtJQUVBLE9BQU8sSUFBSTtFQUNaLENBQUM7QUFDRixDQUFDLEM7O0FDL0o0QztBQUNDO0FBRTlDLFlBQVk7QUFFWixDQUFDLFVBQUNXLENBQUMsRUFBRTBDLFNBQVMsRUFBRXZILG9CQUFvQixFQUFLO0VBRXJDLElBQUl1SCxTQUFTLEtBQUssdUNBQXVDLEVBQUU7SUFDdkQsSUFBTUMsY0FBYSxHQUFHLElBQUk1RCxhQUFhLENBQUM1RCxvQkFBb0IsQ0FBQztJQUM3RHdILGNBQWEsQ0FBQ3RELElBQUksQ0FBQyxDQUFDO0VBQ3hCO0VBRUEsSUFBSXFELFNBQVMsS0FBSyxlQUFlLEVBQUU7SUFDL0IsSUFBTUUsT0FBTyxHQUFHLElBQUk3QyxvQkFBb0IsQ0FBQ0MsQ0FBQyxFQUFFQSxDQUFDLENBQUMsb0NBQW9DLENBQUMsRUFBRUEsQ0FBQyxDQUFDLGVBQWUsQ0FBQyxFQUFFQSxDQUFDLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDcEg0QyxPQUFPLENBQUN2RCxJQUFJLENBQUMsQ0FBQztFQUNsQjtFQUVBLElBQU13RCxzQkFBc0IsR0FBR0MsUUFBUSxDQUFDQyxhQUFhLENBQUMsOERBQThELENBQUM7RUFDckgsSUFBTUMsa0NBQWtDLEdBQUdGLFFBQVEsQ0FBQ0MsYUFBYSxDQUFDLHVFQUF1RSxDQUFDO0VBRTFJLElBQU1FLDRCQUE0QixHQUFHSixzQkFBc0IsS0FBSyxJQUFJO0VBQ3BFLElBQU1LLHdDQUF3QyxHQUFHRixrQ0FBa0MsS0FBSyxJQUFJO0VBRTVGLElBQUlDLDRCQUE0QixJQUFJQyx3Q0FBd0MsRUFBRTtJQUMxRUwsc0JBQXNCLENBQUNNLGdCQUFnQixDQUFDLFFBQVEsRUFBRSxZQUFZO01BQzFESCxrQ0FBa0MsQ0FBQ0ksUUFBUSxHQUFHLEtBQUs7TUFDbkQsSUFBSSxJQUFJLENBQUNoRSxLQUFLLEtBQUssR0FBRyxFQUFFO1FBQ3BCNEQsa0NBQWtDLENBQUM1RCxLQUFLLEdBQUcsR0FBRztRQUM5QzRELGtDQUFrQyxDQUFDSSxRQUFRLEdBQUcsSUFBSTtNQUN0RDtJQUNKLENBQUMsQ0FBQztJQUVGUCxzQkFBc0IsQ0FBQ1EsYUFBYSxDQUFDLElBQUlDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQztFQUM3RDtBQUVKLENBQUMsRUFBRWpJLE1BQU0sRUFBRXFILFNBQVMsRUFBRUMsYUFBYSxDQUFDIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbXVsdGlsaW5ndWFscHJlc3MvLi9idWlsZC9zcmMvbW9kdWxlcy9FeHRlcm5hbFNpdGVzL3Jlc291cmNlcy9qcy9FeHRlcm5hbFNpdGVzLmpzP2ZmMDUiLCJ3ZWJwYWNrOi8vbXVsdGlsaW5ndWFscHJlc3MvLi9idWlsZC9zcmMvbW9kdWxlcy9FeHRlcm5hbFNpdGVzL3Jlc291cmNlcy9qcy9OYXZNZW51LmpzP2JiYzEiLCJ3ZWJwYWNrOi8vbXVsdGlsaW5ndWFscHJlc3MvLi9idWlsZC9zcmMvbW9kdWxlcy9FeHRlcm5hbFNpdGVzL3Jlc291cmNlcy9qcy9hZG1pbi5qcz9mNGRhIl0sInNvdXJjZXNDb250ZW50IjpbImNvbnN0IExBTkdVQUdFX0lEX1JFR0VYUCA9IC8tKFxcZCspLS9pXG5jb25zdCBMQU5HVUFHRV9OQU1FX1JFR0VYUCA9IC9cXFsoXFxkKylcXF0vaVxuY29uc3QgTkVHQVRJVkVfTEFOR1VBR0VfTkFNRV9SRUdFWFAgPSAvXFxbLShcXGQrKVxcXS9pXG5cbi8qKlxuICogQ3JlYXRlIHRoZSBOZXcgTGFuZ3VhZ2UgYnV0dG9uIGVsZW1lbnRcbiAqXG4gKiBAcmV0dXJucyB7SFRNTEVsZW1lbnR9XG4gKi9cbmZ1bmN0aW9uIGNyZWF0ZU5ld0V4dGVybmFsU2l0ZUJ1dHRvbiAoJHRhYmxlLCBleHRlcm5hbFNpdGVzU3RyaW5ncylcbntcbiAgICBjb25zdCBidXR0b24gPSBqUXVlcnkoXG4gICAgICAgIGA8cCBjbGFzcz1cIm1scC1leHRlcm5hbC1zaXRlXCI+XG4gICAgICAgICAgICA8YnV0dG9uIGNsYXNzPVwiYnV0dG9uXCI+XG4gICAgICAgICAgICAgICAgJHtleHRlcm5hbFNpdGVzU3RyaW5ncy5uZXdFeHRlcm5hbFNpdGVCdXR0b25MYWJlbH1cbiAgICAgICAgICAgIDwvYnV0dG9uPlxuICAgICAgICA8L3A+YCxcbiAgICApXG5cbiAgICBidXR0b24uaW5zZXJ0QWZ0ZXIoJHRhYmxlKVxuXG4gICAgcmV0dXJuIGJ1dHRvblxufVxuXG5cbi8qKlxuICogQ3JlYXRlIGEgbGFuZ3VhZ2UgZGVsZXRlIGFjdGlvbiBidXR0b24uXG4gKlxuICogQHBhcmFtIHtIVE1MRWxlbWVudH0gJHRhYmxlXG4gKiBAcmV0dXJucyB7SFRNTEVsZW1lbnR9XG4gKi9cbmZ1bmN0aW9uIGNyZWF0ZUV4dGVybmFsU2l0ZURlbGV0ZXIgKCR0YWJsZSwgZXh0ZXJuYWxTaXRlc1N0cmluZ3MpXG57XG4gICAgY29uc3QgJGRlbGV0b3IgPSBqUXVlcnkoXG4gICAgICAgIGA8dGQgZGF0YS1sYWJlbD1cIkRlbGV0b3JcIj5cbiAgICAgICAgICAgIDxidXR0b24gY2xhc3M9XCJtbHAtZXh0ZXJuYWwtc2l0ZS1kZWxldG9yIGJ1dHRvbiBkYXNoaWNvbnMgZGFzaGljb25zLXRyYXNoXCIgZGF0YS1hY3Rpb249XCJkZWxldGVcIj5cbiAgICAgICAgICAgICAgICA8c3BhbiBjbGFzcz1cInNjcmVlbi1yZWFkZXItdGV4dFwiPlxuICAgICAgICAgICAgICAgICAgICAke2V4dGVybmFsU2l0ZXNTdHJpbmdzLmV4dGVybmFsU2l0ZURlbGV0ZUJ1dHRvbkxhYmVsfVxuICAgICAgICAgICAgICAgIDwvc3Bhbj5cbiAgICAgICAgICAgIDwvYnV0dG9uPlxuICAgICAgICA8L3RkPmAsXG4gICAgKVxuICAgIGNvbnN0ICRkZWxldG9ySGVhZCA9IGpRdWVyeShcbiAgICAgICAgYDx0aCBzY29wZT1cImNvbFwiIGRhdGEtbGFiZWw9XCJEZWxldG9yXCI+XG4gICAgICAgICAgICAke2V4dGVybmFsU2l0ZXNTdHJpbmdzLmV4dGVybmFsU2l0ZURlbGV0ZVRhYmxlSGVhZExhYmVsfVxuICAgICAgICA8L3RoPmAsXG4gICAgKVxuXG4gICAgJHRhYmxlLmZpbmQoJ3RoZWFkID4gdHIgdGg6bGFzdC1vZi10eXBlJykuYWZ0ZXIoJGRlbGV0b3JIZWFkLmNsb25lKCkpXG4gICAgJHRhYmxlLmZpbmQoJ3Rmb290ID4gdHIgdGg6bGFzdC1vZi10eXBlJykuYWZ0ZXIoJGRlbGV0b3JIZWFkLmNsb25lKCkpXG4gICAgJHRhYmxlLmZpbmQoJ3Rib2R5ID4gdHIgdGQ6bGFzdC1vZi10eXBlJykuYWZ0ZXIoJGRlbGV0b3IpXG5cbiAgICByZXR1cm4galF1ZXJ5KCcubWxwLWV4dGVybmFsLXNpdGUtZGVsZXRvcicpXG59XG5cbi8qKlxuICogQ2xvbmUgdGhlIHRhYmxlIHJvdyBzbyBpdCdzIHBvc3NpYmxlIHRvIGFkZCBtb3JlIHRoYW4gb25lIGxhbmd1YWdlIGF0IGEgdGltZS5cbiAqXG4gKiBAcmV0dXJucyB7SFRNTEVsZW1lbnR9XG4gKi9cbmZ1bmN0aW9uIGNsb25lVGFibGVSb3cgKCR0YWJsZVJvdylcbntcbiAgICBjb25zdCAkY2xvbmUgPSAkdGFibGVSb3cuY2xvbmUoZmFsc2UpXG4gICAgJGNsb25lLmhpZGUoKS5pbnNlcnRBZnRlcigkdGFibGVSb3cpXG5cbiAgICAkY2xvbmUuZmluZCgnaW5wdXQnKS5lYWNoKGZ1bmN0aW9uIChpbmRleCwgaW5wdXQpIHtcbiAgICAgICAgalF1ZXJ5KGlucHV0KS52YWwoJycpXG4gICAgICAgIGpRdWVyeShpbnB1dCkucmVtb3ZlQXR0cignY2hlY2tlZCcpXG4gICAgfSlcblxuICAgIHJldHVybiAkY2xvbmVcbn1cblxuLyoqXG4gKiBIaWRlIEVsZW1lbnRcbiAqXG4gKiBAcmV0dXJucyB2b2lkXG4gKi9cbmZ1bmN0aW9uIGhpZGVFbGVtZW50IChlbGVtZW50KVxue1xuICAgIGVsZW1lbnQgPSBqUXVlcnkoZWxlbWVudClcbiAgICBlbGVtZW50Lmxlbmd0aCAmJiBlbGVtZW50LmhpZGUoKVxufVxuXG4vKipcbiAqIFNob3cgRWxlbWVudFxuICpcbiAqIEByZXR1cm5zIHZvaWRcbiAqL1xuZnVuY3Rpb24gc2hvd0VsZW1lbnQgKGVsZW1lbnQpXG57XG4gICAgZWxlbWVudCA9IGpRdWVyeShlbGVtZW50KVxuICAgIGVsZW1lbnQubGVuZ3RoICYmIGVsZW1lbnQuc2hvdygpXG59XG5cbi8qKlxuICogR2V0IHRoZSBuZXh0IGxhbmd1YWdlIGlkIHRvIGNyZWF0ZSB0aGUgbmV3IGxhbmd1YWdlIGl0ZW0uXG4gKlxuICogQHJldHVybnMge251bWJlcn1cbiAqL1xuZnVuY3Rpb24gbmV4dEV4dGVybmFsU2l0ZUlkICgkdGFibGVSb3cpXG57XG4gICAgY29uc3QgaW52YWxpZElkID0gLTFcbiAgICBjb25zdCBpbnB1dCA9ICR0YWJsZVJvdy5maW5kKCdpbnB1dCcpXG5cbiAgICBpZiAoIWlucHV0KSB7XG4gICAgICAgIHJldHVybiBpbnZhbGlkSWRcbiAgICB9XG5cbiAgICBjb25zdCByZWdleHAgPSAobmV3IFJlZ0V4cChMQU5HVUFHRV9OQU1FX1JFR0VYUCkpLmV4ZWMoaW5wdXRbMF0uZ2V0QXR0cmlidXRlKCduYW1lJykpXG5cbiAgICByZXR1cm4gQXJyYXkuaXNBcnJheShyZWdleHApID8gKytyZWdleHBbMV0gOiBpbnZhbGlkSWRcbn1cblxuLyoqXG4gKiBJbmNyZW1lbnQgdGhlIGxhbmd1YWdlIG51bWJlciBmb3IgaW5wdXRzXG4gKlxuICogVXN1YWxseSBkb25lIGFmdGVyIGEgdGFibGUgcm93IGhhcyBiZWVuIGNsb25lZFxuICpcbiAqIEBwYXJhbSAkaW5wdXRzXG4gKiBAcGFyYW0gbnVtYmVyXG4gKi9cbmZ1bmN0aW9uIGluY3JlbWVudEV4dGVybmFsU2l0ZUlkICgkaW5wdXRzLCBudW1iZXIpXG57XG4gICAgJGlucHV0cy5lYWNoKChpbmRleCwgaW5wdXQpID0+IHtcbiAgICAgICAgY29uc3QgbmFtZUF0dHJpYnV0ZSA9IGlucHV0LmdldEF0dHJpYnV0ZSgnbmFtZScpXG4gICAgICAgIGNvbnN0IGlkQXR0cmlidXRlID0gaW5wdXQuZ2V0QXR0cmlidXRlKCdpZCcpXG4gICAgICAgIGlucHV0LnNldEF0dHJpYnV0ZShcbiAgICAgICAgICAgICduYW1lJyxcbiAgICAgICAgICAgIG5hbWVBdHRyaWJ1dGUucmVwbGFjZShMQU5HVUFHRV9OQU1FX1JFR0VYUCwgJ1snICsgbnVtYmVyICsgJ10nKSxcbiAgICAgICAgKVxuICAgICAgICBpbnB1dC5zZXRBdHRyaWJ1dGUoXG4gICAgICAgICAgICAnaWQnLFxuICAgICAgICAgICAgaWRBdHRyaWJ1dGUucmVwbGFjZShMQU5HVUFHRV9JRF9SRUdFWFAsICctJyArIG51bWJlciArICctJyksXG4gICAgICAgIClcbiAgICB9KVxufVxuXG4vKipcbiAqIE5lZ2F0aXZlIG51bWJlcnMgbWVhbnMgdGhlIGxhbmd1YWdlIHdpbGwgYmUgZGVsZXRlZCBmcm9tIHRoZSBkYXRhYmFzZSwgcG9zaXRpdmUgbnVtYmVyc1xuICogbWVhbnMgbGFuZ3VhZ2Ugd2lsbCBiZSB1cGRhdGVkIG9yIGNyZWF0ZWQuXG4gKlxuICogQHBhcmFtICRpbnB1dHNcbiAqIEBwYXJhbSBwb3NpdGl2ZVxuICovXG5mdW5jdGlvbiBjaGFuZ2VTaWduVG9FeHRlcm5hbFNpdGVJZCAoJGlucHV0cywgcG9zaXRpdmUpXG57XG4gICAgJGlucHV0cy5lYWNoKGZ1bmN0aW9uIChpbmRleCwgaW5wdXQpIHtcbiAgICAgICAgY29uc3QgbmFtZUF0dHJpYnV0ZSA9IGlucHV0LmdldEF0dHJpYnV0ZSgnbmFtZScpXG4gICAgICAgIGlucHV0LnNldEF0dHJpYnV0ZShcbiAgICAgICAgICAgICduYW1lJyxcbiAgICAgICAgICAgIG5hbWVBdHRyaWJ1dGUucmVwbGFjZShcbiAgICAgICAgICAgICAgICBwb3NpdGl2ZSA/IE5FR0FUSVZFX0xBTkdVQUdFX05BTUVfUkVHRVhQIDogTEFOR1VBR0VfTkFNRV9SRUdFWFAsXG4gICAgICAgICAgICAgICAgcG9zaXRpdmUgPyAnWyQxXScgOiAnWy0kMV0nLFxuICAgICAgICAgICAgKSxcbiAgICAgICAgKVxuICAgIH0pXG59XG5cbi8qKlxuICogQWRkIG5ldyBsYW5ndWFnZSByb3dcbiAqXG4gKiBAcmV0dXJucyB2b2lkXG4gKi9cbmZ1bmN0aW9uIGFkZEV4dGVybmFsU2l0ZSAoJHRhYmxlUm93KVxue1xuICAgIHNob3dFbGVtZW50KCR0YWJsZVJvdylcblxuICAgIGNvbnN0IG5leHRJZCA9IG5leHRFeHRlcm5hbFNpdGVJZCgkdGFibGVSb3cpXG4gICAgaWYgKC0xID09PSBuZXh0SWQpIHtcbiAgICAgICAgcmV0dXJuXG4gICAgfVxuXG4gICAgY29uc3QgJGNsb25lID0gY2xvbmVUYWJsZVJvdygkdGFibGVSb3cpO1xuICAgIGluY3JlbWVudEV4dGVybmFsU2l0ZUlkKCRjbG9uZS5maW5kKCdpbnB1dCwgc2VsZWN0JyksIG5leHRJZClcbn1cblxuLyoqXG4gKiBVbmRvIERlbGV0ZSBMYW5ndWFnZVxuICpcbiAqIEBwYXJhbSAkZGVsZXRlclxuICogQHBhcmFtIGxhbmd1YWdlTWFuYWdlclN0cmluZ3NcbiAqL1xuZnVuY3Rpb24gdW5kb0RlbGV0ZUV4dGVybmFsU2l0ZSAoJGRlbGV0ZXIsIGV4dGVybmFsU2l0ZXNTdHJpbmdzKVxue1xuICAgICRkZWxldGVyID0galF1ZXJ5KCRkZWxldGVyKVxuXG4gICAgaWYgKCEkZGVsZXRlci5sZW5ndGgpIHtcbiAgICAgICAgcmV0dXJuXG4gICAgfVxuXG4gICAgY29uc3QgJHJvdyA9ICRkZWxldGVyLnBhcmVudHMoJ3RyJylcbiAgICBpZiAoISRyb3cubGVuZ3RoKSB7XG4gICAgICAgIHJldHVyblxuICAgIH1cblxuICAgIGNvbnN0ICR1bmRvID0gJGRlbGV0ZXIuYXR0cignZGF0YS1hY3Rpb24nKSA9PT0gJ3VuZG8nXG4gICAgY29uc3QgY2FsbGJhY2sgPSAkdW5kb1xuICAgICAgICA/IChpbmRleCwgaW5wdXQpID0+IHtcbiAgICAgICAgICAgIGpRdWVyeShpbnB1dCkucmVtb3ZlQXR0cigncmVhZG9ubHknKS5jc3MoJ29wYWNpdHknLCAxKVxuICAgICAgICB9XG4gICAgICAgIDogKGluZGV4LCBpbnB1dCkgPT4ge1xuICAgICAgICAgICAgalF1ZXJ5KGlucHV0KS5hdHRyKCdyZWFkb25seScsICdyZWFkb25seScpLmNzcygnb3BhY2l0eScsIC4yKVxuICAgICAgICB9XG5cbiAgICBjb25zdCBsYWJlbCA9ICR1bmRvXG4gICAgICAgID8gZXh0ZXJuYWxTaXRlc1N0cmluZ3MuZXh0ZXJuYWxTaXRlRGVsZXRlQnV0dG9uTGFiZWxcbiAgICAgICAgOiBleHRlcm5hbFNpdGVzU3RyaW5ncy5leHRlcm5hbFNpdGVVbmRvRGVsZXRlQnV0dG9uTGFiZWxcblxuICAgIGNvbnN0ICRpbnB1dHMgPSAkcm93LmZpbmQoJ2lucHV0JylcbiAgICAkaW5wdXRzLmVhY2goY2FsbGJhY2spXG5cbiAgICAkZGVsZXRlci5hdHRyKCdkYXRhLWFjdGlvbicsICR1bmRvID8gJ2RlbGV0ZScgOiAndW5kbycpLmZpbmQoJ3NwYW4nKS50ZXh0KGxhYmVsKVxuXG4gICAgJHJvdy5maW5kKCdidXR0b24nKS50b2dnbGVDbGFzcygnZGFzaGljb25zLXVuZG8gZGFzaGljb25zLXRyYXNoJylcblxuICAgIGNoYW5nZVNpZ25Ub0V4dGVybmFsU2l0ZUlkKCRpbnB1dHMsICR1bmRvKVxufVxuXG4vKipcbiAqIFJldHJpZXZlIGxhdGVzdCB0YWJsZSBSb3dcbiAqXG4gKiBAcGFyYW0gJHRhYmxlXG4gKiBAcmV0dXJucyB7Kn1cbiAqL1xuZnVuY3Rpb24gbGF0ZXN0VGFibGVSb3cgKCR0YWJsZSlcbntcbiAgICByZXR1cm4gJHRhYmxlLmZpbmQoJ3Rib2R5IHRyOmxhc3Qtb2YtdHlwZScpXG59XG5cbi8qKlxuICogRXh0ZXJuYWwgU2l0ZXNcbiAqL1xuZXhwb3J0IGNsYXNzIEV4dGVybmFsU2l0ZXNcbntcbiAgICBjb25zdHJ1Y3RvciAoZXh0ZXJuYWxTaXRlc1N0cmluZ3MpXG4gICAge1xuICAgICAgICB0aGlzLmV4dGVybmFsU2l0ZXNTdHJpbmdzID0gZXh0ZXJuYWxTaXRlc1N0cmluZ3NcbiAgICAgICAgdGhpcy5kaWRJbml0ID0gZmFsc2VcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBJbml0aWFsaXplXG4gICAgICpcbiAgICAgKiBAcmV0dXJucyB2b2lkXG4gICAgICovXG4gICAgaW5pdCAoKVxuICAgIHtcbiAgICAgICAgaWYgKHRoaXMuZGlkSW5pdCkge1xuICAgICAgICAgICAgcmV0dXJuXG4gICAgICAgIH1cblxuICAgICAgICBjb25zdCAkdGFibGUgPSBqUXVlcnkoJyNtbHAtZXh0ZXJuYWwtc2l0ZXMtdGFibGUnKVxuICAgICAgICBpZiAoISR0YWJsZSkge1xuICAgICAgICAgICAgcmV0dXJuXG4gICAgICAgIH1cblxuICAgICAgICBoaWRlRWxlbWVudChsYXRlc3RUYWJsZVJvdygkdGFibGUpKVxuXG4gICAgICAgIGNvbnN0ICRkZWxldGVyID0gY3JlYXRlRXh0ZXJuYWxTaXRlRGVsZXRlcigkdGFibGUsIHRoaXMuZXh0ZXJuYWxTaXRlc1N0cmluZ3MpXG4gICAgICAgICRkZWxldGVyLm9uKCdjbGljaycsIGV2dCA9PiB7XG4gICAgICAgICAgICBldnQucHJldmVudERlZmF1bHQoKVxuICAgICAgICAgICAgZXZ0LnN0b3BQcm9wYWdhdGlvbigpXG5cbiAgICAgICAgICAgIHVuZG9EZWxldGVFeHRlcm5hbFNpdGUoZXZ0LmN1cnJlbnRUYXJnZXQsIHRoaXMuZXh0ZXJuYWxTaXRlc1N0cmluZ3MpXG4gICAgICAgIH0pXG5cbiAgICAgICAgY29uc3QgJGJ1dHRvbiA9IGNyZWF0ZU5ld0V4dGVybmFsU2l0ZUJ1dHRvbigkdGFibGUsIHRoaXMuZXh0ZXJuYWxTaXRlc1N0cmluZ3MpXG5cbiAgICAgICAgJGJ1dHRvbi5jbGljayhldnQgPT4ge1xuICAgICAgICAgICAgZXZ0LnByZXZlbnREZWZhdWx0KClcbiAgICAgICAgICAgIGV2dC5zdG9wUHJvcGFnYXRpb24oKVxuXG4gICAgICAgICAgICBjb25zdCAkbGF0ZXN0VGFibGVSb3cgPSBsYXRlc3RUYWJsZVJvdygkdGFibGUpO1xuXG4gICAgICAgICAgICBhZGRFeHRlcm5hbFNpdGUoJGxhdGVzdFRhYmxlUm93KVxuICAgICAgICB9KVxuXG4gICAgICAgIHRoaXMuZGlkSW5pdCA9IHRydWVcbiAgICB9XG59XG4iLCJleHBvcnQgY29uc3QgRXh0ZXJuYWxTaXRlc05hdk1lbnUgPSBmdW5jdGlvbiAoJCwgJHN1Ym1pdEJ1dHRvbiwgJG1lbnVUb0VkaXQsICRtZW51SW5wdXQgKSB7XG5cblx0dmFyIGluaXQgPSBmYWxzZTtcblx0dmFyICRleHRlcm5hbFNpdGVJbnB1dHM7XG5cdHZhciAkc2VsZWN0QWxsO1xuXHR2YXIgJHNwaW5uZXI7XG5cblx0LyoqXG5cdCAqIFNob3dzIG9yIGhpZGUgdGhlIHNwaW5uZXIuXG5cdCAqXG5cdCAqIEBwYXJhbSB7Ym9vbH0gZW5hYmxlXG5cdCAqL1xuXHR2YXIgc3Bpbm5lciA9IGZ1bmN0aW9uICggZW5hYmxlICkge1xuXG5cdFx0JHNwaW5uZXIuY3NzKCAndmlzaWJpbGl0eScsIGVuYWJsZSA/ICd2aXNpYmxlJyA6ICdoaWRkZW4nICk7XG5cdH07XG5cblx0LyoqXG5cdCAqIFRoZSBjdXJyZW50bHkgc2VsZWN0ZWQgZXh0ZXJuYWwgc2l0ZXMuXG5cdCAqXG5cdCAqIEByZXR1cm4ge251bWJlcltdfVxuXHQgKi9cblx0dmFyIGV4dGVybmFsU2l0ZUlkcyA9IGZ1bmN0aW9uICgpIHtcblxuXHRcdGxldCBleHRlcm5hbFNpdGVJZHMgPSBbXTtcblx0XHQkZXh0ZXJuYWxTaXRlSW5wdXRzLmZpbHRlciggJzpjaGVja2VkJyApLmVhY2goIGZ1bmN0aW9uICgpIHtcblx0XHRcdGV4dGVybmFsU2l0ZUlkcy5wdXNoKCBOdW1iZXIoICQoIHRoaXMgKS52YWwoKSB8fCAwICkgKTtcblx0XHR9ICk7XG5cblx0XHRyZXR1cm4gZXh0ZXJuYWxTaXRlSWRzO1xuXHR9O1xuXG5cdC8qKlxuXHQgKiBFbmFibGUgb3IgZGlzYWJsZSB0aGUgc3VtYml0IGJ1dHRvbiBiYXNlZCBvbiBleHRlcm5hbCBzaXRlcyBiZWluZyBzZWxlY3RlZC5cblx0ICovXG5cdHZhciB1cGRhdGVTdW1iaXQgPSBmdW5jdGlvbiAoKSB7XG5cblx0XHQkc3VibWl0QnV0dG9uLnByb3AoICdkaXNhYmxlZCcsICEgKCAkbWVudVRvRWRpdC5sZW5ndGggJiYgZXh0ZXJuYWxTaXRlSWRzKCkubGVuZ3RoICkgKTtcblx0fTtcblxuXHQvKipcblx0ICogRXhlY3V0ZXMgb24gQUpBWCBlcnJvci5cblx0ICovXG5cdHZhciBvbkFqYXhFcnJvciA9IGZ1bmN0aW9uICgpIHtcblxuXHRcdGFsZXJ0KCAnQUpBWCBlcnJvci4nICk7XG5cdH07XG5cblx0LyoqXG5cdCAqIEV4ZWN1dGVzIG9uIEFKQVggc3VjY2VzcyBhbmQgYXBwZW5kIHRoZSBtZW51IG1hcmt1cCByZWNlaXZlZCB2aWEgQUpBWCwgd2hpY2ggaXMgcGFzc2VkIGFzIHBhcmFtZXRlcixcblx0ICogdG8gdGhlIGN1cnJlbnQgbWVudS5cblx0ICpcblx0ICogQHBhcmFtIHtqUXVlcnl9ICRtZW51XG5cdCAqL1xuXHR2YXIgb25BamF4U3VjY2VzcyA9IGZ1bmN0aW9uICggJG1lbnUgKSB7XG5cblx0XHRpZiAoICEgJG1lbnUubGVuZ3RoICkge1xuXHRcdFx0b25BamF4RXJyb3IoKTtcblxuXHRcdFx0cmV0dXJuO1xuXHRcdH1cblxuXHRcdCRtZW51VG9FZGl0LmFwcGVuZCggJG1lbnUgKTtcblx0fTtcblxuXHQvKipcblx0ICogQHBhcmFtIHtudW1iZXJbXX0gaWRzXG5cdCAqIEByZXR1cm4ge3thY3Rpb24sIG1scF9leHRlcm5hbF9zaXRlczogKiwgbWVudTogKn19XG5cdCAqL1xuXHR2YXIgYWpheERhdGEgPSBmdW5jdGlvbiAoIGlkcyApIHtcblxuXHRcdHZhciBub25jZUFjdGlvbiA9ICRzdWJtaXRCdXR0b24uZGF0YSggJ25vbmNlLWFjdGlvbicgKTtcblx0XHR2YXIgbm9uY2VWYWx1ZSA9ICRzdWJtaXRCdXR0b24uZGF0YSggJ25vbmNlJyApO1xuXHRcdHZhciBhamF4QWN0aW9uID0gJHN1Ym1pdEJ1dHRvbi5kYXRhKCAnYWN0aW9uJyApO1xuXHRcdHZhciBkYXRhID0ge1xuXHRcdFx0YWN0aW9uOiBhamF4QWN0aW9uLFxuXHRcdFx0bWxwX2V4dGVybmFsX3NpdGVzOiBpZHMsXG5cdFx0XHRtZW51OiAkbWVudUlucHV0LnZhbCgpLFxuXHRcdH07XG5cdFx0ZGF0YVsgbm9uY2VBY3Rpb24gXSA9IG5vbmNlVmFsdWU7XG5cblx0XHRyZXR1cm4gZGF0YTtcblx0fTtcblxuXHQvKipcblx0ICogU2VuZCB0aGUgQUpBWCByZXF1ZXN0IHRvIHVwZGF0ZSB0aGUgbWVudSBmb3IgdGhlIGdpdmVuIGV4dGVybmFsIHNpdGUgSURzLlxuXHQgKlxuXHQgKiBAcGFyYW0ge251bWJlcltdfSBpZHNcblx0ICovXG5cdHZhciBzZW5kUmVxdWVzdCA9IGZ1bmN0aW9uICggaWRzICkge1xuXG5cdFx0c3Bpbm5lciggdHJ1ZSApO1xuXHRcdCRzdWJtaXRCdXR0b24ucHJvcCggJ2Rpc2FibGVkJywgdHJ1ZSApO1xuXHRcdCRleHRlcm5hbFNpdGVJbnB1dHMucHJvcCggJ2Rpc2FibGVkJywgdHJ1ZSApO1xuXG5cdFx0JC5hamF4KCB7XG5cdFx0XHR1cmw6IGFqYXh1cmwsXG5cdFx0XHRtZXRob2Q6ICdQT1NUJyxcblx0XHRcdGRhdGFUeXBlOiAnanNvbicsXG5cdFx0XHRkYXRhOiBhamF4RGF0YSggaWRzIClcblx0XHR9ICkuZG9uZSggZnVuY3Rpb24gKCByZXNwb25zZSApIHtcblxuXHRcdFx0aWYgKCByZXNwb25zZS5zdWNjZXNzICYmIHJlc3BvbnNlLmRhdGEgJiYgdHlwZW9mIHJlc3BvbnNlLmRhdGEgPT09ICdzdHJpbmcnICkge1xuXHRcdFx0XHRvbkFqYXhTdWNjZXNzKCAkKCByZXNwb25zZS5kYXRhICkgKTtcblxuXHRcdFx0XHRyZXR1cm47XG5cdFx0XHR9XG5cblx0XHRcdG9uQWpheEVycm9yKCk7XG5cblx0XHR9ICkuZmFpbCggZnVuY3Rpb24gKCkge1xuXG5cdFx0XHRvbkFqYXhFcnJvcigpO1xuXG5cdFx0fSApLmFsd2F5cyggZnVuY3Rpb24gKCkge1xuXHRcdFx0c3Bpbm5lciggZmFsc2UgKTtcblx0XHRcdCRleHRlcm5hbFNpdGVJbnB1dHMucHJvcCggJ2NoZWNrZWQnLCBmYWxzZSApO1xuXHRcdFx0JGV4dGVybmFsU2l0ZUlucHV0cy5wcm9wKCAnZGlzYWJsZWQnLCBmYWxzZSApO1xuXHRcdFx0JHN1Ym1pdEJ1dHRvbi5wcm9wKCAnZGlzYWJsZWQnLCB0cnVlICk7XG5cdFx0fSApO1xuXHR9O1xuXG5cdC8qKlxuXHQgKiBJbml0IHRoZSBjbGFzcyBieSBzZXR0aW5nIGV2ZW50cyBjYWxsYmFja3Mgb24gdGhlIGpRdWVyeSBlbGVtZW50LlxuXHQgKlxuXHQgKi9cblx0dGhpcy5pbml0ID0gZnVuY3Rpb24gKCkge1xuXG5cdFx0aWYgKCAhIGluaXQgKSB7XG5cblx0XHRcdCRleHRlcm5hbFNpdGVJbnB1dHMgPSAkKCAkc3VibWl0QnV0dG9uLmRhdGEoICdleHRlcm5hbC1zaXRlcycgKSApO1xuXHRcdFx0JHNlbGVjdEFsbCA9ICQoICRzdWJtaXRCdXR0b24uZGF0YSggJ3NlbGVjdC1hbGwnICkgKTtcblx0XHRcdCRzcGlubmVyID0gJHN1Ym1pdEJ1dHRvbi5zaWJsaW5ncyggJy5zcGlubmVyJyApO1xuXG5cdFx0XHQkZXh0ZXJuYWxTaXRlSW5wdXRzLmNsaWNrKCBmdW5jdGlvbiAoKSB7XG5cdFx0XHRcdHVwZGF0ZVN1bWJpdCgpO1xuXHRcdFx0fSApO1xuXG5cdFx0XHQkc2VsZWN0QWxsLmNsaWNrKCBmdW5jdGlvbiAoIGUgKSB7XG5cdFx0XHRcdGUucHJldmVudERlZmF1bHQoKTtcblx0XHRcdFx0JGV4dGVybmFsU2l0ZUlucHV0cy5wcm9wKCAnY2hlY2tlZCcsIHRydWUgKTtcblx0XHRcdFx0dXBkYXRlU3VtYml0KCk7XG5cdFx0XHR9ICk7XG5cblx0XHRcdCRzdWJtaXRCdXR0b24uY2xpY2soIGZ1bmN0aW9uICgpIHtcblxuXHRcdFx0XHRsZXQgaWRzID0gZXh0ZXJuYWxTaXRlSWRzKCk7XG5cdFx0XHRcdGlmICggaWRzICYmICRtZW51VG9FZGl0Lmxlbmd0aCApIHtcblx0XHRcdFx0XHRzZW5kUmVxdWVzdCggaWRzICk7XG5cdFx0XHRcdH1cblx0XHRcdH0gKTtcblxuXHRcdFx0dXBkYXRlU3VtYml0KCk7XG5cblx0XHRcdGluaXQgPSB0cnVlO1xuXHRcdH1cblxuXHRcdHJldHVybiB0aGlzO1xuXHR9O1xufTtcbiIsImltcG9ydCB7RXh0ZXJuYWxTaXRlc30gZnJvbSAnLi9FeHRlcm5hbFNpdGVzJ1xuaW1wb3J0IHtFeHRlcm5hbFNpdGVzTmF2TWVudX0gZnJvbSAnLi9OYXZNZW51J1xuXG4ndXNlIHN0cmljdCc7XG5cbigoJCwgYWRtaW5wYWdlLCBleHRlcm5hbFNpdGVzU3RyaW5ncykgPT4ge1xuXG4gICAgaWYgKGFkbWlucGFnZSA9PT0gJ211bHRpbGluZ3VhbHByZXNzX3BhZ2VfZXh0ZXJuYWwtc2l0ZXMnKSB7XG4gICAgICAgIGNvbnN0IGV4dGVybmFsU2l0ZXMgPSBuZXcgRXh0ZXJuYWxTaXRlcyhleHRlcm5hbFNpdGVzU3RyaW5ncylcbiAgICAgICAgZXh0ZXJuYWxTaXRlcy5pbml0KClcbiAgICB9XG5cbiAgICBpZiAoYWRtaW5wYWdlID09PSAnbmF2LW1lbnVzLXBocCcpIHtcbiAgICAgICAgY29uc3QgbmF2TWVudSA9IG5ldyBFeHRlcm5hbFNpdGVzTmF2TWVudSgkLCAkKCcjbWxwLW5hdk1lbnUtZXh0ZXJuYWwtc2l0ZXMtc3VibWl0JyksICQoJyNtZW51LXRvLWVkaXQnKSwgJCgnI21lbnUnKSk7XG4gICAgICAgIG5hdk1lbnUuaW5pdCgpO1xuICAgIH1cblxuICAgIGNvbnN0IHJlZGlyZWN0RmFsbGJhY2tTZWxlY3QgPSBkb2N1bWVudC5xdWVyeVNlbGVjdG9yKCcjbXVsdGlsaW5ndWFscHJlc3NfbW9kdWxlX3JlZGlyZWN0X3NldHRpbmdzX2ZhbGxiYWNrX3NpdGVfaWQnKTtcbiAgICBjb25zdCByZWRpcmVjdEZhbGxiYWNrRXh0ZXJuYWxTaXRlU2VsZWN0ID0gZG9jdW1lbnQucXVlcnlTZWxlY3RvcignI211bHRpbGluZ3VhbHByZXNzX21vZHVsZV9yZWRpcmVjdF9zZXR0aW5nc19mYWxsYmFja19leHRlcm5hbF9zaXRlX2lkJyk7XG5cbiAgICBjb25zdCByZWRpcmVjdEZhbGxiYWNrU2VsZWN0RXhpc3RzID0gcmVkaXJlY3RGYWxsYmFja1NlbGVjdCAhPT0gbnVsbDtcbiAgICBjb25zdCByZWRpcmVjdEZhbGxiYWNrRXh0ZXJuYWxTaXRlU2VsZWN0RXhpc3RzID0gcmVkaXJlY3RGYWxsYmFja0V4dGVybmFsU2l0ZVNlbGVjdCAhPT0gbnVsbDtcblxuICAgIGlmIChyZWRpcmVjdEZhbGxiYWNrU2VsZWN0RXhpc3RzICYmIHJlZGlyZWN0RmFsbGJhY2tFeHRlcm5hbFNpdGVTZWxlY3RFeGlzdHMpIHtcbiAgICAgICAgcmVkaXJlY3RGYWxsYmFja1NlbGVjdC5hZGRFdmVudExpc3RlbmVyKCdjaGFuZ2UnLCBmdW5jdGlvbiAoKSB7XG4gICAgICAgICAgICByZWRpcmVjdEZhbGxiYWNrRXh0ZXJuYWxTaXRlU2VsZWN0LmRpc2FibGVkID0gZmFsc2U7XG4gICAgICAgICAgICBpZiAodGhpcy52YWx1ZSAhPT0gJzAnKSB7XG4gICAgICAgICAgICAgICAgcmVkaXJlY3RGYWxsYmFja0V4dGVybmFsU2l0ZVNlbGVjdC52YWx1ZSA9ICcwJztcbiAgICAgICAgICAgICAgICByZWRpcmVjdEZhbGxiYWNrRXh0ZXJuYWxTaXRlU2VsZWN0LmRpc2FibGVkID0gdHJ1ZTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfSk7XG5cbiAgICAgICAgcmVkaXJlY3RGYWxsYmFja1NlbGVjdC5kaXNwYXRjaEV2ZW50KG5ldyBFdmVudCgnY2hhbmdlJykpO1xuICAgIH1cblxufSkoalF1ZXJ5LCBhZG1pbnBhZ2UsIGV4dGVybmFsU2l0ZXMpXG4iXSwibmFtZXMiOlsiTEFOR1VBR0VfSURfUkVHRVhQIiwiTEFOR1VBR0VfTkFNRV9SRUdFWFAiLCJORUdBVElWRV9MQU5HVUFHRV9OQU1FX1JFR0VYUCIsImNyZWF0ZU5ld0V4dGVybmFsU2l0ZUJ1dHRvbiIsIiR0YWJsZSIsImV4dGVybmFsU2l0ZXNTdHJpbmdzIiwiYnV0dG9uIiwialF1ZXJ5IiwiY29uY2F0IiwibmV3RXh0ZXJuYWxTaXRlQnV0dG9uTGFiZWwiLCJpbnNlcnRBZnRlciIsImNyZWF0ZUV4dGVybmFsU2l0ZURlbGV0ZXIiLCIkZGVsZXRvciIsImV4dGVybmFsU2l0ZURlbGV0ZUJ1dHRvbkxhYmVsIiwiJGRlbGV0b3JIZWFkIiwiZXh0ZXJuYWxTaXRlRGVsZXRlVGFibGVIZWFkTGFiZWwiLCJmaW5kIiwiYWZ0ZXIiLCJjbG9uZSIsImNsb25lVGFibGVSb3ciLCIkdGFibGVSb3ciLCIkY2xvbmUiLCJoaWRlIiwiZWFjaCIsImluZGV4IiwiaW5wdXQiLCJ2YWwiLCJyZW1vdmVBdHRyIiwiaGlkZUVsZW1lbnQiLCJlbGVtZW50IiwibGVuZ3RoIiwic2hvd0VsZW1lbnQiLCJzaG93IiwibmV4dEV4dGVybmFsU2l0ZUlkIiwiaW52YWxpZElkIiwicmVnZXhwIiwiUmVnRXhwIiwiZXhlYyIsImdldEF0dHJpYnV0ZSIsIkFycmF5IiwiaXNBcnJheSIsImluY3JlbWVudEV4dGVybmFsU2l0ZUlkIiwiJGlucHV0cyIsIm51bWJlciIsIm5hbWVBdHRyaWJ1dGUiLCJpZEF0dHJpYnV0ZSIsInNldEF0dHJpYnV0ZSIsInJlcGxhY2UiLCJjaGFuZ2VTaWduVG9FeHRlcm5hbFNpdGVJZCIsInBvc2l0aXZlIiwiYWRkRXh0ZXJuYWxTaXRlIiwibmV4dElkIiwidW5kb0RlbGV0ZUV4dGVybmFsU2l0ZSIsIiRkZWxldGVyIiwiJHJvdyIsInBhcmVudHMiLCIkdW5kbyIsImF0dHIiLCJjYWxsYmFjayIsImNzcyIsImxhYmVsIiwiZXh0ZXJuYWxTaXRlVW5kb0RlbGV0ZUJ1dHRvbkxhYmVsIiwidGV4dCIsInRvZ2dsZUNsYXNzIiwibGF0ZXN0VGFibGVSb3ciLCJFeHRlcm5hbFNpdGVzIiwiX2NsYXNzQ2FsbENoZWNrIiwiZGlkSW5pdCIsIl9jcmVhdGVDbGFzcyIsImtleSIsInZhbHVlIiwiaW5pdCIsIl90aGlzIiwib24iLCJldnQiLCJwcmV2ZW50RGVmYXVsdCIsInN0b3BQcm9wYWdhdGlvbiIsImN1cnJlbnRUYXJnZXQiLCIkYnV0dG9uIiwiY2xpY2siLCIkbGF0ZXN0VGFibGVSb3ciLCJFeHRlcm5hbFNpdGVzTmF2TWVudSIsIiQiLCIkc3VibWl0QnV0dG9uIiwiJG1lbnVUb0VkaXQiLCIkbWVudUlucHV0IiwiJGV4dGVybmFsU2l0ZUlucHV0cyIsIiRzZWxlY3RBbGwiLCIkc3Bpbm5lciIsInNwaW5uZXIiLCJlbmFibGUiLCJleHRlcm5hbFNpdGVJZHMiLCJmaWx0ZXIiLCJwdXNoIiwiTnVtYmVyIiwidXBkYXRlU3VtYml0IiwicHJvcCIsIm9uQWpheEVycm9yIiwiYWxlcnQiLCJvbkFqYXhTdWNjZXNzIiwiJG1lbnUiLCJhcHBlbmQiLCJhamF4RGF0YSIsImlkcyIsIm5vbmNlQWN0aW9uIiwiZGF0YSIsIm5vbmNlVmFsdWUiLCJhamF4QWN0aW9uIiwiYWN0aW9uIiwibWxwX2V4dGVybmFsX3NpdGVzIiwibWVudSIsInNlbmRSZXF1ZXN0IiwiYWpheCIsInVybCIsImFqYXh1cmwiLCJtZXRob2QiLCJkYXRhVHlwZSIsImRvbmUiLCJyZXNwb25zZSIsInN1Y2Nlc3MiLCJmYWlsIiwiYWx3YXlzIiwic2libGluZ3MiLCJlIiwiYWRtaW5wYWdlIiwiZXh0ZXJuYWxTaXRlcyIsIm5hdk1lbnUiLCJyZWRpcmVjdEZhbGxiYWNrU2VsZWN0IiwiZG9jdW1lbnQiLCJxdWVyeVNlbGVjdG9yIiwicmVkaXJlY3RGYWxsYmFja0V4dGVybmFsU2l0ZVNlbGVjdCIsInJlZGlyZWN0RmFsbGJhY2tTZWxlY3RFeGlzdHMiLCJyZWRpcmVjdEZhbGxiYWNrRXh0ZXJuYWxTaXRlU2VsZWN0RXhpc3RzIiwiYWRkRXZlbnRMaXN0ZW5lciIsImRpc2FibGVkIiwiZGlzcGF0Y2hFdmVudCIsIkV2ZW50Il0sInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///259\n")}},__webpack_exports__={};__webpack_modules__[259]()})();
//# sourceMappingURL=admin.min.js.map