<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\ExternalSites\Integrations\Redirect;

use Inpsyde\MultilingualPress\Module\Redirect\GeoLocation\GeolocationFinderInterface;
use Inpsyde\MultilingualPress\Module\Redirect\RedirectTarget\RedirectTarget;
use RuntimeException;

/**
 * Can create RedirectTarget for external site.
 *
 * @psalm-type redirectTargetConfig = array{
 *      locale: string,
 *      priority: int,
 *      siteId: int,
 *      url: string,
 * }
 * @psalm-type languageCode = string
 */
interface ExternalSiteRedirectTargetFactoryInterface
{
    /**
     * Creates a new RedirectTarget instance with a given config.
     *
     * @param array<string, float> $userLanguages A map of language codes to priorities.
     * @psalm-var array<languageCode, float> $userLanguages
     * @param GeolocationFinderInterface $geolocationFinder
     * @param array $config The config.
     * @psalm-param redirectTargetConfig $config
     * @return RedirectTarget The new instance.
     * @throws RuntimeException If problem creating.
     */
    public function createExternalSiteRedirectTarget(
        array $userLanguages,
        GeolocationFinderInterface $geolocationFinder,
        array $config
    ): RedirectTarget;
}
