<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\ExternalSites\Integrations\Redirect;

use Inpsyde\MultilingualPress\Module\Redirect\GeoLocation\GeolocationFinderInterface;
use Inpsyde\MultilingualPress\Module\Redirect\RedirectTarget\RedirectTarget;

class ExternalSiteRedirectTargetFactory implements ExternalSiteRedirectTargetFactoryInterface
{
    /**
     * @inheritDoc
     */
    public function createExternalSiteRedirectTarget(
        array $userLanguages,
        GeolocationFinderInterface $geolocationFinder,
        array $config
    ): RedirectTarget {

        return new RedirectTarget(
            $userLanguages,
            $geolocationFinder,
            [
                RedirectTarget::KEY_LANGUAGE => $config['locale'] ?? '',
                RedirectTarget::KEY_PRIORITY_INDEX => $config['priority'] ?? 0,
                RedirectTarget::KEY_SITE_ID => $config['siteId'] ?? 0,
                RedirectTarget::KEY_URL => $config['url'] ?? '',
                RedirectTarget::KEY_REDIRECT_FALLBACK_PRIORITY => 1,
            ]
        );
    }
}
