<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Module\Blocks\BlockTypeRegistrar;

use Inpsyde\MultilingualPress\Module\Blocks\BlockType\BlockTypeInterface;
use RuntimeException;

class BlockTypeRegistrar implements BlockTypeRegistrarInterface
{
    /**
     * @var string
     */
    protected $scriptName;

    public function __construct(string $scriptName)
    {
        $this->scriptName = $scriptName;
    }

    /**
     * @inheritDoc
     */
    public function register(BlockTypeInterface $blockType): void
    {
        $registered = register_block_type(
            $blockType->name(),
            [
                'render_callback' => static function (array $attributes) use ($blockType): string {
                    return $blockType->render($attributes);
                },
                'attributes' => $blockType->attributes(),
            ]
        );

        if (!$registered) {
            throw new RuntimeException("Couldn't register the block");
        }
    }
}
