<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Translator;

use Inpsyde\MultilingualPress\Framework\Api\Translation;
use Inpsyde\MultilingualPress\Framework\Api\TranslationSearchArgs;

/**
 * Interface for all translator implementations.
 */
interface Translator
{
    /**
     * Returns the translation data for the given site, according to the given arguments.
     *
     * @param int $siteId
     * @param TranslationSearchArgs $args
     * @return Translation
     */
    public function translationFor(int $siteId, TranslationSearchArgs $args): Translation;
}
