<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Setting\User;

/**
 * Interface for all user setting view model implementations.
 */
interface UserSettingViewModel
{
    /**
     * Renders the user setting.
     *
     * @param \WP_User $user
     */
    public function render(\WP_User $user);

    /**
     * Returns the title of the user setting.
     *
     * @return string
     */
    public function title(): string;
}
