<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Setting;

interface SiteSettingsUpdatable
{
    /**
     * Defines the initial settings of a new site.
     *
     * @param int $siteId
     */
    public function defineInitialSettings(int $siteId);

    /**
     * Updates the settings of an existing site.
     *
     * @param int $siteId
     */
    public function updateSettings(int $siteId);
}
