<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Setting\Site;

/**
 * Interface for all site settings section view model implementations.
 */
interface SiteSettingsSectionViewModel
{
    /**
     * Returns the ID of the site settings section.
     *
     * @return string
     */
    public function id(): string;

    /**
     * Returns the markup for the site settings section.
     *
     * @param int $siteId
     * @return bool
     */
    public function renderView(int $siteId): bool;

    /**
     * Returns the title of the site settings section.
     *
     * @return string
     */
    public function title(): string;
}
