<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Setting\Site;

/**
 * Interface for all site setting view model implementations.
 */
interface SiteSettingViewModel
{
    /**
     * Renders the markup for the site setting.
     *
     * @param int $siteId
     */
    public function render(int $siteId);

    /**
     * Returns the title of the site setting.
     *
     * @return string
     */
    public function title(): string;
}
