<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Setting;

/**
 * Interface for all settings page repository implementations.
 *
 * @psalm-type settingName = string
 * @psalm-type settingValue = array | scalar
 */
interface SettingsRepositoryInterface
{
    /**
     * Returns all setting values for settings page.
     *
     * @return array | Scalar
     */
    public function allSettingValues();

    /**
     * Returns the setting value with given name.
     *
     * @param string $settingName The setting name.
     * @return array | Scalar
     */
    public function settingValue(string $settingName);

    /**
     * Updates the given setting values.
     *
     * @param array<string, mixed> $settingsMap A map of module setting names to values.
     * @psalm-param array<settingName, settingValue> $settingsMap
     * @return void
     */
    public function updateSettings(array $settingsMap): void;
}
