<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Setting;

/**
 * The interface for options of settings.
 */
interface SettingOptionInterface
{
    /**
     * The setting id
     *
     * @return string
     */
    public function id(): string;

    /**
     * The setting value
     *
     * @return string
     */
    public function value(): string;

    /**
     * The setting label
     *
     * @return string
     */
    public function label(): string;


    /**
     * The setting option description
     *
     * @return string
     */
    public function description(): string;
}
