<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Nonce;

use Inpsyde\MultilingualPress\Framework\Nonce\Exception\ContextValueManipulationNotAllowed;

trait ReadOnlyContextTrait
{
    /**
     * @param $name
     * @param $value
     * @throws ContextValueManipulationNotAllowed
     */
    public function offsetSet($name, $value): void
    {
        throw ContextValueManipulationNotAllowed::forName($name, 'set');
    }

    /**
     * @param $name
     * @throws ContextValueManipulationNotAllowed
     */
    public function offsetUnset($name): void
    {
        throw ContextValueManipulationNotAllowed::forName($name, 'unset');
    }
}
