<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Nonce;

/**
 * Interface for all nonce implementations.
 */
interface Nonce
{
    /**
     * Returns the nonce value.
     *
     * @return string
     */
    public function __toString(): string;

    /**
     * Returns the nonce action.
     *
     * @return string
     */
    public function action(): string;

    /**
     * Checks if the nonce is valid with respect to the given context.
     * Implementation can decide what to do in case of no context given.
     *
     * @param Context|null $context
     * @return bool
     */
    public function isValid(Context $context = null): bool;
}
