<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Module;

use Inpsyde\MultilingualPress\Framework\Service\Container;
use Inpsyde\MultilingualPress\Framework\Service\ServiceProvider;

/**
 * Interface for all module service provider implementations to be used for dependency management.
 */
interface ModuleServiceProvider extends ServiceProvider
{
    /**
     * Registers the module at the module manager.
     *
     * @param ModuleManager $moduleManager
     * @return bool
     */
    public function registerModule(ModuleManager $moduleManager): bool;

    /**
     * Performs various tasks on module activation.
     *
     * @param Container $container
     */
    public function activateModule(Container $container);
}
