<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Message;

/**
 * Interface Message
 * @package Inpsyde\MultilingualPress\Schedule\Action
 */
interface MessageInterface
{
    /**
     * Message Content
     *
     * @return string
     */
    public function content(): string;

    /**
     * Response Data
     *
     * @return array
     */
    public function data(): array;

    /**
     * @return string
     */
    public function type(): string;

    /**
     * @param string $type
     * @return bool
     */
    public function isOfType(string $type): bool;
}
