<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Filter;

/**
 * Interface for all filter implementations.
 */
interface Filter
{
    public const DEFAULT_ACCEPTED_ARGS = 1;
    public const DEFAULT_PRIORITY = 10;

    /**
     * Returns the number of accepted arguments.
     *
     * @return int
     */
    public function acceptedArgs(): int;

    /**
     * Removes the filter.
     *
     * @return bool
     */
    public function disable(): bool;

    /**
     * Adds the filter.
     *
     * @return bool
     */
    public function enable(): bool;

    /**
     * Returns the hook name.
     *
     * @return string
     */
    public function hook(): string;

    /**
     * Returns the callback priority.
     *
     * @return int
     */
    public function priority(): int;
}
