<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Factory;

use Inpsyde\MultilingualPress\Framework\Url\Url;

class UrlFactory
{
    /**
     * @var ClassResolver
     */
    private $classResolver;

    /**
     * @param ClassResolver $classResolver
     */
    public function __construct(ClassResolver $classResolver)
    {
        $this->classResolver = $classResolver;
    }

    /**
     * Returns a new url object of the given (or default) class,
     * instantiated with the given arguments.
     *
     * @param array $args
     * @param string|null $class
     * @return Url
     */
    public function create(array $args = [], string $class = null): Url
    {
        $class = $this->classResolver->resolve($class);

        return new $class(...$args);
    }
}
