<?php

declare(strict_types=1);

namespace Inpsyde\MultilingualPress\Framework\Cache\Exception;

class NotRegisteredCacheItem extends Exception
{
    /**
     * @param string $namespace
     * @param string $key
     * @return NotRegisteredCacheItem
     */
    public static function forNamespaceAndKey(
        string $namespace,
        string $key
    ): NotRegisteredCacheItem {

        return new static(
            sprintf(
                'The namespace/key pair "%s"/"%s" does not belong to any registered cache logic in cache server.',
                $namespace,
                $key
            )
        );
    }
}
