(function(){"use strict";var __webpack_modules__={695:function(){eval('\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleNoticeHtmlElement.js\nfunction _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }\nfunction _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\nvar ScheduleNoticeHtmlElement = /*#__PURE__*/function () {\n  /**\n   * @param {HTMLElement} htmlElement\n   */\n  function ScheduleNoticeHtmlElement(htmlElement) {\n    _classCallCheck(this, ScheduleNoticeHtmlElement);\n    this.htmlElement = htmlElement;\n  }\n\n  /**\n   * @param {string} estimatedTimeValue\n   */\n  _createClass(ScheduleNoticeHtmlElement, [{\n    key: "updateEstimatedTime",\n    value: function updateEstimatedTime(estimatedTimeValue) {\n      try {\n        estimatedTime(this.htmlElement).innerText = estimatedTimeValue;\n      } catch (error) {\n        console.warn(error);\n      }\n    }\n\n    /**\n     * @param {int} attachmentsNumber\n     */\n  }, {\n    key: "updateTotalAttachmentsNumber",\n    value: function updateTotalAttachmentsNumber(attachmentsNumber) {\n      try {\n        totalAttachmentsNumber(this.htmlElement).innerText = attachmentsNumber;\n      } catch (error) {\n        console.warn(error);\n      }\n    }\n\n    /**\n     * @param {string} contentText\n     */\n  }, {\n    key: "updateContent",\n    value: function updateContent(contentText) {\n      try {\n        content(this.htmlElement).innerHTML = contentText;\n      } catch (error) {\n        console.warn(error);\n      }\n    }\n\n    /**\n     * @param {Schedule} schedule\n     */\n  }, {\n    key: "updateProgressBar",\n    value: function updateProgressBar(schedule) {\n      var _schedule$stepsDone = schedule.stepsDone,\n        stepsDone = _schedule$stepsDone === void 0 ? 0 : _schedule$stepsDone,\n        _schedule$allSteps = schedule.allSteps,\n        allSteps = _schedule$allSteps === void 0 ? 0 : _schedule$allSteps;\n      if (!stepsDone || !allSteps) {\n        return;\n      }\n      var progressPercentage = Math.floor(stepsDone / allSteps * 100);\n      try {\n        progressBarElement(this.htmlElement).style.setProperty(\'width\', progressPercentage + \'%\');\n      } catch (error) {\n        console.warn(error);\n      }\n    }\n\n    /**\n     * @return void\n     */\n  }, {\n    key: "remove",\n    value: function remove() {\n      this.htmlElement.remove();\n    }\n\n    /**\n     * @param {string} noticeType\n     */\n  }, {\n    key: "updateNoticeType",\n    value: function updateNoticeType(noticeType) {\n      this.htmlElement.classList.remove(\'notice-info\', \'notice-success\', \'notice-error\', \'notice-warning\');\n      this.htmlElement.classList.add("notice-".concat(noticeType));\n    }\n\n    /**\n     * @param {string} name\n     * @param {string} value\n     */\n  }, {\n    key: "setStyleProperty",\n    value: function setStyleProperty(name, value) {\n      this.htmlElement.style.setProperty(name, value);\n    }\n  }]);\n  return ScheduleNoticeHtmlElement;\n}();\n\n/**\n * @param {HTMLElement} parent\n * @return {HTMLElement}\n * @throws {Error}\n */\nfunction content(parent) {\n  var element = parent.querySelector(\'.mlp-attachment-schedule-notice__content\');\n  if (!element) {\n    throw new Error("Parent Element for ".concat(parent.id, " cannot be found."));\n  }\n  return element;\n}\n\n/**\n * @param {HTMLElement} parent\n * @return {HTMLElement}\n * @throws {Error}\n */\nfunction estimatedTime(parent) {\n  var element = parent.querySelector(\'.mlp-new-site-schedule-steps__estimated-remaining-time\');\n  if (!element) {\n    throw new Error("Parent Element for ".concat(parent.id, " cannot be found."));\n  }\n  return element;\n}\n\n/**\n * @param {HTMLElement} parent\n * @return {HTMLElement}\n * @throws {Error}\n */\nfunction totalAttachmentsNumber(parent) {\n  var element = parent.querySelector(\'.mlp-new-site-schedule-steps__total-attachments\');\n  if (!element) {\n    throw new Error("Parent Element for ".concat(parent.id, " cannot be found."));\n  }\n  return element;\n}\n\n/**\n * @return {Element}\n * @throws {Error}\n */\nfunction progressBarElement(parent) {\n  var progressBarEl;\n  var progressEl = parent.querySelector(\'.mlp-new-site-schedule-notice-progress\');\n  if (progressEl) {\n    progressBarEl = progressEl.querySelector(\'.mlp-new-site-schedule-notice-progress__bar\');\n  }\n  if (!progressBarEl || typeof progressBarEl === \'undefined\') {\n    throw new Error("Parent Element for ".concat(parent.id, " cannot be found."));\n  }\n  return progressBarEl;\n}\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/EventDispatcher.js\nfunction EventDispatcher_typeof(o) { "@babel/helpers - typeof"; return EventDispatcher_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, EventDispatcher_typeof(o); }\nfunction EventDispatcher_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nfunction EventDispatcher_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, EventDispatcher_toPropertyKey(descriptor.key), descriptor); } }\nfunction EventDispatcher_createClass(Constructor, protoProps, staticProps) { if (protoProps) EventDispatcher_defineProperties(Constructor.prototype, protoProps); if (staticProps) EventDispatcher_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction EventDispatcher_toPropertyKey(arg) { var key = EventDispatcher_toPrimitive(arg, "string"); return EventDispatcher_typeof(key) === "symbol" ? key : String(key); }\nfunction EventDispatcher_toPrimitive(input, hint) { if (EventDispatcher_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (EventDispatcher_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\nvar EventDispatcher = /*#__PURE__*/function () {\n  /**\n   * @param {jQuery} dOMDocument\n   */\n  function EventDispatcher(dOMDocument) {\n    EventDispatcher_classCallCheck(this, EventDispatcher);\n    this.dOMDocument = dOMDocument;\n  }\n\n  /**\n   * @param {string} eventName\n   * @param {Array|Object} args\n   */\n  EventDispatcher_createClass(EventDispatcher, [{\n    key: "dispatch",\n    value: function dispatch(eventName) {\n      var _this$dOMDocument;\n      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n        args[_key - 1] = arguments[_key];\n      }\n      (_this$dOMDocument = this.dOMDocument).trigger.apply(_this$dOMDocument, [eventName].concat(args));\n    }\n  }]);\n  return EventDispatcher;\n}();\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleNotice.js\nfunction ScheduleNotice_typeof(o) { "@babel/helpers - typeof"; return ScheduleNotice_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, ScheduleNotice_typeof(o); }\nfunction ScheduleNotice_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nfunction ScheduleNotice_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, ScheduleNotice_toPropertyKey(descriptor.key), descriptor); } }\nfunction ScheduleNotice_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleNotice_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleNotice_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction ScheduleNotice_toPropertyKey(arg) { var key = ScheduleNotice_toPrimitive(arg, "string"); return ScheduleNotice_typeof(key) === "symbol" ? key : String(key); }\nfunction ScheduleNotice_toPrimitive(input, hint) { if (ScheduleNotice_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (ScheduleNotice_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\n\nvar ACTION_SCHEDULE_NOTICE_UPDATED = \'multilingualpress.schedule_notice_updated\';\nvar ScheduleNotice = /*#__PURE__*/function () {\n  /**\n   * @param {jQuery} jQuery\n   * @param {EventDispatcher} eventDispatcher\n   * @param {ScheduleNoticeHtmlElement} scheduleNoticeHtmlElement\n   * @param {ScheduleStatusStorage} scheduleStatusStorage\n   */\n  function ScheduleNotice(jQuery, eventDispatcher, scheduleNoticeHtmlElement, scheduleStatusStorage) {\n    ScheduleNotice_classCallCheck(this, ScheduleNotice);\n    this.jQuery = jQuery;\n    this.eventDispatcher = eventDispatcher;\n    this.scheduleNoticeHtmlElement = scheduleNoticeHtmlElement;\n    this.scheduleStatusStorage = scheduleStatusStorage;\n  }\n\n  /**\n   * Remove the schedule admin notice element from the DOM\n   *\n   * @return void\n   */\n  ScheduleNotice_createClass(ScheduleNotice, [{\n    key: "remove",\n    value: function remove() {\n      this.scheduleNoticeHtmlElement.remove();\n    }\n\n    /**\n     * Update the admin notice with a content\n     *\n     * @param {string} content\n     * @param {string} type\n     * @return void\n     */\n  }, {\n    key: "updateScheduleNoticeWithMessage",\n    value: function updateScheduleNoticeWithMessage(content, type) {\n      if (!content) {\n        return;\n      }\n      this.scheduleNoticeHtmlElement.updateContent(content);\n      type && this.scheduleNoticeHtmlElement.updateNoticeType(type);\n    }\n\n    /**\n     * Update the schedule notice with new information for schedule by the server\n     *\n     * @param {ScheduleStatus} scheduleStatus\n     *\n     * @return void\n     */\n  }, {\n    key: "updateScheduleNoticeWithStatus",\n    value: function updateScheduleNoticeWithStatus(scheduleStatus) {\n      var schedule = scheduleStatus.schedule,\n        estimatedRemainingTime = scheduleStatus.estimatedRemainingTime;\n      var attachmentsNumber = schedule.args.attachmentsNumber;\n      this.scheduleNoticeHtmlElement.updateTotalAttachmentsNumber(attachmentsNumber);\n      this.scheduleNoticeHtmlElement.updateEstimatedTime(estimatedRemainingTime);\n      this.scheduleNoticeHtmlElement.updateProgressBar(schedule);\n      this.scheduleStatusStorage.updateSetWithStatus(scheduleStatus);\n      this.eventDispatcher.dispatch(ACTION_SCHEDULE_NOTICE_UPDATED, schedule);\n    }\n\n    /**\n     * @return void\n     */\n  }, {\n    key: "show",\n    value: function show() {\n      this.scheduleNoticeHtmlElement.setStyleProperty(\'display\', \'flex\');\n    }\n\n    /**\n     * @return void\n     */\n  }, {\n    key: "hide",\n    value: function hide() {\n      this.scheduleNoticeHtmlElement.setStyleProperty(\'display\', \'none\');\n    }\n  }]);\n  return ScheduleNotice;\n}();\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleStatus.js\nfunction ScheduleStatus_typeof(o) { "@babel/helpers - typeof"; return ScheduleStatus_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, ScheduleStatus_typeof(o); }\nfunction ScheduleStatus_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, ScheduleStatus_toPropertyKey(descriptor.key), descriptor); } }\nfunction ScheduleStatus_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleStatus_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleStatus_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction ScheduleStatus_toPropertyKey(arg) { var key = ScheduleStatus_toPrimitive(arg, "string"); return ScheduleStatus_typeof(key) === "symbol" ? key : String(key); }\nfunction ScheduleStatus_toPrimitive(input, hint) { if (ScheduleStatus_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (ScheduleStatus_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\nfunction ScheduleStatus_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nvar ScheduleStatus = /*#__PURE__*/ScheduleStatus_createClass(\n/**\n * Do not create this instance directly use ScheduleStatusFactory\n *\n * @param {Schedule} schedule\n * @param {int} stepToFinish\n * @param {string} estimatedRemainingTime\n */\nfunction ScheduleStatus(_ref) {\n  var schedule = _ref.schedule,\n    stepToFinish = _ref.stepToFinish,\n    estimatedRemainingTime = _ref.estimatedRemainingTime;\n  ScheduleStatus_classCallCheck(this, ScheduleStatus);\n  this.schedule = schedule;\n  this.stepToFinish = stepToFinish;\n  this.estimatedRemainingTime = estimatedRemainingTime;\n});\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleStatusFactory.js\nfunction ScheduleStatusFactory_typeof(o) { "@babel/helpers - typeof"; return ScheduleStatusFactory_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, ScheduleStatusFactory_typeof(o); }\nfunction ScheduleStatusFactory_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nfunction ScheduleStatusFactory_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, ScheduleStatusFactory_toPropertyKey(descriptor.key), descriptor); } }\nfunction ScheduleStatusFactory_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleStatusFactory_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleStatusFactory_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction ScheduleStatusFactory_toPropertyKey(arg) { var key = ScheduleStatusFactory_toPrimitive(arg, "string"); return ScheduleStatusFactory_typeof(key) === "symbol" ? key : String(key); }\nfunction ScheduleStatusFactory_toPrimitive(input, hint) { if (ScheduleStatusFactory_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (ScheduleStatusFactory_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\n\nvar ScheduleStatusFactory = /*#__PURE__*/function () {\n  /**\n   * @param {ScheduleFactory} scheduleFactory\n   */\n  function ScheduleStatusFactory(scheduleFactory) {\n    ScheduleStatusFactory_classCallCheck(this, ScheduleStatusFactory);\n    this.scheduleFactory = scheduleFactory;\n  }\n\n  /**\n   * @params {Object} args\n   * @return {ScheduleStatus}\n   */\n  ScheduleStatusFactory_createClass(ScheduleStatusFactory, [{\n    key: "create",\n    value: function create(args) {\n      var cloned = Object.assign({}, args);\n      var _cloned$schedule = cloned.schedule,\n        schedule = _cloned$schedule === void 0 ? {} : _cloned$schedule;\n      cloned.schedule = this.scheduleFactory.create(schedule);\n      var scheduleStatus = new ScheduleStatus(cloned);\n      return Object.freeze(scheduleStatus);\n    }\n  }]);\n  return ScheduleStatusFactory;\n}();\n;// CONCATENATED MODULE: ./build/resources/js/utils.js\n/**\n * @param {Object} object\n * @returns {boolean}\n */\nfunction isElement(object) {\n  return object instanceof Element;\n}\n\n/**\n * @param {Object} property\n * @returns {boolean}\n */\nfunction isUndefined(property) {\n  return typeof property !== \'undefined\';\n}\n\n/**\n * @param {string} functionName\n * @returns {boolean}\n */\nfunction isFunction(functionName) {\n  return typeof functionName === \'function\';\n}\n\n/**\n * Utils\n *\n * @type {{isElement: *}}\n */\nvar utils = {\n  isElement: isElement,\n  isUndefined: isUndefined,\n  isFunction: isFunction\n};\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/Form.js\nfunction Form_typeof(o) { "@babel/helpers - typeof"; return Form_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, Form_typeof(o); }\nfunction Form_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nfunction Form_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, Form_toPropertyKey(descriptor.key), descriptor); } }\nfunction Form_createClass(Constructor, protoProps, staticProps) { if (protoProps) Form_defineProperties(Constructor.prototype, protoProps); if (staticProps) Form_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction Form_toPropertyKey(arg) { var key = Form_toPrimitive(arg, "string"); return Form_typeof(key) === "symbol" ? key : String(key); }\nfunction Form_toPrimitive(input, hint) { if (Form_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (Form_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\n\n\n/**\n * Form Class\n */\nvar Form = /*#__PURE__*/function () {\n  /**\n   * @param {HTMLElement} form\n   * @param {Object} translations\n   * @param {Function} alert\n   */\n  function Form(form, translations, alert) {\n    Form_classCallCheck(this, Form);\n    this.form = form;\n    this.translations = translations;\n    this.alert = alert;\n    this.eventCallback = this.preventFormSubmission.bind(this);\n  }\n\n  /**\n   * Block the submission of the form that are within the page\n   */\n  Form_createClass(Form, [{\n    key: "blockFormSubmission",\n    value: function blockFormSubmission() {\n      this.form.addEventListener(\'submit\', this.eventCallback);\n    }\n\n    /**\n     * Release Form Submission, allowing to submit forms again\n     */\n  }, {\n    key: "releaseFormSubmission",\n    value: function releaseFormSubmission() {\n      this.form.removeEventListener(\'submit\', this.eventCallback);\n    }\n\n    /**\n     * @param {Event} event\n     */\n  }, {\n    key: "preventFormSubmission",\n    value: function preventFormSubmission(event) {\n      event.preventDefault();\n      event.stopImmediatePropagation();\n      if (!utils.isUndefined(this.translations.preventFormSubmissionMessage)) {\n        this.alert(this.translations.preventFormSubmissionMessage);\n      }\n    }\n  }]);\n  return Form;\n}();\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleStatusUpdater.js\nfunction ScheduleStatusUpdater_typeof(o) { "@babel/helpers - typeof"; return ScheduleStatusUpdater_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, ScheduleStatusUpdater_typeof(o); }\nfunction ScheduleStatusUpdater_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nfunction ScheduleStatusUpdater_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, ScheduleStatusUpdater_toPropertyKey(descriptor.key), descriptor); } }\nfunction ScheduleStatusUpdater_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleStatusUpdater_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleStatusUpdater_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction ScheduleStatusUpdater_toPropertyKey(arg) { var key = ScheduleStatusUpdater_toPrimitive(arg, "string"); return ScheduleStatusUpdater_typeof(key) === "symbol" ? key : String(key); }\nfunction ScheduleStatusUpdater_toPrimitive(input, hint) { if (ScheduleStatusUpdater_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (ScheduleStatusUpdater_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\nvar ScheduleStatusUpdater = /*#__PURE__*/function () {\n  /**\n   * @param {Object} requestClient\n   * @param {ScheduleStatusResponseHandler} scheduleStatusResponseHandler\n   * @param {Form} form\n   * @param {Document} domDocument\n   * @param {string} ajaxUrl\n   */\n  function ScheduleStatusUpdater(requestClient, scheduleStatusResponseHandler, form, domDocument, ajaxUrl) {\n    ScheduleStatusUpdater_classCallCheck(this, ScheduleStatusUpdater);\n    this.requestClient = requestClient;\n    this.scheduleStatusResponseHandler = scheduleStatusResponseHandler;\n    this.form = form;\n    this.domDocument = domDocument;\n    this.ajaxUrl = ajaxUrl;\n    this.ajaxEvent = null;\n  }\n\n  /**\n   * Retrieve information for the current cron job by the server\n   *\n   * @return void\n   */\n  ScheduleStatusUpdater_createClass(ScheduleStatusUpdater, [{\n    key: "update",\n    value: function update() {\n      var _this = this;\n      this.ajaxEvent = this.requestClient({\n        url: this.ajaxUrl,\n        complete: function complete(jqXHR, textStatus) {\n          var success = jqXHR.responseJSON.success;\n          var errorStatuses = [\'error\', \'abort\', \'parsererror\'];\n          if (errorStatuses.includes(textStatus)) {\n            return false;\n          }\n          success && _this.delayUpdate();\n        },\n        success: function success(response) {\n          return _this.scheduleStatusResponseHandler.successHandler(response);\n        },\n        error: function error() {\n          return _this.scheduleStatusResponseHandler.errorHandler();\n        }\n      });\n    }\n\n    /**\n     * @return void\n     */\n  }, {\n    key: "delayUpdate",\n    value: function delayUpdate() {\n      setTimeout(this.update, 1000);\n    }\n\n    /**\n     * @return void\n     */\n  }, {\n    key: "detachAjaxEvent",\n    value: function detachAjaxEvent() {\n      this.ajaxEvent && this.domDocument.off(\'ajaxSend\', this.ajaxEvent);\n    }\n  }]);\n  return ScheduleStatusUpdater;\n}();\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleStatusResponseHandler.js\nfunction ScheduleStatusResponseHandler_typeof(o) { "@babel/helpers - typeof"; return ScheduleStatusResponseHandler_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, ScheduleStatusResponseHandler_typeof(o); }\nfunction ScheduleStatusResponseHandler_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nfunction ScheduleStatusResponseHandler_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, ScheduleStatusResponseHandler_toPropertyKey(descriptor.key), descriptor); } }\nfunction ScheduleStatusResponseHandler_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleStatusResponseHandler_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleStatusResponseHandler_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction ScheduleStatusResponseHandler_toPropertyKey(arg) { var key = ScheduleStatusResponseHandler_toPrimitive(arg, "string"); return ScheduleStatusResponseHandler_typeof(key) === "symbol" ? key : String(key); }\nfunction ScheduleStatusResponseHandler_toPrimitive(input, hint) { if (ScheduleStatusResponseHandler_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (ScheduleStatusResponseHandler_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\nvar ACTION_SCHEDULE_STATUS_UPDATE_ERROR = \'multilingualpress.schedule_status_update_error\';\nvar ACTION_SCHEDULE_STATUS_UPDATED = \'multilingualpress.schedule_status_updated\';\nvar ScheduleStatusResponseHandler = /*#__PURE__*/function () {\n  /**\n   * @param {ScheduleNotice} scheduleNotice\n   * @param {EventDispatcher} eventDispatcher\n   * @param {ScheduleStatusFactory} scheduleStatusFactory\n   * @param form\n   * @param {*} translations\n   */\n  function ScheduleStatusResponseHandler(scheduleNotice, eventDispatcher, scheduleStatusFactory, form, translations) {\n    ScheduleStatusResponseHandler_classCallCheck(this, ScheduleStatusResponseHandler);\n    this.scheduleNotice = scheduleNotice;\n    this.eventDispatcher = eventDispatcher;\n    this.scheduleStatusFactory = scheduleStatusFactory;\n    this.form = form;\n    this.translations = translations;\n  }\n\n  /**\n   * @param {Object} response\n   */\n  ScheduleStatusResponseHandler_createClass(ScheduleStatusResponseHandler, [{\n    key: "successHandler",\n    value: function successHandler(response) {\n      var _response$data = response.data,\n        data = _response$data === void 0 ? {} : _response$data,\n        _response$success = response.success,\n        success = _response$success === void 0 ? false : _response$success;\n\n      /*\n       * There\'s not case for schedule succeed.\n       * When the schedule ends it will not exists, means this catch also\n       * the case when the schedule succeed.\n       */\n      if (!success) {\n        this.scheduleNotice.remove();\n        this.eventDispatcher.dispatch(ACTION_SCHEDULE_STATUS_UPDATE_ERROR);\n        return;\n      }\n      this.scheduleNotice.show();\n      var scheduleStatus = this.scheduleStatusFactory.create(data);\n      this.scheduleNotice.updateScheduleNoticeWithStatus(scheduleStatus);\n      this.eventDispatcher.dispatch(ACTION_SCHEDULE_STATUS_UPDATED, response);\n    }\n\n    /**\n     * @param {jqXHR} jqXHR\n     * @param {string} textStatus\n     * @param {string} errorThrown\n     */\n  }, {\n    key: "errorHandler",\n    value: function errorHandler(jqXHR, textStatus, errorThrown) {\n      this.scheduleNotice.updateScheduleNoticeWithMessage(this.translations.scheduleInfoErrorMessage, \'error\');\n      this.eventDispatcher.dispatch(ACTION_SCHEDULE_STATUS_UPDATE_ERROR, {\n        message: errorThrown\n      });\n    }\n  }]);\n  return ScheduleStatusResponseHandler;\n}();\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/Spinner.js\nfunction Spinner_typeof(o) { "@babel/helpers - typeof"; return Spinner_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, Spinner_typeof(o); }\nfunction Spinner_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nfunction Spinner_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, Spinner_toPropertyKey(descriptor.key), descriptor); } }\nfunction Spinner_createClass(Constructor, protoProps, staticProps) { if (protoProps) Spinner_defineProperties(Constructor.prototype, protoProps); if (staticProps) Spinner_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction Spinner_toPropertyKey(arg) { var key = Spinner_toPrimitive(arg, "string"); return Spinner_typeof(key) === "symbol" ? key : String(key); }\nfunction Spinner_toPrimitive(input, hint) { if (Spinner_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (Spinner_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\n\nvar POSITION_BEFORE_BEGIN = \'beforebegin\';\nvar POSITION_AFTER_BEGIN = \'afterbegin\';\nvar POSITION_BEFORE_END = \'beforeend\';\nvar POSITION_AFTER_END = \'afterend\';\nvar VALID_POSITIONS = [POSITION_BEFORE_BEGIN, POSITION_AFTER_BEGIN, POSITION_BEFORE_END, POSITION_AFTER_END];\nvar Spinner = /*#__PURE__*/function () {\n  /**\n   * @param {string} position\n   * @param {string} selector\n   * @param {string} template\n   */\n  function Spinner(position, selector, template) {\n    Spinner_classCallCheck(this, Spinner);\n    if (!positionIsAllowed(position)) {\n      throw new Error("Position accept only the following values: \\"".concat(VALID_POSITIONS, "\\""));\n    }\n    this.position = position;\n    this.selector = selector;\n    this.template = template;\n  }\n\n  /**\n   * @param {Element} element\n   */\n  Spinner_createClass(Spinner, [{\n    key: "replaceInto",\n    value: function replaceInto(element) {\n      if (!utils.isElement(element)) {\n        return;\n      }\n      this.removeFrom(element);\n      this.insertInto(element);\n    }\n\n    /**\n     * @param {Element} element\n     */\n  }, {\n    key: "insertInto",\n    value: function insertInto(element) {\n      if (!utils.isElement(element)) {\n        return;\n      }\n      element.insertAdjacentHTML(this.position, this.template);\n    }\n\n    /**\n     * @param {Element} element\n     */\n  }, {\n    key: "removeFrom",\n    value: function removeFrom(element) {\n      if (!utils.isElement(element)) {\n        return;\n      }\n      var existingSpinner = element.querySelector(this.selector);\n      existingSpinner && existingSpinner.remove();\n    }\n  }]);\n  return Spinner;\n}();\n\n/**\n * @param {string} position\n * @return {boolean}\n */\nfunction positionIsAllowed(position) {\n  return VALID_POSITIONS.includes(position);\n}\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleArguments.js\nfunction ScheduleArguments_typeof(o) { "@babel/helpers - typeof"; return ScheduleArguments_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, ScheduleArguments_typeof(o); }\nfunction ScheduleArguments_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, ScheduleArguments_toPropertyKey(descriptor.key), descriptor); } }\nfunction ScheduleArguments_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleArguments_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleArguments_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction ScheduleArguments_toPropertyKey(arg) { var key = ScheduleArguments_toPrimitive(arg, "string"); return ScheduleArguments_typeof(key) === "symbol" ? key : String(key); }\nfunction ScheduleArguments_toPrimitive(input, hint) { if (ScheduleArguments_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (ScheduleArguments_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\nfunction ScheduleArguments_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nvar ScheduleArguments = /*#__PURE__*/ScheduleArguments_createClass(\n/**\n * @param {int} sourceSiteId\n * @param {int} newSiteId\n * @param {int} attachmentsNumber\n */\nfunction ScheduleArguments(_ref) {\n  var sourceSiteId = _ref.sourceSiteId,\n    newSiteId = _ref.newSiteId,\n    attachmentsNumber = _ref.attachmentsNumber;\n  ScheduleArguments_classCallCheck(this, ScheduleArguments);\n  this.sourceSiteId = sourceSiteId;\n  this.newSiteId = newSiteId;\n  this.attachmentsNumber = attachmentsNumber;\n});\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/Schedule.js\nfunction Schedule_typeof(o) { "@babel/helpers - typeof"; return Schedule_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, Schedule_typeof(o); }\nfunction Schedule_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, Schedule_toPropertyKey(descriptor.key), descriptor); } }\nfunction Schedule_createClass(Constructor, protoProps, staticProps) { if (protoProps) Schedule_defineProperties(Constructor.prototype, protoProps); if (staticProps) Schedule_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction Schedule_toPropertyKey(arg) { var key = Schedule_toPrimitive(arg, "string"); return Schedule_typeof(key) === "symbol" ? key : String(key); }\nfunction Schedule_toPrimitive(input, hint) { if (Schedule_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (Schedule_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\nfunction Schedule_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nvar Schedule = /*#__PURE__*/Schedule_createClass(\n/**\n * @param {string} id\n * @param {int} stepsDone\n * @param {int} allSteps\n * @param {int} started\n * @param {int} lastUpdate\n * @param {ScheduleArguments} args\n */\nfunction Schedule(_ref) {\n  var id = _ref.id,\n    stepsDone = _ref.stepsDone,\n    allSteps = _ref.allSteps,\n    started = _ref.started,\n    lastUpdate = _ref.lastUpdate,\n    args = _ref.args;\n  Schedule_classCallCheck(this, Schedule);\n  this.id = id;\n  this.stepsDone = stepsDone;\n  this.allSteps = allSteps;\n  this.started = started;\n  this.lastUpdate = lastUpdate;\n  this.args = args;\n});\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleFactory.js\nfunction ScheduleFactory_typeof(o) { "@babel/helpers - typeof"; return ScheduleFactory_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, ScheduleFactory_typeof(o); }\nfunction ScheduleFactory_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nfunction ScheduleFactory_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, ScheduleFactory_toPropertyKey(descriptor.key), descriptor); } }\nfunction ScheduleFactory_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleFactory_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleFactory_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction ScheduleFactory_toPropertyKey(arg) { var key = ScheduleFactory_toPrimitive(arg, "string"); return ScheduleFactory_typeof(key) === "symbol" ? key : String(key); }\nfunction ScheduleFactory_toPrimitive(input, hint) { if (ScheduleFactory_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (ScheduleFactory_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\n\n\nvar ScheduleFactory = /*#__PURE__*/function () {\n  function ScheduleFactory() {\n    ScheduleFactory_classCallCheck(this, ScheduleFactory);\n  }\n  ScheduleFactory_createClass(ScheduleFactory, [{\n    key: "create",\n    value:\n    /**\n     * @param {Object} data\n     * @return {Schedule}\n     */\n    function create(data) {\n      var cloned = Object.assign({}, data);\n      var _cloned$args = cloned.args,\n        args = _cloned$args === void 0 ? {} : _cloned$args;\n      cloned.args = Object.freeze(new ScheduleArguments(args));\n      var schedule = new Schedule(cloned);\n      return Object.freeze(schedule);\n    }\n  }]);\n  return ScheduleFactory;\n}();\n;// CONCATENATED MODULE: ./build/resources/js/Nonce.js\nfunction Nonce_typeof(o) { "@babel/helpers - typeof"; return Nonce_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, Nonce_typeof(o); }\nfunction Nonce_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, Nonce_toPropertyKey(descriptor.key), descriptor); } }\nfunction Nonce_createClass(Constructor, protoProps, staticProps) { if (protoProps) Nonce_defineProperties(Constructor.prototype, protoProps); if (staticProps) Nonce_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction Nonce_toPropertyKey(arg) { var key = Nonce_toPrimitive(arg, "string"); return Nonce_typeof(key) === "symbol" ? key : String(key); }\nfunction Nonce_toPrimitive(input, hint) { if (Nonce_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (Nonce_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\nfunction Nonce_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nvar Nonce = /*#__PURE__*/Nonce_createClass(\n/**\n * @param nonce\n * @param action\n */\nfunction Nonce(nonce, action) {\n  Nonce_classCallCheck(this, Nonce);\n  if (typeof nonce !== \'string\' || !nonce) {\n    throw new Error(\'Expected nonce to be a string\');\n  }\n  if (typeof action !== \'string\' || !action) {\n    throw new Error(\'Expected action to be a string\');\n  }\n  this.nonce = nonce;\n  this.action = action;\n});\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/action/StopAttachmentDuplicationProcessClient.js\nfunction StopAttachmentDuplicationProcessClient_typeof(o) { "@babel/helpers - typeof"; return StopAttachmentDuplicationProcessClient_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, StopAttachmentDuplicationProcessClient_typeof(o); }\nfunction _defineProperty(obj, key, value) { key = StopAttachmentDuplicationProcessClient_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\nfunction StopAttachmentDuplicationProcessClient_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nfunction StopAttachmentDuplicationProcessClient_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, StopAttachmentDuplicationProcessClient_toPropertyKey(descriptor.key), descriptor); } }\nfunction StopAttachmentDuplicationProcessClient_createClass(Constructor, protoProps, staticProps) { if (protoProps) StopAttachmentDuplicationProcessClient_defineProperties(Constructor.prototype, protoProps); if (staticProps) StopAttachmentDuplicationProcessClient_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction StopAttachmentDuplicationProcessClient_toPropertyKey(arg) { var key = StopAttachmentDuplicationProcessClient_toPrimitive(arg, "string"); return StopAttachmentDuplicationProcessClient_typeof(key) === "symbol" ? key : String(key); }\nfunction StopAttachmentDuplicationProcessClient_toPrimitive(input, hint) { if (StopAttachmentDuplicationProcessClient_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (StopAttachmentDuplicationProcessClient_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\nvar StopAttachmentDuplicationProcessClient = /*#__PURE__*/function () {\n  /**\n   * @param {*} request\n   * @param {string} ajaxUrl\n   * @param {Nonce} nonce\n   * @param {string} action\n   * @param {StopAttachmentDuplicationProcessResponseHandler} responseHandler\n   * @param {Spinner} spinner\n   */\n  function StopAttachmentDuplicationProcessClient(request, ajaxUrl, nonce, action, responseHandler, spinner) {\n    StopAttachmentDuplicationProcessClient_classCallCheck(this, StopAttachmentDuplicationProcessClient);\n    this.request = request;\n    this.ajaxUrl = ajaxUrl;\n    this.nonce = nonce;\n    this.action = action;\n    this.responseHandler = responseHandler;\n    this.spinner = spinner;\n  }\n\n  /**\n   * @param {Object} target\n   * @param {Schedule} schedule\n   */\n  StopAttachmentDuplicationProcessClient_createClass(StopAttachmentDuplicationProcessClient, [{\n    key: "call",\n    value: function call(target, _ref) {\n      var _data,\n        _this = this;\n      var _ref$schedule = _ref.schedule,\n        schedule = _ref$schedule === void 0 ? null : _ref$schedule;\n      if (!schedule) {\n        return;\n      }\n      var data = (_data = {\n        action: this.action\n      }, _defineProperty(_data, this.action, \'stop_attachments_copy\'), _defineProperty(_data, this.nonce.action, this.nonce.nonce), _defineProperty(_data, "scheduleId", schedule.id), _defineProperty(_data, "siteId", schedule.args.newSiteId), _data);\n      this.request({\n        url: this.ajaxUrl,\n        data: data,\n        method: \'POST\',\n        beforeSend: function beforeSend() {\n          return _this.spinner.replaceInto(target.parentNode);\n        },\n        complete: function complete() {\n          return _this.spinner.removeFrom(target.parentNode);\n        },\n        success: function success(response) {\n          return _this.responseHandler.success(response);\n        },\n        error: function error(jqXHR, textStatus, errorThrown) {\n          return _this.responseHandler.error(jqXHR, textStatus, errorThrown);\n        }\n      });\n    }\n  }]);\n  return StopAttachmentDuplicationProcessClient;\n}();\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/action/StopAttachmentDuplicationProcessResponseHandler.js\nfunction StopAttachmentDuplicationProcessResponseHandler_typeof(o) { "@babel/helpers - typeof"; return StopAttachmentDuplicationProcessResponseHandler_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, StopAttachmentDuplicationProcessResponseHandler_typeof(o); }\nfunction StopAttachmentDuplicationProcessResponseHandler_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nfunction StopAttachmentDuplicationProcessResponseHandler_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, StopAttachmentDuplicationProcessResponseHandler_toPropertyKey(descriptor.key), descriptor); } }\nfunction StopAttachmentDuplicationProcessResponseHandler_createClass(Constructor, protoProps, staticProps) { if (protoProps) StopAttachmentDuplicationProcessResponseHandler_defineProperties(Constructor.prototype, protoProps); if (staticProps) StopAttachmentDuplicationProcessResponseHandler_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction StopAttachmentDuplicationProcessResponseHandler_toPropertyKey(arg) { var key = StopAttachmentDuplicationProcessResponseHandler_toPrimitive(arg, "string"); return StopAttachmentDuplicationProcessResponseHandler_typeof(key) === "symbol" ? key : String(key); }\nfunction StopAttachmentDuplicationProcessResponseHandler_toPrimitive(input, hint) { if (StopAttachmentDuplicationProcessResponseHandler_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (StopAttachmentDuplicationProcessResponseHandler_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\nvar ACTION_STOP_ATTACHMENT_DUPLICATION_SUCCEED = \'multilingualpress.stop_attachment_duplication_succeed\';\nvar ACTION_STOP_ATTACHMENT_DUPLICATION_FAILS = \'multilingualpress.stop_attachment_duplication_fails\';\nvar StopAttachmentDuplicationProcessResponseHandler = /*#__PURE__*/function () {\n  /**\n   * @param {ScheduleNotice} scheduleNotice\n   * @param {EventDispatcher} eventDispatcher\n   */\n  function StopAttachmentDuplicationProcessResponseHandler(scheduleNotice, eventDispatcher) {\n    StopAttachmentDuplicationProcessResponseHandler_classCallCheck(this, StopAttachmentDuplicationProcessResponseHandler);\n    this.scheduleNotice = scheduleNotice;\n    this.eventDispatcher = eventDispatcher;\n  }\n\n  /**\n   * @param response\n   */\n  StopAttachmentDuplicationProcessResponseHandler_createClass(StopAttachmentDuplicationProcessResponseHandler, [{\n    key: "success",\n    value: function success(response) {\n      var _response$data$conten = response.data.content,\n        content = _response$data$conten === void 0 ? \'\' : _response$data$conten,\n        _response$success = response.success,\n        success = _response$success === void 0 ? false : _response$success;\n      this.scheduleNotice.updateScheduleNoticeWithMessage(content, success ? \'success\' : \'error\');\n      success && this.eventDispatcher.dispatch(ACTION_STOP_ATTACHMENT_DUPLICATION_SUCCEED, response);\n      !success && this.eventDispatcher.dispatch(ACTION_STOP_ATTACHMENT_DUPLICATION_FAILS, response);\n    }\n\n    /**\n     * @param jqXHR\n     * @param textStatus\n     * @param errorThrown\n     */\n  }, {\n    key: "error",\n    value: function error(jqXHR, textStatus, errorThrown) {\n      this.scheduleNotice.updateScheduleNoticeWithMessage("".concat(textStatus, " : ").concat(errorThrown), \'error\');\n    }\n  }]);\n  return StopAttachmentDuplicationProcessResponseHandler;\n}();\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleStatusStorage.js\nfunction ScheduleStatusStorage_typeof(o) { "@babel/helpers - typeof"; return ScheduleStatusStorage_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, ScheduleStatusStorage_typeof(o); }\nfunction ScheduleStatusStorage_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\nfunction ScheduleStatusStorage_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, ScheduleStatusStorage_toPropertyKey(descriptor.key), descriptor); } }\nfunction ScheduleStatusStorage_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleStatusStorage_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleStatusStorage_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }\nfunction ScheduleStatusStorage_toPropertyKey(arg) { var key = ScheduleStatusStorage_toPrimitive(arg, "string"); return ScheduleStatusStorage_typeof(key) === "symbol" ? key : String(key); }\nfunction ScheduleStatusStorage_toPrimitive(input, hint) { if (ScheduleStatusStorage_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (ScheduleStatusStorage_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }\nvar ScheduleStatusStorage = /*#__PURE__*/function () {\n  /**\n   * @param {HTMLElement} htmlElement\n   * @param {ScheduleStatusFactory} scheduleStatusFactory\n   */\n  function ScheduleStatusStorage(htmlElement, scheduleStatusFactory) {\n    ScheduleStatusStorage_classCallCheck(this, ScheduleStatusStorage);\n    this.htmlElement = htmlElement;\n    this.scheduleStatusFactory = scheduleStatusFactory;\n  }\n\n  /**\n   * @param {ScheduleStatus} scheduleStatus\n   */\n  ScheduleStatusStorage_createClass(ScheduleStatusStorage, [{\n    key: "updateSetWithStatus",\n    value: function updateSetWithStatus(scheduleStatus) {\n      this.htmlElement.dataset.currentSchedule = JSON.stringify(scheduleStatus);\n    }\n\n    /**\n     * @return {ScheduleStatus}\n     */\n  }, {\n    key: "status",\n    value: function status() {\n      if (typeof this.htmlElement.dataset.currentSchedule !== \'undefined\') {\n        return {};\n      }\n      var scheduleStatus = this.scheduleStatusFactory.create(JSON.parse(this.htmlElement.dataset.currentSchedule));\n      return scheduleStatus;\n    }\n  }]);\n  return ScheduleStatusStorage;\n}();\n;// CONCATENATED MODULE: ./build/resources/js/siteDuplication/admin.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n(function (jQuery, adminpage, siteDuplicatorScheduleData) {\n  /**\n   * Create the admin notice UI where to show the information about the current\n   * tasks performed by the server.\n   *\n   * @return {*}\n   */\n  function initializeScheduleNoticeUI() {\n    var scheduleNoticeTemplate = document.querySelector(\'#mlp_new_site_schedule_tmpl\');\n    if (!scheduleNoticeTemplate) {\n      throw new Error(\'Schedule Notice Template does not exists.\');\n    }\n    document.querySelector(\'#add-new-site\').insertAdjacentHTML(\'afterend\', scheduleNoticeTemplate.innerHTML);\n  }\n\n  /**\n   * ScheduleNoticeHtmlElement Factory\n   *\n   * @return {ScheduleNoticeHtmlElement}\n   */\n  function scheduleNoticeHtmlElementFactory() {\n    var scheduleNoticeHtmlElement = document.querySelector(\'.mlp-attachment-schedule-notice\');\n    if (!scheduleNoticeHtmlElement) {\n      throw new TypeError(\'Impossible to retrieve the schedule notice html element. Element does not exists\');\n    }\n    scheduleNoticeHtmlElement = new ScheduleNoticeHtmlElement(scheduleNoticeHtmlElement);\n    return scheduleNoticeHtmlElement;\n  }\n\n  /**\n   * @return {HTMLFormElement}\n   */\n  function formHtmlElementFactory() {\n    // TODO May be a better selector to prevent to get wrong form\n    var formHtmlElement = document.querySelector(\'form\');\n    if (!formHtmlElement) {\n      throw new TypeError(\'No form exists in this page.\');\n    }\n    return formHtmlElement;\n  }\n\n  /**\n   * @return {*}\n   */\n  function translationsFactory() {\n    var hasTranslations = siteDuplicatorScheduleData.hasOwnProperty(\'attachmentDuplicatorTranslations\');\n    if (!hasTranslations) {\n      throw new Error(\'Translations for Site Duplication Schedule are missing\');\n    }\n    return siteDuplicatorScheduleData.attachmentDuplicatorTranslations;\n  }\n\n  /**\n   * @return {*}\n   */\n  function initializeContainer() {\n    var scheduleUrl = siteDuplicatorScheduleData.scheduleUrl,\n      _siteDuplicatorSchedu = siteDuplicatorScheduleData.ajaxUrl,\n      ajaxUrl = _siteDuplicatorSchedu === void 0 ? \'\' : _siteDuplicatorSchedu;\n    var domDocument = jQuery(document);\n\n    // TODO Create a lazy loader container because right know dependencies have to be\n    //      created before them are used and maintenance will be difficult.\n    if (!ajaxUrl) {\n      throw new TypeError(\'ajaxUrl must be set or schedule notice will not work\');\n    }\n    var translations = translationsFactory();\n    var form = new Form(formHtmlElementFactory(), translations, alert);\n    var eventDispatcher = new EventDispatcher(domDocument);\n    var spinner = new Spinner(POSITION_BEFORE_BEGIN, \'.spinner\', \'<span class="spinner is-active"></span>\');\n    var scheduleFactory = new ScheduleFactory();\n    var scheduleStatusFactory = new ScheduleStatusFactory(scheduleFactory);\n    var scheduleNoticeHtmlElement = scheduleNoticeHtmlElementFactory();\n    var scheduleStatusStorage = new ScheduleStatusStorage(scheduleNoticeHtmlElement, scheduleStatusFactory);\n    var scheduleNotice = new ScheduleNotice(jQuery, eventDispatcher, scheduleNoticeHtmlElement, scheduleStatusStorage);\n    var scheduleStatusResponseHandler = new ScheduleStatusResponseHandler(scheduleNotice, eventDispatcher, scheduleStatusFactory, form, translations);\n    var scheduleStatusUpdater = new ScheduleStatusUpdater(jQuery.ajax, scheduleStatusResponseHandler, form, domDocument, scheduleUrl);\n    var _siteDuplicatorSchedu2 = siteDuplicatorScheduleData.attachmentDuplicatorActions,\n      nonce = _siteDuplicatorSchedu2.nonce,\n      nonceAction = _siteDuplicatorSchedu2.nonceAction,\n      nameAjaxHook = _siteDuplicatorSchedu2.nameAjaxHook;\n    var stopAttachmentDuplicationProcessResponseHandler = new StopAttachmentDuplicationProcessResponseHandler(scheduleNotice, eventDispatcher);\n    var stopAttachmentDuplicationProcessClient = new StopAttachmentDuplicationProcessClient(jQuery.ajax, ajaxUrl, new Nonce(nonce, nonceAction), nameAjaxHook, stopAttachmentDuplicationProcessResponseHandler, spinner);\n    return {\n      domDocument: domDocument,\n      scheduleNotice: scheduleNotice,\n      scheduleStatusStorage: scheduleStatusStorage,\n      scheduleStatusFactory: scheduleStatusFactory,\n      scheduleStatusResponseHandler: scheduleStatusResponseHandler,\n      scheduleStatusUpdater: scheduleStatusUpdater,\n      eventDispatcher: eventDispatcher,\n      form: form,\n      translations: translations,\n      spinner: spinner,\n      ajaxUrl: ajaxUrl,\n      stopAttachmentDuplicationProcessClient: stopAttachmentDuplicationProcessClient\n    };\n  }\n\n  /**\n   * Bootstrap Schedule Actions\n   *\n   * @params {*} container\n   *\n   * @return void\n   */\n  function bootstrapScheduleActions(container) {\n    var stopAttachmentDuplicationProcessClient = container.stopAttachmentDuplicationProcessClient,\n      domDocument = container.domDocument,\n      form = container.form,\n      scheduleStatusUpdater = container.scheduleStatusUpdater,\n      scheduleStatusStorage = container.scheduleStatusStorage;\n    window.addEventListener(\'load\', function () {\n      return scheduleStatusUpdater.update();\n    }, {\n      once: true\n    });\n    var remover = document.querySelector(\'#mlp_kill_attachment_duplication\');\n    remover && remover.addEventListener(\'click\', function (event) {\n      return stopAttachmentDuplicationProcessClient.call(event.currentTarget || event.target, scheduleStatusStorage.status());\n    });\n    domDocument.on(ACTION_SCHEDULE_STATUS_UPDATE_ERROR, function () {\n      return form.releaseFormSubmission();\n    });\n    domDocument.on(ACTION_STOP_ATTACHMENT_DUPLICATION_SUCCEED, function (_ref) {\n      var _ref$success = _ref.success,\n        success = _ref$success === void 0 ? false : _ref$success;\n      if (!success) {\n        return;\n      }\n      form.releaseFormSubmission();\n      scheduleStatusUpdater.detachAjaxEvent();\n    });\n  }\n\n  /**\n   * Bootstrap the package\n   *\n   * @return void\n   */\n  function bootstrap(container) {\n    var scheduleNotice = container.scheduleNotice;\n    scheduleNotice.hide();\n    bootstrapScheduleActions(container);\n  }\n  if (adminpage !== \'site-new-php\') {\n    return;\n  }\n  if (!siteDuplicatorScheduleData) {\n    console.warn(\'No schedule data available, duplication notice will not work as expected.\');\n    return;\n  }\n  try {\n    initializeScheduleNoticeUI();\n    setTimeout(function () {\n      var container = initializeContainer();\n      bootstrap(container);\n    }, 1000);\n  } catch (error) {\n    console.warn(error.message);\n  }\n})(jQuery, adminpage, window.siteDuplicatorScheduleData);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///695\n')}},__webpack_exports__={};__webpack_modules__[695]()})();
//# sourceMappingURL=site-duplication-admin.min.js.map