<?php

declare(strict_types=1);

use Inpsyde\MultilingualPress\Framework\Service\Container;
use Inpsyde\MultilingualPress\MediaLibrary\Settings\MediaLibrarySetting;
use Inpsyde\MultilingualPress\MediaLibrary\Settings\RelatedSitesSetting;
use Inpsyde\MultilingualPress\MediaLibrary\ServiceProvider as MediaLibraryModule;
use Inpsyde\MultilingualPress\Core\ServiceProvider as CoreModule;

(static function (Container $container) {
    $container->share(
        RelatedSitesSetting::class,
        static function (Container $container): MediaLibrarySetting {
            $moduleId = MediaLibraryModule::MODULE_ID;
            return new RelatedSitesSetting(
                "multilingualpress-{$moduleId}-related-sites",
                __('Copy to connected site(s)', 'multilingualpress'),
                $container->get(CoreModule::PARAMETER_CONFIG_RELATED_SITES)
            );
        }
    );

    /**
     * Configuration for all media library screen settings.
     *
     * @returns MediaLibrarySetting[] The list of media library screen settings.
     */
    $container->share(
        MediaLibraryModule::PARAMETER_CONFIG_SETTINGS_ALL_SETTINGS,
        static function (Container $container): array {
            return [
                $container->get(RelatedSitesSetting::class),
            ];
        }
    );

    /**
     * Configuration for MLP settings title on media library screens.
     */
    $container->share(
        MediaLibraryModule::PARAMETER_CONFIG_SETTINGS_TITLE,
        static function (): string {
            return __('MultilingualPress Settings', 'multilingualpress');
        }
    );
}
)($container); //phpcs:disable VariableAnalysis.CodeAnalysis.VariableAnalysis.UndefinedVariable
