(function(){"use strict";var __webpack_modules__={267:function(){eval("\n;// CONCATENATED MODULE: ./build/src/modules/QuickLinks/resources/js/QuickLinks.js\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\n/**\n * Check if Given Url Is a Valid Url\n *\n * @param url\n * @returns {boolean}\n */\nfunction isValidUrl(url) {\n  var pattern = new RegExp('^(https?:\\\\/\\\\/)?' + // protocol\n  '((([a-z\\\\d]([a-z\\\\d-]*[a-z\\\\d])*)\\\\.)+[a-z]{2,}|' + // domain name\n  '((\\\\d{1,3}\\\\.){3}\\\\d{1,3}))' + // OR ip (v4) address\n  '(\\\\:\\\\d+)?(\\\\/[-a-z\\\\d%_.~+]*)*' + // port and path\n  '(\\\\?[;&a-z\\\\d%_.~+=-]*)?' + // query string\n  '(\\\\#[-a-z\\\\d_]*)?$', 'i'); // fragment locator\n\n  return !!pattern.test(url);\n}\n/**\n * Redirect user based on event\n *\n * @param evt\n */\n\n\nfunction redirect(evt) {\n  var value = evt.currentTarget.value;\n\n  if (!value) {\n    return;\n  }\n\n  if (!isValidUrl(value)) {\n    return;\n  }\n\n  evt.preventDefault();\n  evt.stopImmediatePropagation();\n  window.location.href = value;\n}\n/**\n * Quick Links\n *\n * @type {QuickLinks}\n */\n\n\nvar QuickLinks = /*#__PURE__*/function () {\n  function QuickLinks() {\n    _classCallCheck(this, QuickLinks);\n  }\n\n  _createClass(QuickLinks, null, [{\n    key: \"initialize\",\n    value:\n    /**\n     * Initialize Quick Links\n     */\n    function initialize() {\n      var element = document.querySelector('#mlp_quicklinks_redirect_selection');\n\n      if (!element) {\n        return;\n      }\n\n      var submit = document.querySelector('.mlp-quicklinks-form__submit');\n      submit && submit.parentNode.removeChild(submit);\n      element.addEventListener('change', redirect);\n    }\n  }]);\n\n  return QuickLinks;\n}();\n;// CONCATENATED MODULE: ./build/src/modules/QuickLinks/resources/js/frontend.js\n\nQuickLinks.initialize();//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///267\n")}},__webpack_exports__={};__webpack_modules__[267]()})();
//# sourceMappingURL=frontend.min.js.map