(function(){"use strict";var __webpack_modules__={259:function(){eval("\n;// CONCATENATED MODULE: ./build/src/modules/ExternalSites/resources/js/ExternalSites.js\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\nvar LANGUAGE_ID_REGEXP = /-(\\d+)-/i;\nvar LANGUAGE_NAME_REGEXP = /\\[(\\d+)\\]/i;\nvar NEGATIVE_LANGUAGE_NAME_REGEXP = /\\[-(\\d+)\\]/i;\n/**\n * Create the New Language button element\n *\n * @returns {HTMLElement}\n */\n\nfunction createNewExternalSiteButton($table, externalSitesStrings) {\n  var button = jQuery(\"<p class=\\\"mlp-external-site\\\">\\n            <button class=\\\"button\\\">\\n                \".concat(externalSitesStrings.newExternalSiteButtonLabel, \"\\n            </button>\\n        </p>\"));\n  button.insertAfter($table);\n  return button;\n}\n/**\n * Create a language delete action button.\n *\n * @param {HTMLElement} $table\n * @returns {HTMLElement}\n */\n\n\nfunction createExternalSiteDeleter($table, externalSitesStrings) {\n  var $deletor = jQuery(\"<td data-label=\\\"Deletor\\\">\\n            <button class=\\\"mlp-external-site-deletor button dashicons dashicons-trash\\\" data-action=\\\"delete\\\">\\n                <span class=\\\"screen-reader-text\\\">\\n                    \".concat(externalSitesStrings.externalSiteDeleteButtonLabel, \"\\n                </span>\\n            </button>\\n        </td>\"));\n  var $deletorHead = jQuery(\"<th scope=\\\"col\\\" data-label=\\\"Deletor\\\">\\n            \".concat(externalSitesStrings.externalSiteDeleteTableHeadLabel, \"\\n        </th>\"));\n  $table.find('thead > tr th:last-of-type').after($deletorHead.clone());\n  $table.find('tfoot > tr th:last-of-type').after($deletorHead.clone());\n  $table.find('tbody > tr td:last-of-type').after($deletor);\n  return jQuery('.mlp-external-site-deletor');\n}\n/**\n * Clone the table row so it's possible to add more than one language at a time.\n *\n * @returns {HTMLElement}\n */\n\n\nfunction cloneTableRow($tableRow) {\n  var $clone = $tableRow.clone(false);\n  $clone.hide().insertAfter($tableRow);\n  $clone.find('input').each(function (index, input) {\n    jQuery(input).val('');\n    jQuery(input).removeAttr('checked');\n  });\n  return $clone;\n}\n/**\n * Hide Element\n *\n * @returns void\n */\n\n\nfunction hideElement(element) {\n  element = jQuery(element);\n  element.length && element.hide();\n}\n/**\n * Show Element\n *\n * @returns void\n */\n\n\nfunction showElement(element) {\n  element = jQuery(element);\n  element.length && element.show();\n}\n/**\n * Get the next language id to create the new language item.\n *\n * @returns {number}\n */\n\n\nfunction nextExternalSiteId($tableRow) {\n  var invalidId = -1;\n  var input = $tableRow.find('input');\n\n  if (!input) {\n    return invalidId;\n  }\n\n  var regexp = new RegExp(LANGUAGE_NAME_REGEXP).exec(input[0].getAttribute('name'));\n  return Array.isArray(regexp) ? ++regexp[1] : invalidId;\n}\n/**\n * Increment the language number for inputs\n *\n * Usually done after a table row has been cloned\n *\n * @param $inputs\n * @param number\n */\n\n\nfunction incrementExternalSiteId($inputs, number) {\n  $inputs.each(function (index, input) {\n    var nameAttribute = input.getAttribute('name');\n    var idAttribute = input.getAttribute('id');\n    input.setAttribute('name', nameAttribute.replace(LANGUAGE_NAME_REGEXP, '[' + number + ']'));\n    input.setAttribute('id', idAttribute.replace(LANGUAGE_ID_REGEXP, '-' + number + '-'));\n  });\n}\n/**\n * Negative numbers means the language will be deleted from the database, positive numbers\n * means language will be updated or created.\n *\n * @param $inputs\n * @param positive\n */\n\n\nfunction changeSignToExternalSiteId($inputs, positive) {\n  $inputs.each(function (index, input) {\n    var nameAttribute = input.getAttribute('name');\n    input.setAttribute('name', nameAttribute.replace(positive ? NEGATIVE_LANGUAGE_NAME_REGEXP : LANGUAGE_NAME_REGEXP, positive ? '[$1]' : '[-$1]'));\n  });\n}\n/**\n * Add new language row\n *\n * @returns void\n */\n\n\nfunction addExternalSite($tableRow) {\n  showElement($tableRow);\n  var nextId = nextExternalSiteId($tableRow);\n\n  if (-1 === nextId) {\n    return;\n  }\n\n  var $clone = cloneTableRow($tableRow);\n  incrementExternalSiteId($clone.find('input'), nextId);\n}\n/**\n * Undo Delete Language\n *\n * @param $deleter\n * @param languageManagerStrings\n */\n\n\nfunction undoDeleteExternalSite($deleter, externalSitesStrings) {\n  $deleter = jQuery($deleter);\n\n  if (!$deleter.length) {\n    return;\n  }\n\n  var $row = $deleter.parents('tr');\n\n  if (!$row.length) {\n    return;\n  }\n\n  var $undo = $deleter.attr('data-action') === 'undo';\n  var callback = $undo ? function (index, input) {\n    jQuery(input).removeAttr('readonly').css('opacity', 1);\n  } : function (index, input) {\n    jQuery(input).attr('readonly', 'readonly').css('opacity', .2);\n  };\n  var label = $undo ? externalSitesStrings.externalSiteDeleteButtonLabel : externalSitesStrings.externalSiteUndoDeleteButtonLabel;\n  var $inputs = $row.find('input');\n  $inputs.each(callback);\n  $deleter.attr('data-action', $undo ? 'delete' : 'undo').find('span').text(label);\n  $row.find('button').toggleClass('dashicons-undo dashicons-trash');\n  changeSignToExternalSiteId($inputs, $undo);\n}\n/**\n * Retrieve latest table Row\n *\n * @param $table\n * @returns {*}\n */\n\n\nfunction latestTableRow($table) {\n  return $table.find('tbody tr:last-of-type');\n}\n/**\n * External Sites\n */\n\n\nvar ExternalSites = /*#__PURE__*/function () {\n  function ExternalSites(externalSitesStrings) {\n    _classCallCheck(this, ExternalSites);\n\n    this.externalSitesStrings = externalSitesStrings;\n    this.didInit = false;\n  }\n  /**\n   * Initialize\n   *\n   * @returns void\n   */\n\n\n  _createClass(ExternalSites, [{\n    key: \"init\",\n    value: function init() {\n      var _this = this;\n\n      if (this.didInit) {\n        return;\n      }\n\n      var $table = jQuery('#mlp-external-sites-table');\n\n      if (!$table) {\n        return;\n      }\n\n      hideElement(latestTableRow($table));\n      var $deleter = createExternalSiteDeleter($table, this.externalSitesStrings);\n      $deleter.on('click', function (evt) {\n        evt.preventDefault();\n        evt.stopPropagation();\n        undoDeleteExternalSite(evt.currentTarget, _this.externalSitesStrings);\n      });\n      var $button = createNewExternalSiteButton($table, this.externalSitesStrings);\n      $button.click(function (evt) {\n        evt.preventDefault();\n        evt.stopPropagation();\n        var $latestTableRow = latestTableRow($table);\n        addExternalSite($latestTableRow);\n      });\n      this.didInit = true;\n    }\n  }]);\n\n  return ExternalSites;\n}();\n;// CONCATENATED MODULE: ./build/src/modules/ExternalSites/resources/js/NavMenu.js\nvar ExternalSitesNavMenu = function ExternalSitesNavMenu($, $submitButton, $menuToEdit, $menuInput) {\n  var init = false;\n  var $externalSiteInputs;\n  var $selectAll;\n  var $spinner;\n  /**\n   * Shows or hide the spinner.\n   *\n   * @param {bool} enable\n   */\n\n  var spinner = function spinner(enable) {\n    $spinner.css('visibility', enable ? 'visible' : 'hidden');\n  };\n  /**\n   * The currently selected external sites.\n   *\n   * @return {number[]}\n   */\n\n\n  var externalSiteIds = function externalSiteIds() {\n    var externalSiteIds = [];\n    $externalSiteInputs.filter(':checked').each(function () {\n      externalSiteIds.push(Number($(this).val() || 0));\n    });\n    return externalSiteIds;\n  };\n  /**\n   * Enable or disable the sumbit button based on external sites being selected.\n   */\n\n\n  var updateSumbit = function updateSumbit() {\n    $submitButton.prop('disabled', !($menuToEdit.length && externalSiteIds().length));\n  };\n  /**\n   * Executes on AJAX error.\n   */\n\n\n  var onAjaxError = function onAjaxError() {\n    alert('AJAX error.');\n  };\n  /**\n   * Executes on AJAX success and append the menu markup received via AJAX, which is passed as parameter,\n   * to the current menu.\n   *\n   * @param {jQuery} $menu\n   */\n\n\n  var onAjaxSuccess = function onAjaxSuccess($menu) {\n    if (!$menu.length) {\n      onAjaxError();\n      return;\n    }\n\n    $menuToEdit.append($menu);\n  };\n  /**\n   * @param {number[]} ids\n   * @return {{action, mlp_external_sites: *, menu: *}}\n   */\n\n\n  var ajaxData = function ajaxData(ids) {\n    var nonceAction = $submitButton.data('nonce-action');\n    var nonceValue = $submitButton.data('nonce');\n    var ajaxAction = $submitButton.data('action');\n    var data = {\n      action: ajaxAction,\n      mlp_external_sites: ids,\n      menu: $menuInput.val()\n    };\n    data[nonceAction] = nonceValue;\n    return data;\n  };\n  /**\n   * Send the AJAX request to update the menu for the given external site IDs.\n   *\n   * @param {number[]} ids\n   */\n\n\n  var sendRequest = function sendRequest(ids) {\n    spinner(true);\n    $submitButton.prop('disabled', true);\n    $externalSiteInputs.prop('disabled', true);\n    $.ajax({\n      url: ajaxurl,\n      method: 'POST',\n      dataType: 'json',\n      data: ajaxData(ids)\n    }).done(function (response) {\n      if (response.success && response.data && typeof response.data === 'string') {\n        onAjaxSuccess($(response.data));\n        return;\n      }\n\n      onAjaxError();\n    }).fail(function () {\n      onAjaxError();\n    }).always(function () {\n      spinner(false);\n      $externalSiteInputs.prop('checked', false);\n      $externalSiteInputs.prop('disabled', false);\n      $submitButton.prop('disabled', true);\n    });\n  };\n  /**\n   * Init the class by setting events callbacks on the jQuery element.\n   *\n   */\n\n\n  this.init = function () {\n    if (!init) {\n      $externalSiteInputs = $($submitButton.data('external-sites'));\n      $selectAll = $($submitButton.data('select-all'));\n      $spinner = $submitButton.siblings('.spinner');\n      $externalSiteInputs.click(function () {\n        updateSumbit();\n      });\n      $selectAll.click(function (e) {\n        e.preventDefault();\n        $externalSiteInputs.prop('checked', true);\n        updateSumbit();\n      });\n      $submitButton.click(function () {\n        var ids = externalSiteIds();\n\n        if (ids && $menuToEdit.length) {\n          sendRequest(ids);\n        }\n      });\n      updateSumbit();\n      init = true;\n    }\n\n    return this;\n  };\n};\n;// CONCATENATED MODULE: ./build/src/modules/ExternalSites/resources/js/admin.js\n\n\n'use strict';\n\n(function ($, M, adminpage, externalSitesStrings) {\n  if (adminpage === 'multilingualpress_page_external-sites') {\n    var _externalSites = new ExternalSites(externalSitesStrings);\n\n    _externalSites.init();\n  }\n\n  if (adminpage === 'nav-menus-php') {\n    var navMenu = new ExternalSitesNavMenu($, $('#mlp-navMenu-external-sites-submit'), $('#menu-to-edit'), $('#menu'));\n    navMenu.init();\n  }\n\n  var redirectFallbackSelect = document.querySelector('#multilingualpress_module_redirect_settings_fallback_site_id');\n  var redirectFallbackExternalSiteSelect = document.querySelector('#multilingualpress_module_redirect_settings_fallback_external_site_id');\n  var redirectFallbackSelectExists = redirectFallbackSelect !== null;\n  var redirectFallbackExternalSiteSelectExists = redirectFallbackExternalSiteSelect !== null;\n\n  if (redirectFallbackSelectExists && redirectFallbackExternalSiteSelectExists) {\n    redirectFallbackSelect.addEventListener('change', function () {\n      redirectFallbackExternalSiteSelect.disabled = false;\n\n      if (this.value !== '0') {\n        redirectFallbackExternalSiteSelect.value = '0';\n        redirectFallbackExternalSiteSelect.disabled = true;\n      }\n    });\n    redirectFallbackSelect.dispatchEvent(new Event('change'));\n  }\n})(jQuery, MultilingualPress, adminpage, externalSites);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///259\n")}},__webpack_exports__={};__webpack_modules__[259]()})();
//# sourceMappingURL=admin.min.js.map