(function(){"use strict";var __webpack_modules__={485:function(){eval("\n;// CONCATENATED MODULE: ./build/src/modules/LanguageManager/resources/js/LanguageManager.js\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, \"prototype\", { writable: false }); return Constructor; }\n\nvar LANGUAGE_ID_REGEXP = /-(\\d+)-/i;\nvar LANGUAGE_NAME_REGEXP = /\\[(\\d+)\\]/i;\nvar NEGATIVE_LANGUAGE_NAME_REGEXP = /\\[-(\\d+)\\]/i;\n/**\n * Create the New Language button element\n *\n * @returns {HTMLElement}\n */\n\nfunction createNewLanguageButton($table, languageManagerStrings) {\n  var button = jQuery(\"<p class=\\\"mlp-new-language\\\">\\n            <button class=\\\"button\\\">\\n                \".concat(languageManagerStrings.newLanguageButtonLabel, \"\\n            </button>\\n        </p>\"));\n  button.insertAfter($table);\n  return button;\n}\n/**\n * Create a language delete action button.\n *\n * @param {HTMLElement} $table\n * @returns {HTMLElement}\n */\n\n\nfunction createLanguageDeleter($table, languageManagerStrings) {\n  var $deletor = jQuery(\"<td data-label=\\\"Deletor\\\">\\n            <button class=\\\"mlp-language-deletor button dashicons dashicons-trash\\\" data-action=\\\"delete\\\">\\n                <span class=\\\"screen-reader-text\\\">\\n                    \".concat(languageManagerStrings.languageDeleteButtonLabel, \"\\n                </span>\\n            </button>\\n        </td>\"));\n  var $deletorHead = jQuery(\"<th scope=\\\"col\\\" data-label=\\\"Deletor\\\">\\n            \".concat(languageManagerStrings.languageDeleteTableHeadLabel, \"\\n        </th>\"));\n  $table.find('thead > tr th:last-of-type').after($deletorHead.clone());\n  $table.find('tfoot > tr th:last-of-type').after($deletorHead.clone());\n  $table.find('tbody > tr td:last-of-type').after($deletor);\n  return jQuery('.mlp-language-deletor');\n}\n/**\n * Clone the table row so it's possible to add more than one language at a time.\n *\n * @returns {HTMLElement}\n */\n\n\nfunction cloneTableRow($tableRow) {\n  var $clone = $tableRow.clone(false);\n  $clone.hide().insertAfter($tableRow);\n  $clone.find('input').each(function (index, input) {\n    jQuery(input).val('');\n    jQuery(input).removeAttr('checked');\n  });\n  return $clone;\n}\n/**\n * Hide Element\n *\n * @returns void\n */\n\n\nfunction hideElement(element) {\n  element = jQuery(element);\n  element.length && element.hide();\n}\n/**\n * Show Element\n *\n * @returns void\n */\n\n\nfunction showElement(element) {\n  element = jQuery(element);\n  element.length && element.show();\n}\n/**\n * Get the next language id to create the new language item.\n *\n * @returns {number}\n */\n\n\nfunction nextLanguageId($tableRow) {\n  var invalidId = -1;\n  var input = $tableRow.find('input');\n\n  if (!input) {\n    return invalidId;\n  }\n\n  var regexp = new RegExp(LANGUAGE_NAME_REGEXP).exec(input[0].getAttribute('name'));\n  return Array.isArray(regexp) ? ++regexp[1] : invalidId;\n}\n/**\n * Increment the language number for inputs\n *\n * Usually done after a table row has been cloned\n *\n * @param $inputs\n * @param number\n */\n\n\nfunction incrementLanguageId($inputs, number) {\n  $inputs.each(function (index, input) {\n    var nameAttribute = input.getAttribute('name');\n    var idAttribute = input.getAttribute('id');\n    input.setAttribute('name', nameAttribute.replace(LANGUAGE_NAME_REGEXP, '[' + number + ']'));\n    input.setAttribute('id', idAttribute.replace(LANGUAGE_ID_REGEXP, '-' + number + '-'));\n  });\n}\n/**\n * Negative numbers means the language will be deleted from the database, positive numbers\n * means language will be updated or created.\n *\n * @param $inputs\n * @param positive\n */\n\n\nfunction changeSignToLanguageId($inputs, positive) {\n  $inputs.each(function (index, input) {\n    var nameAttribute = input.getAttribute('name');\n    input.setAttribute('name', nameAttribute.replace(positive ? NEGATIVE_LANGUAGE_NAME_REGEXP : LANGUAGE_NAME_REGEXP, positive ? '[$1]' : '[-$1]'));\n  });\n}\n/**\n * Add new language row\n *\n * @returns void\n */\n\n\nfunction addLanguage($tableRow) {\n  showElement($tableRow);\n  var nextId = nextLanguageId($tableRow);\n\n  if (-1 === nextId) {\n    return;\n  }\n\n  var $clone = cloneTableRow($tableRow);\n  incrementLanguageId($clone.find('input'), nextId);\n}\n/**\n * Undo Delete Language\n *\n * @param $deleter\n * @param languageManagerStrings\n */\n\n\nfunction undoDeleteLanguage($deleter, languageManagerStrings) {\n  $deleter = jQuery($deleter);\n\n  if (!$deleter.length) {\n    return;\n  }\n\n  var $row = $deleter.parents('tr');\n\n  if (!$row.length) {\n    return;\n  }\n\n  var $undo = $deleter.attr('data-action') === 'undo';\n  var callback = $undo ? function (index, input) {\n    jQuery(input).removeAttr('readonly').css('opacity', 1);\n  } : function (index, input) {\n    jQuery(input).attr('readonly', 'readonly').css('opacity', .2);\n  };\n  var label = $undo ? languageManagerStrings.languageDeleteButtonLabel : languageManagerStrings.languageUndoDeleteButtonLabel;\n  var $inputs = $row.find('input');\n  $inputs.each(callback);\n  $deleter.attr('data-action', $undo ? 'delete' : 'undo').find('span').text(label);\n  $row.find('button').toggleClass('dashicons-undo dashicons-trash');\n  changeSignToLanguageId($inputs, $undo);\n}\n/**\n * Initialize auto complete for the given input element\n *\n * @returns void\n */\n\n\nfunction setupAutocomplete($input) {\n  $input.on('autocompleteselect', function (evt, ui) {\n    var item = 'item' in ui && ui.item;\n    var language = 'language' in item && item.language;\n    var $input = jQuery(evt.currentTarget);\n\n    if (!language) {\n      return;\n    } // Let LanguageSearch do his stuffs before.\n\n\n    setTimeout(function () {\n      fillNewLanguageField($input.parents('tr'), language);\n    }, 0);\n  });\n}\n/**\n * Add the value for a language to inputs within a table row\n *\n * @param $container\n * @param language\n */\n\n\nfunction fillNewLanguageField($container, language) {\n  $container.find('.native-name').val(language.nativeName);\n  $container.find('.english-name').val(language.englishName);\n  $container.find('.iso-639-1').val(language.iso639Code1);\n  $container.find('.iso-639-2').val(language.iso639Code2);\n  $container.find('.iso-639-3').val(language.iso639Code3);\n  $container.find('.iso-639-3').val(language.iso639Code3);\n  $container.find('.locale').val(language.locale);\n  $container.find('.http-code').val(language.httpCode);\n  language.isRtl ? $container.find('.is-rtl').attr('checked', 'checked') : $container.find('.is-rtl').removeAttr('checked');\n}\n/**\n * Retrieve latest table Row\n *\n * @param $table\n * @returns {*}\n */\n\n\nfunction latestTableRow($table) {\n  return $table.find('tbody tr:last-of-type');\n}\n/**\n * Language Manager\n */\n\n\nvar LanguageManager = /*#__PURE__*/function () {\n  /**\n   * LanguageManager Constructor\n   */\n  function LanguageManager(languageManagerStrings, LanguageSearch) {\n    _classCallCheck(this, LanguageManager);\n\n    this.languageManagerStrings = languageManagerStrings;\n    this.didInit = false;\n    this.LanguageSearch = LanguageSearch;\n  }\n  /**\n   * Initialize\n   *\n   * @returns void\n   */\n\n\n  _createClass(LanguageManager, [{\n    key: \"init\",\n    value: function init() {\n      var _this = this;\n\n      if (this.didInit) {\n        return;\n      }\n\n      var $table = jQuery('#mlp-language-manager-table');\n\n      if (!$table) {\n        return;\n      }\n\n      hideElement(latestTableRow($table));\n      var $deleter = createLanguageDeleter($table, this.languageManagerStrings);\n      $deleter.on('click', function (evt) {\n        evt.preventDefault();\n        evt.stopPropagation();\n        undoDeleteLanguage(evt.currentTarget, _this.languageManagerStrings);\n      });\n      var $button = createNewLanguageButton($table, this.languageManagerStrings);\n      $button.click(function (evt) {\n        evt.preventDefault();\n        evt.stopPropagation();\n        var $latestTableRow = latestTableRow($table);\n        var $autocompleteInput = $latestTableRow.find('.native-name');\n        var languageSearch = new _this.LanguageSearch($autocompleteInput);\n        addLanguage($latestTableRow);\n        languageSearch.init();\n        setupAutocomplete($autocompleteInput);\n      });\n      this.didInit = true;\n    }\n  }]);\n\n  return LanguageManager;\n}();\n;// CONCATENATED MODULE: ./build/src/modules/LanguageManager/resources/js/admin.js\n\n'use strict';\n\n(function (M, adminpage, languageManagerStrings) {\n  if (adminpage !== 'multilingualpress_page_language-manager') {\n    return;\n  }\n\n  var languageManager = new LanguageManager(languageManagerStrings, M.LanguageSearch);\n  languageManager.init();\n})(MultilingualPress, adminpage, languageManager);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///485\n")}},__webpack_exports__={};__webpack_modules__[485]()})();
//# sourceMappingURL=admin.min.js.map