!function(g){var I={};function Q(F){if(I[F])return I[F].exports;var n=I[F]={i:F,l:!1,exports:{}};return g[F].call(n.exports,n,n.exports,Q),n.l=!0,n.exports}Q.m=g,Q.c=I,Q.d=function(g,I,F){Q.o(g,I)||Object.defineProperty(g,I,{enumerable:!0,get:F})},Q.r=function(g){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(g,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(g,"__esModule",{value:!0})},Q.t=function(g,I){if(1&I&&(g=Q(g)),8&I)return g;if(4&I&&"object"==typeof g&&g&&g.__esModule)return g;var F=Object.create(null);if(Q.r(F),Object.defineProperty(F,"default",{enumerable:!0,value:g}),2&I&&"string"!=typeof g)for(var n in g)Q.d(F,n,function(I){return g[I]}.bind(null,n));return F},Q.n=function(g){var I=g&&g.__esModule?function(){return g.default}:function(){return g};return Q.d(I,"a",I),I},Q.o=function(g,I){return Object.prototype.hasOwnProperty.call(g,I)},Q.p="",Q(Q.s=0)}([function(module,__webpack_exports__,__webpack_require__){"use strict";eval("// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// CONCATENATED MODULE: ./build/src/modules/Redirect/resources/js/Redirector.js\n/**\n * The MultilingualPress Redirector module.\n */\nfunction Redirector(languagesStorageKey, timestampStorageKey, redirectSettings, jQuery, navigator, localStorage) {\n  var settings;\n  var allUserLanguages;\n  var noredirect;\n  var contentLanguage;\n  var noRedirectRegex;\n  var init = false;\n  /**\n   * Checks if the stored timestamp is valid.\n   *\n   * @return {Boolean} Whether or not the stored timestamp is valid.\n   */\n\n  var checkTimestamp = function checkTimestamp() {\n    var timestamp = Number(localStorage.getItem(timestampStorageKey));\n    return Date.now() <= timestamp + Number(settings.storageLifetime);\n  };\n  /**\n   * Starts the continuously running timestamp update used to determine the age of stored languages.\n   */\n\n\n  var startTimestampUpdate = function startTimestampUpdate() {\n    var timeout = Number(settings.updateTimestampInterval);\n    var updateTimestamp;\n\n    if (timeout > 0) {\n      updateTimestamp = function updateTimestamp() {\n        localStorage.setItem(timestampStorageKey, Date.now());\n      };\n\n      updateTimestamp();\n      setInterval(updateTimestamp, timeout);\n    }\n  };\n  /**\n   * Returns the given language in the normalized, locale-like form.\n   *\n   * @param {String} language\n   * @return {String}\n   */\n\n\n  var normalizeLanguage = function normalizeLanguage(language) {\n    return language.replace(/-/, '_');\n  };\n  /**\n   * Returns the regionless languages of the user that have not been defined before.\n   *\n   * @returns {String[]} The regionless languages of the user not defined before.\n   */\n\n\n  var userLanguages = function userLanguages() {\n    var browserLanguages;\n\n    if (jQuery.isArray(allUserLanguages)) {\n      return allUserLanguages;\n    }\n\n    browserLanguages = navigator.languages || [navigator.language] || [navigator.browserLanguage] || [];\n    allUserLanguages = browserLanguages.map(function (language) {\n      return language;\n    });\n    return allUserLanguages.filter(function (language) {\n      return language;\n    });\n  };\n  /**\n   * Returns the stored languages.\n   *\n   * @returns {String[]}\n   */\n\n\n  var storedLanguages = function storedLanguages() {\n    var languages;\n\n    if (!checkTimestamp()) {\n      localStorage.removeItem(languagesStorageKey);\n      return [];\n    }\n\n    languages = localStorage.getItem(languagesStorageKey);\n    return languages ? languages.split(' ') : [];\n  };\n  /**\n   * Checks if the current site language is stored to not get redirected from.\n   *\n   * @returns {Boolean}\n   */\n\n\n  var isCurrentLanguageStored = function isCurrentLanguageStored() {\n    return storedLanguages().includes(normalizeLanguage(settings.currentLanguage));\n  };\n  /**\n   * Stores the given language.\n   *\n   * @param {String} language\n   */\n\n\n  var storeLanguage = function storeLanguage(language) {\n    var languages = storedLanguages();\n    var normalizedLanguage = normalizeLanguage(language);\n\n    if (languages.includes(normalizedLanguage)) {\n      return;\n    }\n\n    languages.push(normalizedLanguage);\n    localStorage.setItem(languagesStorageKey, languages.join(' '));\n  };\n  /**\n   * Returns the noredirect language included in the request, if any.\n   *\n   * @returns {String} Language.\n   */\n\n\n  var noredirectLanguage = function noredirectLanguage() {\n    var matches;\n\n    if (typeof noredirect === 'string') {\n      return noredirect;\n    }\n\n    noredirect = '';\n    matches = noRedirectRegex.exec(window.location.href);\n\n    if (Array.isArray(matches) && matches[2]) {\n      noredirect = decodeURIComponent(matches[2].replace(/\\+/g, ' '));\n    }\n\n    return noredirect;\n  };\n  /**\n   * Returns the best-matching content language for the given user language.\n   *\n   * @param {String} userLanguage\n   * @return {String}\n   */\n\n\n  var matchLanguage = function matchLanguage(userLanguage) {\n    var matched = '';\n\n    if (settings.urls[userLanguage]) {\n      return userLanguage;\n    }\n\n    if (userLanguage.indexOf('-') === -1) {\n      jQuery.each(settings.urls, function (langName) {\n        if (langName.indexOf(userLanguage + '-') === 0) {\n          matched = langName;\n          return false;\n        }\n\n        if (matched === '' && settings.RedirectFallbackSiteLanguageTag && langName === settings.RedirectFallbackSiteLanguageTag) {\n          matched = langName;\n        }\n\n        return true;\n      });\n    }\n\n    return matched;\n  };\n  /**\n   * Returns the best-matching content language, if any.\n   *\n   * @return {String} The best-matching content language.\n   */\n\n\n  var findContentLanguage = function findContentLanguage() {\n    if (typeof contentLanguage === 'string') {\n      return contentLanguage;\n    }\n\n    contentLanguage = '';\n    jQuery.each(userLanguages(), function (i, val) {\n      var matched = matchLanguage(val);\n\n      if (matched) {\n        contentLanguage = matched;\n        return false;\n      }\n\n      return true;\n    });\n    return contentLanguage;\n  };\n  /**\n   * Redirects to the URL according to the given language.\n   *\n   * @param {String} language\n   */\n\n\n  var doRedirect = function doRedirect(language) {\n    var url;\n    storeLanguage(language);\n\n    if (language === settings.currentLanguage) {\n      return;\n    }\n\n    url = settings.urls[language].replace(/\\?.*$/, '');\n    window.location.href = url + '?' + settings.noredirectKey + '=' + normalizeLanguage(language);\n  };\n  /**\n   * Inizialize the class if necessary.\n   */\n\n\n  var initialize = function initialize() {\n    if (!init) {\n      settings = redirectSettings || {\n        currentLanguage: '',\n        noredirectKey: '',\n        storageLifetime: 300000,\n        updateTimestampInterval: 60000,\n        urls: {},\n        RedirectFallbackSiteLanguageTag: ''\n      };\n      startTimestampUpdate();\n      noRedirectRegex = new RegExp('[?&]' + settings.noredirectKey + '(=([^&#]*)|&|#|$)');\n      init = true;\n    }\n  };\n  /**\n   * Perform the redirect if needed.\n   */\n\n\n  this.redirect = function () {\n    initialize();\n\n    if (!settings.noredirectKey || !settings.urls || isCurrentLanguageStored() || !userLanguages()) {\n      return;\n    }\n\n    if (noredirectLanguage()) {\n      storeLanguage(noredirectLanguage());\n      return;\n    }\n\n    if (findContentLanguage()) {\n      doRedirect(findContentLanguage());\n    }\n  };\n}\n// CONCATENATED MODULE: ./build/src/modules/Redirect/resources/js/frontend.js\n\n\n(function (jQuery, redirectSettings, navigator, localStorage) {\n  window.addEventListener('load', function () {\n    var redirector = new Redirector('mlpNoredirectStorage', 'mlpNoredirectStorageTimestamp', redirectSettings, jQuery, navigator, localStorage);\n    redirector.redirect();\n  });\n})(jQuery, MultilingualPressRedirectorSettings, navigator, localStorage);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///0\n")}]);
//# sourceMappingURL=frontend.min.js.map