!function(Q){var F={};function n(B){if(F[B])return F[B].exports;var U=F[B]={i:B,l:!1,exports:{}};return Q[B].call(U.exports,U,U.exports,n),U.l=!0,U.exports}n.m=Q,n.c=F,n.d=function(Q,F,B){n.o(Q,F)||Object.defineProperty(Q,F,{enumerable:!0,get:B})},n.r=function(Q){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(Q,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(Q,"__esModule",{value:!0})},n.t=function(Q,F){if(1&F&&(Q=n(Q)),8&F)return Q;if(4&F&&"object"==typeof Q&&Q&&Q.__esModule)return Q;var B=Object.create(null);if(n.r(B),Object.defineProperty(B,"default",{enumerable:!0,value:Q}),2&F&&"string"!=typeof Q)for(var U in Q)n.d(B,U,function(F){return Q[F]}.bind(null,U));return B},n.n=function(Q){var F=Q&&Q.__esModule?function(){return Q.default}:function(){return Q};return n.d(F,"a",F),F},n.o=function(Q,F){return Object.prototype.hasOwnProperty.call(Q,F)},n.p="",n(n.s=0)}([function(module,__webpack_exports__,__webpack_require__){"use strict";eval("// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// CONCATENATED MODULE: ./build/src/modules/LanguageManager/resources/js/LanguageManager.js\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nvar LANGUAGE_ID_REGEXP = /-(\\d+)-/i;\nvar LANGUAGE_NAME_REGEXP = /\\[(\\d+)\\]/i;\nvar NEGATIVE_LANGUAGE_NAME_REGEXP = /\\[-(\\d+)\\]/i;\n/**\n * Create the New Language button element\n *\n * @returns {HTMLElement}\n */\n\nfunction createNewLanguageButton($table, languageManagerStrings) {\n  var button = jQuery(\"<p class=\\\"mlp-new-language\\\">\\n            <button class=\\\"button\\\">\\n                \".concat(languageManagerStrings.newLanguageButtonLabel, \"\\n            </button>\\n        </p>\"));\n  button.insertAfter($table);\n  return button;\n}\n/**\n * Create a language delete action button.\n *\n * @param {HTMLElement} $table\n * @returns {HTMLElement}\n */\n\n\nfunction createLanguageDeleter($table, languageManagerStrings) {\n  var $deletor = jQuery(\"<td data-label=\\\"Deletor\\\">\\n            <button class=\\\"mlp-language-deletor button dashicons dashicons-trash\\\" data-action=\\\"delete\\\">\\n                <span class=\\\"screen-reader-text\\\">\\n                    \".concat(languageManagerStrings.languageDeleteButtonLabel, \"\\n                </span>\\n            </button>\\n        </td>\"));\n  var $deletorHead = jQuery(\"<th scope=\\\"col\\\" data-label=\\\"Deletor\\\">\\n            \".concat(languageManagerStrings.languageDeleteTableHeadLabel, \"\\n        </th>\"));\n  $table.find('thead > tr th:last-of-type').after($deletorHead.clone());\n  $table.find('tfoot > tr th:last-of-type').after($deletorHead.clone());\n  $table.find('tbody > tr td:last-of-type').after($deletor);\n  return jQuery('.mlp-language-deletor');\n}\n/**\n * Clone the table row so it's possible to add more than one language at a time.\n *\n * @returns {HTMLElement}\n */\n\n\nfunction cloneTableRow($tableRow) {\n  var $clone = $tableRow.clone(false);\n  $clone.hide().insertAfter($tableRow);\n  $clone.find('input').each(function (index, input) {\n    jQuery(input).val('');\n    jQuery(input).removeAttr('checked');\n  });\n  return $clone;\n}\n/**\n * Hide Element\n *\n * @returns void\n */\n\n\nfunction hideElement(element) {\n  element = jQuery(element);\n  element.length && element.hide();\n}\n/**\n * Show Element\n *\n * @returns void\n */\n\n\nfunction showElement(element) {\n  element = jQuery(element);\n  element.length && element.show();\n}\n/**\n * Get the next language id to create the new language item.\n *\n * @returns {number}\n */\n\n\nfunction nextLanguageId($tableRow) {\n  var invalidId = -1;\n  var input = $tableRow.find('input');\n\n  if (!input) {\n    return invalidId;\n  }\n\n  var regexp = new RegExp(LANGUAGE_NAME_REGEXP).exec(input[0].getAttribute('name'));\n  return Array.isArray(regexp) ? ++regexp[1] : invalidId;\n}\n/**\n * Increment the language number for inputs\n *\n * Usually done after a table row has been cloned\n *\n * @param $inputs\n * @param number\n */\n\n\nfunction incrementLanguageId($inputs, number) {\n  $inputs.each(function (index, input) {\n    var nameAttribute = input.getAttribute('name');\n    var idAttribute = input.getAttribute('id');\n    input.setAttribute('name', nameAttribute.replace(LANGUAGE_NAME_REGEXP, '[' + number + ']'));\n    input.setAttribute('id', idAttribute.replace(LANGUAGE_ID_REGEXP, '-' + number + '-'));\n  });\n}\n/**\n * Negative numbers means the language will be deleted from the database, positive numbers\n * means language will be updated or created.\n *\n * @param $inputs\n * @param positive\n */\n\n\nfunction changeSignToLanguageId($inputs, positive) {\n  $inputs.each(function (index, input) {\n    var nameAttribute = input.getAttribute('name');\n    input.setAttribute('name', nameAttribute.replace(positive ? NEGATIVE_LANGUAGE_NAME_REGEXP : LANGUAGE_NAME_REGEXP, positive ? '[$1]' : '[-$1]'));\n  });\n}\n/**\n * Add new language row\n *\n * @returns void\n */\n\n\nfunction addLanguage($tableRow) {\n  showElement($tableRow);\n  var nextId = nextLanguageId($tableRow);\n\n  if (-1 === nextId) {\n    return;\n  }\n\n  var $clone = cloneTableRow($tableRow);\n  incrementLanguageId($clone.find('input'), nextId);\n}\n/**\n * Undo Delete Language\n *\n * @param $deleter\n * @param languageManagerStrings\n */\n\n\nfunction undoDeleteLanguage($deleter, languageManagerStrings) {\n  $deleter = jQuery($deleter);\n\n  if (!$deleter.length) {\n    return;\n  }\n\n  var $row = $deleter.parents('tr');\n\n  if (!$row.length) {\n    return;\n  }\n\n  var $undo = $deleter.attr('data-action') === 'undo';\n  var callback = $undo ? function (index, input) {\n    jQuery(input).removeAttr('readonly').css('opacity', 1);\n  } : function (index, input) {\n    jQuery(input).attr('readonly', 'readonly').css('opacity', .2);\n  };\n  var label = $undo ? languageManagerStrings.languageDeleteButtonLabel : languageManagerStrings.languageUndoDeleteButtonLabel;\n  var $inputs = $row.find('input');\n  $inputs.each(callback);\n  $deleter.attr('data-action', $undo ? 'delete' : 'undo').find('span').text(label);\n  $row.find('button').toggleClass('dashicons-undo dashicons-trash');\n  changeSignToLanguageId($inputs, $undo);\n}\n/**\n * Initialize auto complete for the given input element\n *\n * @returns void\n */\n\n\nfunction setupAutocomplete($input) {\n  $input.on('autocompleteselect', function (evt, ui) {\n    var item = 'item' in ui && ui.item;\n    var language = 'language' in item && item.language;\n    var $input = jQuery(evt.currentTarget);\n\n    if (!language) {\n      return;\n    } // Let LanguageSearch do his stuffs before.\n\n\n    setTimeout(function () {\n      fillNewLanguageField($input.parents('tr'), language);\n    }, 0);\n  });\n}\n/**\n * Add the value for a language to inputs within a table row\n *\n * @param $container\n * @param language\n */\n\n\nfunction fillNewLanguageField($container, language) {\n  $container.find('.native-name').val(language.nativeName);\n  $container.find('.english-name').val(language.englishName);\n  $container.find('.iso-639-1').val(language.iso639Code1);\n  $container.find('.iso-639-2').val(language.iso639Code2);\n  $container.find('.iso-639-3').val(language.iso639Code3);\n  $container.find('.iso-639-3').val(language.iso639Code3);\n  $container.find('.locale').val(language.locale);\n  $container.find('.http-code').val(language.httpCode);\n  language.isRtl ? $container.find('.is-rtl').attr('checked', 'checked') : $container.find('.is-rtl').removeAttr('checked');\n}\n/**\n * Retrieve latest table Row\n *\n * @param $table\n * @returns {*}\n */\n\n\nfunction latestTableRow($table) {\n  return $table.find('tbody tr:last-of-type');\n}\n/**\n * Language Manager\n */\n\n\nvar LanguageManager = /*#__PURE__*/function () {\n  /**\n   * LanguageManager Constructor\n   */\n  function LanguageManager(languageManagerStrings, LanguageSearch) {\n    _classCallCheck(this, LanguageManager);\n\n    this.languageManagerStrings = languageManagerStrings;\n    this.didInit = false;\n    this.LanguageSearch = LanguageSearch;\n  }\n  /**\n   * Initialize\n   *\n   * @returns void\n   */\n\n\n  _createClass(LanguageManager, [{\n    key: \"init\",\n    value: function init() {\n      var _this = this;\n\n      if (this.didInit) {\n        return;\n      }\n\n      var $table = jQuery('#mlp-language-manager-table');\n\n      if (!$table) {\n        return;\n      }\n\n      hideElement(latestTableRow($table));\n      var $deleter = createLanguageDeleter($table, this.languageManagerStrings);\n      $deleter.on('click', function (evt) {\n        evt.preventDefault();\n        evt.stopPropagation();\n        undoDeleteLanguage(evt.currentTarget, _this.languageManagerStrings);\n      });\n      var $button = createNewLanguageButton($table, this.languageManagerStrings);\n      $button.click(function (evt) {\n        evt.preventDefault();\n        evt.stopPropagation();\n        var $latestTableRow = latestTableRow($table);\n        var $autocompleteInput = $latestTableRow.find('.native-name');\n        var languageSearch = new _this.LanguageSearch($autocompleteInput);\n        addLanguage($latestTableRow);\n        languageSearch.init();\n        setupAutocomplete($autocompleteInput);\n      });\n      this.didInit = true;\n    }\n  }]);\n\n  return LanguageManager;\n}();\n// CONCATENATED MODULE: ./build/src/modules/LanguageManager/resources/js/admin.js\n\n'use strict';\n\n(function (M, adminpage, languageManagerStrings) {\n  if (adminpage !== 'multilingualpress_page_language-manager') {\n    return;\n  }\n\n  var languageManager = new LanguageManager(languageManagerStrings, M.LanguageSearch);\n  languageManager.init();\n})(MultilingualPress, adminpage, languageManager);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///0\n")}]);
//# sourceMappingURL=admin.min.js.map