!function(e){var t={};function n(Q){if(t[Q])return t[Q].exports;var s=t[Q]={i:Q,l:!1,exports:{}};return e[Q].call(s.exports,s,s.exports,n),s.l=!0,s.exports}n.m=e,n.c=t,n.d=function(e,t,Q){n.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:Q})},n.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},n.t=function(e,t){if(1&t&&(e=n(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var Q=Object.create(null);if(n.r(Q),Object.defineProperty(Q,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var s in e)n.d(Q,s,function(t){return e[t]}.bind(null,s));return Q},n.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return n.d(t,"a",t),t},n.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},n.p="",n(n.s=0)}([function(module,__webpack_exports__,__webpack_require__){"use strict";eval('// ESM COMPAT FLAG\n__webpack_require__.r(__webpack_exports__);\n\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleNoticeHtmlElement.js\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nvar ScheduleNoticeHtmlElement = /*#__PURE__*/function () {\n  /**\n   * @param {HTMLElement} htmlElement\n   */\n  function ScheduleNoticeHtmlElement(htmlElement) {\n    _classCallCheck(this, ScheduleNoticeHtmlElement);\n\n    this.htmlElement = htmlElement;\n  }\n  /**\n   * @param {string} estimatedTimeValue\n   */\n\n\n  _createClass(ScheduleNoticeHtmlElement, [{\n    key: "updateEstimatedTime",\n    value: function updateEstimatedTime(estimatedTimeValue) {\n      try {\n        estimatedTime(this.htmlElement).innerText = estimatedTimeValue;\n      } catch (error) {\n        console.warn(error);\n      }\n    }\n    /**\n     * @param {int} attachmentsNumber\n     */\n\n  }, {\n    key: "updateTotalAttachmentsNumber",\n    value: function updateTotalAttachmentsNumber(attachmentsNumber) {\n      try {\n        totalAttachmentsNumber(this.htmlElement).innerText = attachmentsNumber;\n      } catch (error) {\n        console.warn(error);\n      }\n    }\n    /**\n     * @param {string} contentText\n     */\n\n  }, {\n    key: "updateContent",\n    value: function updateContent(contentText) {\n      try {\n        content(this.htmlElement).innerHTML = contentText;\n      } catch (error) {\n        console.warn(error);\n      }\n    }\n    /**\n     * @param {Schedule} schedule\n     */\n\n  }, {\n    key: "updateProgressBar",\n    value: function updateProgressBar(schedule) {\n      var _schedule$stepsDone = schedule.stepsDone,\n          stepsDone = _schedule$stepsDone === void 0 ? 0 : _schedule$stepsDone,\n          _schedule$allSteps = schedule.allSteps,\n          allSteps = _schedule$allSteps === void 0 ? 0 : _schedule$allSteps;\n\n      if (!stepsDone || !allSteps) {\n        return;\n      }\n\n      var progressPercentage = Math.floor(stepsDone / allSteps * 100);\n\n      try {\n        progressBarElement(this.htmlElement).style.setProperty(\'width\', progressPercentage + \'%\');\n      } catch (error) {\n        console.warn(error);\n      }\n    }\n    /**\n     * @return void\n     */\n\n  }, {\n    key: "remove",\n    value: function remove() {\n      this.htmlElement.remove();\n    }\n    /**\n     * @param {string} noticeType\n     */\n\n  }, {\n    key: "updateNoticeType",\n    value: function updateNoticeType(noticeType) {\n      this.htmlElement.classList.remove(\'notice-info\', \'notice-success\', \'notice-error\', \'notice-warning\');\n      this.htmlElement.classList.add("notice-".concat(noticeType));\n    }\n    /**\n     * @param {string} name\n     * @param {string} value\n     */\n\n  }, {\n    key: "setStyleProperty",\n    value: function setStyleProperty(name, value) {\n      this.htmlElement.style.setProperty(name, value);\n    }\n  }]);\n\n  return ScheduleNoticeHtmlElement;\n}();\n/**\n * @param {HTMLElement} parent\n * @return {HTMLElement}\n * @throws {Error}\n */\n\nfunction content(parent) {\n  var element = parent.querySelector(\'.mlp-attachment-schedule-notice__content\');\n\n  if (!element) {\n    throw new Error("Parent Element for ".concat(parent.id, " cannot be found."));\n  }\n\n  return element;\n}\n/**\n * @param {HTMLElement} parent\n * @return {HTMLElement}\n * @throws {Error}\n */\n\n\nfunction estimatedTime(parent) {\n  var element = parent.querySelector(\'.mlp-new-site-schedule-steps__estimated-remaining-time\');\n\n  if (!element) {\n    throw new Error("Parent Element for ".concat(parent.id, " cannot be found."));\n  }\n\n  return element;\n}\n/**\n * @param {HTMLElement} parent\n * @return {HTMLElement}\n * @throws {Error}\n */\n\n\nfunction totalAttachmentsNumber(parent) {\n  var element = parent.querySelector(\'.mlp-new-site-schedule-steps__total-attachments\');\n\n  if (!element) {\n    throw new Error("Parent Element for ".concat(parent.id, " cannot be found."));\n  }\n\n  return element;\n}\n/**\n * @return {Element}\n * @throws {Error}\n */\n\n\nfunction progressBarElement(parent) {\n  var progressBarEl;\n  var progressEl = parent.querySelector(\'.mlp-new-site-schedule-notice-progress\');\n\n  if (progressEl) {\n    progressBarEl = progressEl.querySelector(\'.mlp-new-site-schedule-notice-progress__bar\');\n  }\n\n  if (!progressBarEl || typeof progressBarEl === \'undefined\') {\n    throw new Error("Parent Element for ".concat(parent.id, " cannot be found."));\n  }\n\n  return progressBarEl;\n}\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/EventDispatcher.js\nfunction EventDispatcher_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction EventDispatcher_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction EventDispatcher_createClass(Constructor, protoProps, staticProps) { if (protoProps) EventDispatcher_defineProperties(Constructor.prototype, protoProps); if (staticProps) EventDispatcher_defineProperties(Constructor, staticProps); return Constructor; }\n\nvar EventDispatcher = /*#__PURE__*/function () {\n  /**\n   * @param {jQuery} dOMDocument\n   */\n  function EventDispatcher(dOMDocument) {\n    EventDispatcher_classCallCheck(this, EventDispatcher);\n\n    this.dOMDocument = dOMDocument;\n  }\n  /**\n   * @param {string} eventName\n   * @param {Array|Object} args\n   */\n\n\n  EventDispatcher_createClass(EventDispatcher, [{\n    key: "dispatch",\n    value: function dispatch(eventName) {\n      var _this$dOMDocument;\n\n      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n        args[_key - 1] = arguments[_key];\n      }\n\n      (_this$dOMDocument = this.dOMDocument).trigger.apply(_this$dOMDocument, [eventName].concat(args));\n    }\n  }]);\n\n  return EventDispatcher;\n}();\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleNotice.js\nfunction ScheduleNotice_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction ScheduleNotice_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction ScheduleNotice_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleNotice_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleNotice_defineProperties(Constructor, staticProps); return Constructor; }\n\n\nvar ACTION_SCHEDULE_NOTICE_UPDATED = \'multilingualpress.schedule_notice_updated\';\nvar ScheduleNotice = /*#__PURE__*/function () {\n  /**\n   * @param {jQuery} jQuery\n   * @param {EventDispatcher} eventDispatcher\n   * @param {ScheduleNoticeHtmlElement} scheduleNoticeHtmlElement\n   * @param {ScheduleStatusStorage} scheduleStatusStorage\n   */\n  function ScheduleNotice(jQuery, eventDispatcher, scheduleNoticeHtmlElement, scheduleStatusStorage) {\n    ScheduleNotice_classCallCheck(this, ScheduleNotice);\n\n    this.jQuery = jQuery;\n    this.eventDispatcher = eventDispatcher;\n    this.scheduleNoticeHtmlElement = scheduleNoticeHtmlElement;\n    this.scheduleStatusStorage = scheduleStatusStorage;\n  }\n  /**\n   * Remove the schedule admin notice element from the DOM\n   *\n   * @return void\n   */\n\n\n  ScheduleNotice_createClass(ScheduleNotice, [{\n    key: "remove",\n    value: function remove() {\n      this.scheduleNoticeHtmlElement.remove();\n    }\n    /**\n     * Update the admin notice with a content\n     *\n     * @param {string} content\n     * @param {string} type\n     * @return void\n     */\n\n  }, {\n    key: "updateScheduleNoticeWithMessage",\n    value: function updateScheduleNoticeWithMessage(content, type) {\n      if (!content) {\n        return;\n      }\n\n      this.scheduleNoticeHtmlElement.updateContent(content);\n      type && this.scheduleNoticeHtmlElement.updateNoticeType(type);\n    }\n    /**\n     * Update the schedule notice with new information for schedule by the server\n     *\n     * @param {ScheduleStatus} scheduleStatus\n     *\n     * @return void\n     */\n\n  }, {\n    key: "updateScheduleNoticeWithStatus",\n    value: function updateScheduleNoticeWithStatus(scheduleStatus) {\n      var schedule = scheduleStatus.schedule,\n          estimatedRemainingTime = scheduleStatus.estimatedRemainingTime;\n      var attachmentsNumber = schedule.args.attachmentsNumber;\n      this.scheduleNoticeHtmlElement.updateTotalAttachmentsNumber(attachmentsNumber);\n      this.scheduleNoticeHtmlElement.updateEstimatedTime(estimatedRemainingTime);\n      this.scheduleNoticeHtmlElement.updateProgressBar(schedule);\n      this.scheduleStatusStorage.updateSetWithStatus(scheduleStatus);\n      this.eventDispatcher.dispatch(ACTION_SCHEDULE_NOTICE_UPDATED, schedule);\n    }\n    /**\n     * @return void\n     */\n\n  }, {\n    key: "show",\n    value: function show() {\n      this.scheduleNoticeHtmlElement.setStyleProperty(\'display\', \'flex\');\n    }\n    /**\n     * @return void\n     */\n\n  }, {\n    key: "hide",\n    value: function hide() {\n      this.scheduleNoticeHtmlElement.setStyleProperty(\'display\', \'none\');\n    }\n  }]);\n\n  return ScheduleNotice;\n}();\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleStatus.js\nfunction ScheduleStatus_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nvar ScheduleStatus =\n/**\n * Do not create this instance directly use ScheduleStatusFactory\n *\n * @param {Schedule} schedule\n * @param {int} stepToFinish\n * @param {string} estimatedRemainingTime\n */\nfunction ScheduleStatus(_ref) {\n  var schedule = _ref.schedule,\n      stepToFinish = _ref.stepToFinish,\n      estimatedRemainingTime = _ref.estimatedRemainingTime;\n\n  ScheduleStatus_classCallCheck(this, ScheduleStatus);\n\n  this.schedule = schedule;\n  this.stepToFinish = stepToFinish;\n  this.estimatedRemainingTime = estimatedRemainingTime;\n};\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleStatusFactory.js\nfunction ScheduleStatusFactory_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction ScheduleStatusFactory_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction ScheduleStatusFactory_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleStatusFactory_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleStatusFactory_defineProperties(Constructor, staticProps); return Constructor; }\n\n\nvar ScheduleStatusFactory_ScheduleStatusFactory = /*#__PURE__*/function () {\n  /**\n   * @param {ScheduleFactory} scheduleFactory\n   */\n  function ScheduleStatusFactory(scheduleFactory) {\n    ScheduleStatusFactory_classCallCheck(this, ScheduleStatusFactory);\n\n    this.scheduleFactory = scheduleFactory;\n  }\n  /**\n   * @params {Object} args\n   * @return {ScheduleStatus}\n   */\n\n\n  ScheduleStatusFactory_createClass(ScheduleStatusFactory, [{\n    key: "create",\n    value: function create(args) {\n      var cloned = Object.assign({}, args);\n      var _cloned$schedule = cloned.schedule,\n          schedule = _cloned$schedule === void 0 ? {} : _cloned$schedule;\n      cloned.schedule = this.scheduleFactory.create(schedule);\n      var scheduleStatus = new ScheduleStatus(cloned);\n      return Object.freeze(scheduleStatus);\n    }\n  }]);\n\n  return ScheduleStatusFactory;\n}();\n// CONCATENATED MODULE: ./build/resources/js/utils.js\n/**\n * @param {Object} object\n * @returns {boolean}\n */\nfunction isElement(object) {\n  return object instanceof Element;\n}\n/**\n * @param {Object} property\n * @returns {boolean}\n */\n\n\nfunction isUndefined(property) {\n  return typeof property !== \'undefined\';\n}\n/**\n * @param {string} functionName\n * @returns {boolean}\n */\n\n\nfunction isFunction(functionName) {\n  return typeof functionName === \'function\';\n}\n/**\n * Utils\n *\n * @type {{isElement: *}}\n */\n\n\nvar utils = {\n  isElement: isElement,\n  isUndefined: isUndefined,\n  isFunction: isFunction\n};\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/Form.js\nfunction Form_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction Form_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction Form_createClass(Constructor, protoProps, staticProps) { if (protoProps) Form_defineProperties(Constructor.prototype, protoProps); if (staticProps) Form_defineProperties(Constructor, staticProps); return Constructor; }\n\n\n/**\n * Form Class\n */\n\nvar Form_Form = /*#__PURE__*/function () {\n  /**\n   * @param {HTMLElement} form\n   * @param {Object} translations\n   * @param {Function} alert\n   */\n  function Form(form, translations, alert) {\n    Form_classCallCheck(this, Form);\n\n    this.form = form;\n    this.translations = translations;\n    this.alert = alert;\n    this.eventCallback = this.preventFormSubmission.bind(this);\n  }\n  /**\n   * Block the submission of the form that are within the page\n   */\n\n\n  Form_createClass(Form, [{\n    key: "blockFormSubmission",\n    value: function blockFormSubmission() {\n      this.form.addEventListener(\'submit\', this.eventCallback);\n    }\n    /**\n     * Release Form Submission, allowing to submit forms again\n     */\n\n  }, {\n    key: "releaseFormSubmission",\n    value: function releaseFormSubmission() {\n      this.form.removeEventListener(\'submit\', this.eventCallback);\n    }\n    /**\n     * @param {Event} event\n     */\n\n  }, {\n    key: "preventFormSubmission",\n    value: function preventFormSubmission(event) {\n      event.preventDefault();\n      event.stopImmediatePropagation();\n\n      if (!utils.isUndefined(this.translations.preventFormSubmissionMessage)) {\n        this.alert(this.translations.preventFormSubmissionMessage);\n      }\n    }\n  }]);\n\n  return Form;\n}();\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleStatusUpdater.js\nfunction ScheduleStatusUpdater_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction ScheduleStatusUpdater_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction ScheduleStatusUpdater_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleStatusUpdater_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleStatusUpdater_defineProperties(Constructor, staticProps); return Constructor; }\n\nvar ScheduleStatusUpdater = /*#__PURE__*/function () {\n  /**\n   * @param {Object} requestClient\n   * @param {ScheduleStatusResponseHandler} scheduleStatusResponseHandler\n   * @param {Form} form\n   * @param {Document} domDocument\n   * @param {string} ajaxUrl\n   */\n  function ScheduleStatusUpdater(requestClient, scheduleStatusResponseHandler, form, domDocument, ajaxUrl) {\n    ScheduleStatusUpdater_classCallCheck(this, ScheduleStatusUpdater);\n\n    this.requestClient = requestClient;\n    this.scheduleStatusResponseHandler = scheduleStatusResponseHandler;\n    this.form = form;\n    this.domDocument = domDocument;\n    this.ajaxUrl = ajaxUrl;\n    this.ajaxEvent = null;\n  }\n  /**\n   * Retrieve information for the current cron job by the server\n   *\n   * @return void\n   */\n\n\n  ScheduleStatusUpdater_createClass(ScheduleStatusUpdater, [{\n    key: "update",\n    value: function update() {\n      var _this = this;\n\n      this.ajaxEvent = this.requestClient({\n        url: this.ajaxUrl,\n        complete: function complete(jqXHR, textStatus) {\n          var success = jqXHR.responseJSON.success;\n          var errorStatuses = [\'error\', \'abort\', \'parsererror\'];\n\n          if (errorStatuses.includes(textStatus)) {\n            return false;\n          }\n\n          success && _this.delayUpdate();\n        },\n        success: function success(response) {\n          return _this.scheduleStatusResponseHandler.successHandler(response);\n        },\n        error: function error() {\n          return _this.scheduleStatusResponseHandler.errorHandler();\n        }\n      });\n    }\n    /**\n     * @return void\n     */\n\n  }, {\n    key: "delayUpdate",\n    value: function delayUpdate() {\n      setTimeout(this.update, 1000);\n    }\n    /**\n     * @return void\n     */\n\n  }, {\n    key: "detachAjaxEvent",\n    value: function detachAjaxEvent() {\n      this.ajaxEvent && this.domDocument.off(\'ajaxSend\', this.ajaxEvent);\n    }\n  }]);\n\n  return ScheduleStatusUpdater;\n}();\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleStatusResponseHandler.js\nfunction ScheduleStatusResponseHandler_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction ScheduleStatusResponseHandler_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction ScheduleStatusResponseHandler_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleStatusResponseHandler_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleStatusResponseHandler_defineProperties(Constructor, staticProps); return Constructor; }\n\nvar ACTION_SCHEDULE_STATUS_UPDATE_ERROR = \'multilingualpress.schedule_status_update_error\';\nvar ACTION_SCHEDULE_STATUS_UPDATED = \'multilingualpress.schedule_status_updated\';\nvar ScheduleStatusResponseHandler = /*#__PURE__*/function () {\n  /**\n   * @param {ScheduleNotice} scheduleNotice\n   * @param {EventDispatcher} eventDispatcher\n   * @param {ScheduleStatusFactory} scheduleStatusFactory\n   * @param form\n   * @param {*} translations\n   */\n  function ScheduleStatusResponseHandler(scheduleNotice, eventDispatcher, scheduleStatusFactory, form, translations) {\n    ScheduleStatusResponseHandler_classCallCheck(this, ScheduleStatusResponseHandler);\n\n    this.scheduleNotice = scheduleNotice;\n    this.eventDispatcher = eventDispatcher;\n    this.scheduleStatusFactory = scheduleStatusFactory;\n    this.form = form;\n    this.translations = translations;\n  }\n  /**\n   * @param {Object} response\n   */\n\n\n  ScheduleStatusResponseHandler_createClass(ScheduleStatusResponseHandler, [{\n    key: "successHandler",\n    value: function successHandler(response) {\n      var _response$data = response.data,\n          data = _response$data === void 0 ? {} : _response$data,\n          _response$success = response.success,\n          success = _response$success === void 0 ? false : _response$success;\n      /*\n       * There\'s not case for schedule succeed.\n       * When the schedule ends it will not exists, means this catch also\n       * the case when the schedule succeed.\n       */\n\n      if (!success) {\n        this.scheduleNotice.remove();\n        this.eventDispatcher.dispatch(ACTION_SCHEDULE_STATUS_UPDATE_ERROR);\n        return;\n      }\n\n      this.scheduleNotice.show();\n      var scheduleStatus = this.scheduleStatusFactory.create(data);\n      this.scheduleNotice.updateScheduleNoticeWithStatus(scheduleStatus);\n      this.eventDispatcher.dispatch(ACTION_SCHEDULE_STATUS_UPDATED, response);\n    }\n    /**\n     * @param {jqXHR} jqXHR\n     * @param {string} textStatus\n     * @param {string} errorThrown\n     */\n\n  }, {\n    key: "errorHandler",\n    value: function errorHandler(jqXHR, textStatus, errorThrown) {\n      this.scheduleNotice.updateScheduleNoticeWithMessage(this.translations.scheduleInfoErrorMessage, \'error\');\n      this.eventDispatcher.dispatch(ACTION_SCHEDULE_STATUS_UPDATE_ERROR, {\n        message: errorThrown\n      });\n    }\n  }]);\n\n  return ScheduleStatusResponseHandler;\n}();\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/Spinner.js\nfunction Spinner_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction Spinner_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction Spinner_createClass(Constructor, protoProps, staticProps) { if (protoProps) Spinner_defineProperties(Constructor.prototype, protoProps); if (staticProps) Spinner_defineProperties(Constructor, staticProps); return Constructor; }\n\n\nvar POSITION_BEFORE_BEGIN = \'beforebegin\';\nvar POSITION_AFTER_BEGIN = \'afterbegin\';\nvar POSITION_BEFORE_END = \'beforeend\';\nvar POSITION_AFTER_END = \'afterend\';\nvar VALID_POSITIONS = [POSITION_BEFORE_BEGIN, POSITION_AFTER_BEGIN, POSITION_BEFORE_END, POSITION_AFTER_END];\nvar Spinner_Spinner = /*#__PURE__*/function () {\n  /**\n   * @param {string} position\n   * @param {string} selector\n   * @param {string} template\n   */\n  function Spinner(position, selector, template) {\n    Spinner_classCallCheck(this, Spinner);\n\n    if (!positionIsAllowed(position)) {\n      throw new Error("Position accept only the following values: \\"".concat(VALID_POSITIONS, "\\""));\n    }\n\n    this.position = position;\n    this.selector = selector;\n    this.template = template;\n  }\n  /**\n   * @param {Element} element\n   */\n\n\n  Spinner_createClass(Spinner, [{\n    key: "replaceInto",\n    value: function replaceInto(element) {\n      if (!utils.isElement(element)) {\n        return;\n      }\n\n      this.removeFrom(element);\n      this.insertInto(element);\n    }\n    /**\n     * @param {Element} element\n     */\n\n  }, {\n    key: "insertInto",\n    value: function insertInto(element) {\n      if (!utils.isElement(element)) {\n        return;\n      }\n\n      element.insertAdjacentHTML(this.position, this.template);\n    }\n    /**\n     * @param {Element} element\n     */\n\n  }, {\n    key: "removeFrom",\n    value: function removeFrom(element) {\n      if (!utils.isElement(element)) {\n        return;\n      }\n\n      var existingSpinner = element.querySelector(this.selector);\n      existingSpinner && existingSpinner.remove();\n    }\n  }]);\n\n  return Spinner;\n}();\n/**\n * @param {string} position\n * @return {boolean}\n */\n\nfunction positionIsAllowed(position) {\n  return VALID_POSITIONS.includes(position);\n}\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleArguments.js\nfunction ScheduleArguments_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nvar ScheduleArguments =\n/**\n * @param {int} sourceSiteId\n * @param {int} newSiteId\n * @param {int} attachmentsNumber\n */\nfunction ScheduleArguments(_ref) {\n  var sourceSiteId = _ref.sourceSiteId,\n      newSiteId = _ref.newSiteId,\n      attachmentsNumber = _ref.attachmentsNumber;\n\n  ScheduleArguments_classCallCheck(this, ScheduleArguments);\n\n  this.sourceSiteId = sourceSiteId;\n  this.newSiteId = newSiteId;\n  this.attachmentsNumber = attachmentsNumber;\n};\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/Schedule.js\nfunction Schedule_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nvar Schedule =\n/**\n * @param {string} id\n * @param {int} stepsDone\n * @param {int} allSteps\n * @param {int} started\n * @param {int} lastUpdate\n * @param {ScheduleArguments} args\n */\nfunction Schedule(_ref) {\n  var id = _ref.id,\n      stepsDone = _ref.stepsDone,\n      allSteps = _ref.allSteps,\n      started = _ref.started,\n      lastUpdate = _ref.lastUpdate,\n      args = _ref.args;\n\n  Schedule_classCallCheck(this, Schedule);\n\n  this.id = id;\n  this.stepsDone = stepsDone;\n  this.allSteps = allSteps;\n  this.started = started;\n  this.lastUpdate = lastUpdate;\n  this.args = args;\n};\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleFactory.js\nfunction ScheduleFactory_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction ScheduleFactory_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction ScheduleFactory_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleFactory_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleFactory_defineProperties(Constructor, staticProps); return Constructor; }\n\n\n\nvar ScheduleFactory_ScheduleFactory = /*#__PURE__*/function () {\n  function ScheduleFactory() {\n    ScheduleFactory_classCallCheck(this, ScheduleFactory);\n  }\n\n  ScheduleFactory_createClass(ScheduleFactory, [{\n    key: "create",\n    value:\n    /**\n     * @param {Object} data\n     * @return {Schedule}\n     */\n    function create(data) {\n      var cloned = Object.assign({}, data);\n      var _cloned$args = cloned.args,\n          args = _cloned$args === void 0 ? {} : _cloned$args;\n      cloned.args = Object.freeze(new ScheduleArguments(args));\n      var schedule = new Schedule(cloned);\n      return Object.freeze(schedule);\n    }\n  }]);\n\n  return ScheduleFactory;\n}();\n// CONCATENATED MODULE: ./build/resources/js/Nonce.js\nfunction Nonce_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nvar Nonce =\n/**\n * @param nonce\n * @param action\n */\nfunction Nonce(nonce, action) {\n  Nonce_classCallCheck(this, Nonce);\n\n  if (typeof nonce !== \'string\' || !nonce) {\n    throw new Error(\'Expected nonce to be a string\');\n  }\n\n  if (typeof action !== \'string\' || !action) {\n    throw new Error(\'Expected action to be a string\');\n  }\n\n  this.nonce = nonce;\n  this.action = action;\n};\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/action/StopAttachmentDuplicationProcessClient.js\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction StopAttachmentDuplicationProcessClient_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction StopAttachmentDuplicationProcessClient_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction StopAttachmentDuplicationProcessClient_createClass(Constructor, protoProps, staticProps) { if (protoProps) StopAttachmentDuplicationProcessClient_defineProperties(Constructor.prototype, protoProps); if (staticProps) StopAttachmentDuplicationProcessClient_defineProperties(Constructor, staticProps); return Constructor; }\n\nvar StopAttachmentDuplicationProcessClient = /*#__PURE__*/function () {\n  /**\n   * @param {*} request\n   * @param {string} ajaxUrl\n   * @param {Nonce} nonce\n   * @param {string} action\n   * @param {StopAttachmentDuplicationProcessResponseHandler} responseHandler\n   * @param {Spinner} spinner\n   */\n  function StopAttachmentDuplicationProcessClient(request, ajaxUrl, nonce, action, responseHandler, spinner) {\n    StopAttachmentDuplicationProcessClient_classCallCheck(this, StopAttachmentDuplicationProcessClient);\n\n    this.request = request;\n    this.ajaxUrl = ajaxUrl;\n    this.nonce = nonce;\n    this.action = action;\n    this.responseHandler = responseHandler;\n    this.spinner = spinner;\n  }\n  /**\n   * @param {Object} target\n   * @param {Schedule} schedule\n   */\n\n\n  StopAttachmentDuplicationProcessClient_createClass(StopAttachmentDuplicationProcessClient, [{\n    key: "call",\n    value: function call(target, _ref) {\n      var _data,\n          _this = this;\n\n      var _ref$schedule = _ref.schedule,\n          schedule = _ref$schedule === void 0 ? null : _ref$schedule;\n\n      if (!schedule) {\n        return;\n      }\n\n      var data = (_data = {\n        action: this.action\n      }, _defineProperty(_data, this.action, \'stop_attachments_copy\'), _defineProperty(_data, this.nonce.action, this.nonce.nonce), _defineProperty(_data, "scheduleId", schedule.id), _defineProperty(_data, "siteId", schedule.args.newSiteId), _data);\n      this.request({\n        url: this.ajaxUrl,\n        data: data,\n        method: \'POST\',\n        beforeSend: function beforeSend() {\n          return _this.spinner.replaceInto(target.parentNode);\n        },\n        complete: function complete() {\n          return _this.spinner.removeFrom(target.parentNode);\n        },\n        success: function success(response) {\n          return _this.responseHandler.success(response);\n        },\n        error: function error(jqXHR, textStatus, errorThrown) {\n          return _this.responseHandler.error(jqXHR, textStatus, errorThrown);\n        }\n      });\n    }\n  }]);\n\n  return StopAttachmentDuplicationProcessClient;\n}();\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/action/StopAttachmentDuplicationProcessResponseHandler.js\nfunction StopAttachmentDuplicationProcessResponseHandler_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction StopAttachmentDuplicationProcessResponseHandler_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction StopAttachmentDuplicationProcessResponseHandler_createClass(Constructor, protoProps, staticProps) { if (protoProps) StopAttachmentDuplicationProcessResponseHandler_defineProperties(Constructor.prototype, protoProps); if (staticProps) StopAttachmentDuplicationProcessResponseHandler_defineProperties(Constructor, staticProps); return Constructor; }\n\nvar ACTION_STOP_ATTACHMENT_DUPLICATION_SUCCEED = \'multilingualpress.stop_attachment_duplication_succeed\';\nvar ACTION_STOP_ATTACHMENT_DUPLICATION_FAILS = \'multilingualpress.stop_attachment_duplication_fails\';\nvar StopAttachmentDuplicationProcessResponseHandler = /*#__PURE__*/function () {\n  /**\n   * @param {ScheduleNotice} scheduleNotice\n   * @param {EventDispatcher} eventDispatcher\n   */\n  function StopAttachmentDuplicationProcessResponseHandler(scheduleNotice, eventDispatcher) {\n    StopAttachmentDuplicationProcessResponseHandler_classCallCheck(this, StopAttachmentDuplicationProcessResponseHandler);\n\n    this.scheduleNotice = scheduleNotice;\n    this.eventDispatcher = eventDispatcher;\n  }\n  /**\n   * @param response\n   */\n\n\n  StopAttachmentDuplicationProcessResponseHandler_createClass(StopAttachmentDuplicationProcessResponseHandler, [{\n    key: "success",\n    value: function success(response) {\n      var _response$data$conten = response.data.content,\n          content = _response$data$conten === void 0 ? \'\' : _response$data$conten,\n          _response$success = response.success,\n          success = _response$success === void 0 ? false : _response$success;\n      this.scheduleNotice.updateScheduleNoticeWithMessage(content, success ? \'success\' : \'error\');\n      success && this.eventDispatcher.dispatch(ACTION_STOP_ATTACHMENT_DUPLICATION_SUCCEED, response);\n      !success && this.eventDispatcher.dispatch(ACTION_STOP_ATTACHMENT_DUPLICATION_FAILS, response);\n    }\n    /**\n     * @param jqXHR\n     * @param textStatus\n     * @param errorThrown\n     */\n\n  }, {\n    key: "error",\n    value: function error(jqXHR, textStatus, errorThrown) {\n      this.scheduleNotice.updateScheduleNoticeWithMessage("".concat(textStatus, " : ").concat(errorThrown), \'error\');\n    }\n  }]);\n\n  return StopAttachmentDuplicationProcessResponseHandler;\n}();\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/schedule/ScheduleStatusStorage.js\nfunction ScheduleStatusStorage_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }\n\nfunction ScheduleStatusStorage_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction ScheduleStatusStorage_createClass(Constructor, protoProps, staticProps) { if (protoProps) ScheduleStatusStorage_defineProperties(Constructor.prototype, protoProps); if (staticProps) ScheduleStatusStorage_defineProperties(Constructor, staticProps); return Constructor; }\n\nvar ScheduleStatusStorage = /*#__PURE__*/function () {\n  /**\n   * @param {HTMLElement} htmlElement\n   * @param {ScheduleStatusFactory} scheduleStatusFactory\n   */\n  function ScheduleStatusStorage(htmlElement, scheduleStatusFactory) {\n    ScheduleStatusStorage_classCallCheck(this, ScheduleStatusStorage);\n\n    this.htmlElement = htmlElement;\n    this.scheduleStatusFactory = scheduleStatusFactory;\n  }\n  /**\n   * @param {ScheduleStatus} scheduleStatus\n   */\n\n\n  ScheduleStatusStorage_createClass(ScheduleStatusStorage, [{\n    key: "updateSetWithStatus",\n    value: function updateSetWithStatus(scheduleStatus) {\n      this.htmlElement.dataset.currentSchedule = JSON.stringify(scheduleStatus);\n    }\n    /**\n     * @return {ScheduleStatus}\n     */\n\n  }, {\n    key: "status",\n    value: function status() {\n      if (typeof this.htmlElement.dataset.currentSchedule !== \'undefined\') {\n        return {};\n      }\n\n      var scheduleStatus = this.scheduleStatusFactory.create(JSON.parse(this.htmlElement.dataset.currentSchedule));\n      return scheduleStatus;\n    }\n  }]);\n\n  return ScheduleStatusStorage;\n}();\n// CONCATENATED MODULE: ./build/resources/js/siteDuplication/admin.js\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n(function (jQuery, adminpage, siteDuplicatorScheduleData) {\n  /**\n   * Create the admin notice UI where to show the information about the current\n   * tasks performed by the server.\n   *\n   * @return {*}\n   */\n  function initializeScheduleNoticeUI() {\n    var scheduleNoticeTemplate = document.querySelector(\'#mlp_new_site_schedule_tmpl\');\n\n    if (!scheduleNoticeTemplate) {\n      throw new Error(\'Schedule Notice Template does not exists.\');\n    }\n\n    document.querySelector(\'#add-new-site\').insertAdjacentHTML(\'afterend\', scheduleNoticeTemplate.innerHTML);\n  }\n  /**\n   * ScheduleNoticeHtmlElement Factory\n   *\n   * @return {ScheduleNoticeHtmlElement}\n   */\n\n\n  function scheduleNoticeHtmlElementFactory() {\n    var scheduleNoticeHtmlElement = document.querySelector(\'.mlp-attachment-schedule-notice\');\n\n    if (!scheduleNoticeHtmlElement) {\n      throw new TypeError(\'Impossible to retrieve the schedule notice html element. Element does not exists\');\n    }\n\n    scheduleNoticeHtmlElement = new ScheduleNoticeHtmlElement(scheduleNoticeHtmlElement);\n    return scheduleNoticeHtmlElement;\n  }\n  /**\n   * @return {HTMLFormElement}\n   */\n\n\n  function formHtmlElementFactory() {\n    // TODO May be a better selector to prevent to get wrong form\n    var formHtmlElement = document.querySelector(\'form\');\n\n    if (!formHtmlElement) {\n      throw new TypeError(\'No form exists in this page.\');\n    }\n\n    return formHtmlElement;\n  }\n  /**\n   * @return {*}\n   */\n\n\n  function translationsFactory() {\n    var hasTranslations = siteDuplicatorScheduleData.hasOwnProperty(\'attachmentDuplicatorTranslations\');\n\n    if (!hasTranslations) {\n      throw new Error(\'Translations for Site Duplication Schedule are missing\');\n    }\n\n    return siteDuplicatorScheduleData.attachmentDuplicatorTranslations;\n  }\n  /**\n   * @return {*}\n   */\n\n\n  function initializeContainer() {\n    var scheduleUrl = siteDuplicatorScheduleData.scheduleUrl,\n        _siteDuplicatorSchedu = siteDuplicatorScheduleData.ajaxUrl,\n        ajaxUrl = _siteDuplicatorSchedu === void 0 ? \'\' : _siteDuplicatorSchedu;\n    var domDocument = jQuery(document); // TODO Create a lazy loader container because right know dependencies have to be\n    //      created before them are used and maintenance will be difficult.\n\n    if (!ajaxUrl) {\n      throw new TypeError(\'ajaxUrl must be set or schedule notice will not work\');\n    }\n\n    var translations = translationsFactory();\n    var form = new Form_Form(formHtmlElementFactory(), translations, alert);\n    var eventDispatcher = new EventDispatcher(domDocument);\n    var spinner = new Spinner_Spinner(POSITION_BEFORE_BEGIN, \'.spinner\', \'<span class="spinner is-active"></span>\');\n    var scheduleFactory = new ScheduleFactory_ScheduleFactory();\n    var scheduleStatusFactory = new ScheduleStatusFactory_ScheduleStatusFactory(scheduleFactory);\n    var scheduleNoticeHtmlElement = scheduleNoticeHtmlElementFactory();\n    var scheduleStatusStorage = new ScheduleStatusStorage(scheduleNoticeHtmlElement, scheduleStatusFactory);\n    var scheduleNotice = new ScheduleNotice(jQuery, eventDispatcher, scheduleNoticeHtmlElement, scheduleStatusStorage);\n    var scheduleStatusResponseHandler = new ScheduleStatusResponseHandler(scheduleNotice, eventDispatcher, scheduleStatusFactory, form, translations);\n    var scheduleStatusUpdater = new ScheduleStatusUpdater(jQuery.ajax, scheduleStatusResponseHandler, form, domDocument, scheduleUrl);\n    var _siteDuplicatorSchedu2 = siteDuplicatorScheduleData.attachmentDuplicatorActions,\n        nonce = _siteDuplicatorSchedu2.nonce,\n        nonceAction = _siteDuplicatorSchedu2.nonceAction,\n        nameAjaxHook = _siteDuplicatorSchedu2.nameAjaxHook;\n    var stopAttachmentDuplicationProcessResponseHandler = new StopAttachmentDuplicationProcessResponseHandler(scheduleNotice, eventDispatcher);\n    var stopAttachmentDuplicationProcessClient = new StopAttachmentDuplicationProcessClient(jQuery.ajax, ajaxUrl, new Nonce(nonce, nonceAction), nameAjaxHook, stopAttachmentDuplicationProcessResponseHandler, spinner);\n    return {\n      domDocument: domDocument,\n      scheduleNotice: scheduleNotice,\n      scheduleStatusStorage: scheduleStatusStorage,\n      scheduleStatusFactory: scheduleStatusFactory,\n      scheduleStatusResponseHandler: scheduleStatusResponseHandler,\n      scheduleStatusUpdater: scheduleStatusUpdater,\n      eventDispatcher: eventDispatcher,\n      form: form,\n      translations: translations,\n      spinner: spinner,\n      ajaxUrl: ajaxUrl,\n      stopAttachmentDuplicationProcessClient: stopAttachmentDuplicationProcessClient\n    };\n  }\n  /**\n   * Bootstrap Schedule Actions\n   *\n   * @params {*} container\n   *\n   * @return void\n   */\n\n\n  function bootstrapScheduleActions(container) {\n    var stopAttachmentDuplicationProcessClient = container.stopAttachmentDuplicationProcessClient,\n        domDocument = container.domDocument,\n        form = container.form,\n        scheduleStatusUpdater = container.scheduleStatusUpdater,\n        scheduleStatusStorage = container.scheduleStatusStorage;\n    window.addEventListener(\'load\', function () {\n      return scheduleStatusUpdater.update();\n    }, {\n      once: true\n    });\n    var remover = document.querySelector(\'#mlp_kill_attachment_duplication\');\n    remover && remover.addEventListener(\'click\', function (event) {\n      return stopAttachmentDuplicationProcessClient.call(event.currentTarget || event.target, scheduleStatusStorage.status());\n    });\n    domDocument.on(ACTION_SCHEDULE_STATUS_UPDATE_ERROR, function () {\n      return form.releaseFormSubmission();\n    });\n    domDocument.on(ACTION_STOP_ATTACHMENT_DUPLICATION_SUCCEED, function (_ref) {\n      var _ref$success = _ref.success,\n          success = _ref$success === void 0 ? false : _ref$success;\n\n      if (!success) {\n        return;\n      }\n\n      form.releaseFormSubmission();\n      scheduleStatusUpdater.detachAjaxEvent();\n    });\n  }\n  /**\n   * Bootstrap the package\n   *\n   * @return void\n   */\n\n\n  function bootstrap(container) {\n    var scheduleNotice = container.scheduleNotice;\n    scheduleNotice.hide();\n    bootstrapScheduleActions(container);\n  }\n\n  if (adminpage !== \'site-new-php\') {\n    return;\n  }\n\n  if (!siteDuplicatorScheduleData) {\n    console.warn(\'No schedule data available, duplication notice will not work as expected.\');\n    return;\n  }\n\n  try {\n    initializeScheduleNoticeUI();\n    setTimeout(function () {\n      var container = initializeContainer();\n      bootstrap(container);\n    }, 1000);\n  } catch (error) {\n    console.warn(error.message);\n  }\n})(jQuery, adminpage, window.siteDuplicatorScheduleData);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///0\n')}]);
//# sourceMappingURL=site-duplication-admin.min.js.map